\name{Vangle}
\alias{Vangle}
\title{V-Angle
}
\description{Draw an arc between two vectors represented by three  points.
}
\usage{
Vangle(P1, P2, P3, rad = 1, lty = 1, lwd = 1, col = "black", parrow = -1, alen = 0.1)
}
\arguments{
  \item{P1}{x,y point, list or vector
}
  \item{P2}{x,y point, list or vector
}
  \item{P3}{x,y point, list or vector
}
  \item{rad}{radius for drawing
}
  \item{lty}{ line type
}
  \item{lwd}{ line width
}
  \item{col}{ color
}
  \item{parrow}{ arrow percent along
}
  \item{alen}{ length for arrow
}
}
\details{ draws the arrow in a right hand way, i.e. from point 1 to point 3 withright thumb facing out.
}
\value{list:
\item{ang}{angle in radians, }
\item{angle}{angle in degrees}
\item{n}{ number of points in arc}
\item{garc}{list of xy coordinates}
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{Be careful about the order of the three points.
}


\seealso{angBAC
}
\examples{



P1 = c(2,2)
P2 = c(10,4)
P3 = c(6,8)
plot(c(0, 20), c(0, 10) , type='n', asp=1  )

points(P1[1], P1[2], pch=10)
points(P2[1], P2[2], pch=10)
points(P3[1], P3[2], pch=10)

text(P1[1], P1[2], labels="P1", pos=1)
text(P2[1], P2[2], labels="P2", pos=1)
text(P3[1], P3[2], labels="P3", pos=1)

segments(P1[1], P1[2], P2[1], P2[2])
segments(P3[1], P3[2],P2[1], P2[2])

a = Vangle(P3, P2, P1, rad=1)



}
\keyword{misc}
