\name{VecAngle}
\alias{VecAngle}
\title{Vector Angle
}
\description{Get the angle from 2 vectors
}
\usage{
VecAngle(V1, V2, r = 1, snake = NULL, pos = 3, laboutside = TRUE, lty = 1, lwd = 1, col = "black", sig.digits = 1)
}
\arguments{
  \item{V1}{Vector 1
}
  \item{V2}{Vector 2
}
  \item{r}{radius
}
  \item{snake}{snake points
}
  \item{pos}{position to label
}
  \item{laboutside}{which side to label
}
  \item{lty}{line type
}
  \item{lwd}{line width
}
  \item{col}{color
}
  \item{sig.digits}{significant digits
}
}
\details{Two vectors are needed for this.
}
\value{The line of the angle arc.
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{SnakeLabel
}
\examples{

plot(c(0, 50), c(0, 10) , type='n', asp=1  )

P1 = list(x=10, y=4)

P2 = list(x=40, y=6)
P3 = list(x=20, y=15)


 points(P1)
points(P2)
points(P3)
text(P1, labels='P1', pos=3)
text(P2, labels='P2', pos=3)
text(P3,labels='P3', pos=3)



V1 = list(x=c(P1$x, P2$x) , y = c(P1$y, P2$y) )
V2 = list(x=c(P1$x, P3$x) , y = c(P1$y, P3$y) )
 V1 = c(V1$x[1], V1$y[1], V1$x[2], V1$y[2] ) 
V2 = c(V2$x[1], V2$y[1], V2$x[2], V2$y[2] ) 



arrows(P1$x, P1$y, P2$x, P2$y, length=0.1) 

arrows(P1$x, P1$y, P3$x, P3$y, length=0.1) 


VecAngle(V1, V2, r=10, snake=NULL, pos=3 )




}
\keyword{misc}
