\name{angBAC}
\alias{angBAC}
\title{Get Angle from points
}
\description{Get angle at apex of three points
}
\usage{
angBAC(PB, PA, PC)
}
\arguments{
  \item{PB}{2-vector points, or point list (x,y)
}
  \item{PA}{2-vector points, or point list (x,y)
}
  \item{PC}{2-vector points, or point list (x,y)
}
}
\details{Points can be either 2-vectors or list of x,y.
}
\value{angle in radians
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{Vangle
}
\examples{

P1 = c(2,2)
P2 = c(10,4)
P3 = c(6,8)
XY = rbind(P1,P2, P3)
x1 = XY[,1]
y1 = XY[,2]

plot(range(x1), range(y1), asp=1, xlab='m', type='n' , ylab='m' )
points(P1[1], P1[2], pch=10)
points(P2[1], P2[2], pch=10)
points(P3[1], P3[2], pch=10)

text(P1[1], P1[2], labels="P1", pos=1)
text(P2[1], P2[2], labels="P2", pos=1)
text(P3[1], P3[2], labels="P3", pos=1)

segments(P1[1], P1[2], P2[1], P2[2])
segments(P3[1], P3[2],P2[1], P2[2])

alpha = angBAC(P1, P2, P3)
alpha*180/pi

}
\keyword{misc}
