\name{draw.humanstick}
\alias{draw.humanstick}
\title{Stick Figure
}
\description{Draw a stick figure
}
\usage{
draw.humanstick(x, y, siz = siz, col = "black", border = "black", standing = FALSE)
}
\arguments{
  \item{x}{x-coordinate
}
  \item{y}{y-coordinate
}
  \item{siz}{size
}
  \item{col}{color
}
  \item{border}{border, logical
}
  \item{standing}{logical, point at foot?
}
}
\details{
If standing=TRUE, the x,y is at the foot of the figure; otherwise at the center.
This figure is similar to other symbols drawn.
}
\value{graphical side effects
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}


\examples{


plot(c(0, 50), c(0, 10) , type='n', asp=1  )

P1 = list(x=10, y=4)

P2 = list(x=40, y=6)
P3 = list(x=20, y=15)


 points(P1)
points(P2)
points(P3)
draw.humanstick(P1$x,  P1$y, siz=.5, col="black", border="black", standing=FALSE)
draw.humanstick(P2$x,  P2$y, siz=.5, col="blue", border="blue", standing=TRUE)


}
\keyword{misc}
