\name{fancyarrowhead}
\alias{fancyarrowhead}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Make fancy arrowheads}
\description{
  Create and plot fancy arrows. Aspect ratio must be set to 1-1
  for these arrows to plot correctly.
}
\usage{
fancyarrowhead(x1, y1, x2, y2, 
     headlength = 0.4, headthick = 0.2,pct=0,   col = 'black', add=TRUE, 
     border = "black")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x1}{x  tail coordinate}
  \item{y1}{y  tail coordinate}
  \item{x2}{x  head coordinate }
  \item{y2}{y  head coordinate }
 
  \item{headlength}{length of head }
  \item{headthick}{thickness of head}
   \item{pct}{percent of head that is barbed }
  \item{col}{fill color }
  \item{add}{logical, TRUE=add to current plot}
  \item{border}{color of border}
}
\note{
fancyarrowhead only works properly if the aspect ratio is set to 1. See
example below.  The arrow head is calculate based on the last two points
of the vectors provided.

  }
\value{
 Graphical side effects.
}

\author{Jonathan M. Lees<jonathan.lees@unc.edu>}

\seealso{fancyarrows}
\examples{
   pct = 0.1; headlength = 0.2; headthick = 0.1


############   MUST set asp=1 here

K=list()
K$x=c(-2.505,-2.280,-1.955,-1.405, 0.196, 1.546, 2.696,
 3.671, 5.197, 6.747, 9.198,10.173,10.398,10.948,11.223)
K$y=c(3.29,3.62,3.98,4.36,5.05,5.29,5.29,5.21,5.00,4.64,
4.43,4.86,5.19,6.88,8.21)
plot(range(K$x) , range(K$y) , asp=1, type='n' )
lines(K)

x1=K$x[5]; y1=K$y[5]
x2=K$x[6]; y2= K$y[6]


fancyarrowhead( K$x[5], K$y[5],K$x[6], K$y[6],
 headlength =  headlength,
headthick =headthick, pct=pct ,  add=TRUE)

####  or

n = length(K$x)

for(i in seq(from=1, to=n-1, by=3) )
{
fancyarrowhead( K$x[i], K$y[i],K$x[i+1], K$y[i+1],
 headlength =  headlength,
headthick =headthick, pct=pct , col='red' , add=TRUE)

}


plot(c(0, 2), c(0, 10) , asp=1 , type='n' )

fancyarrowhead( 0, 8, 1, 8,
 headlength =  1,
headthick =.4, pct=0 , col='red' , add=TRUE)


fancyarrowhead( 0, 7, 1, 7,
 headlength =  1,
headthick =.4, pct=0.1 ,  col='red' ,add=TRUE)


fancyarrowhead( 0, 6, 1, 6,
 headlength =  1,
headthick =.4, pct=0.2 ,  col='red' ,add=TRUE)

fancyarrowhead( 0, 5, 1, 5,
 headlength =  1,
headthick =.4, pct=0.3 ,  col='red' ,add=TRUE)


fancyarrowhead( 0, 4, 1, 4,
 headlength =  1,
headthick =.4, pct=0.4 ,  col='red' ,add=TRUE)



fancyarrowhead( 3, 8, 4, 8,
 headlength =  .8,
headthick =.4, pct=0 , col='blue' , add=TRUE)


fancyarrowhead( 3, 7, 4, 7,
 headlength =  .8,
headthick =.4, pct=0.1 ,  col='blue' ,add=TRUE)


fancyarrowhead( 3, 6, 4, 6,
 headlength =  .8,
headthick =.4, pct=0.2 ,  col='blue' ,add=TRUE)

fancyarrowhead( 3, 5, 4, 5,
 headlength =  .8,
headthick =.4, pct=0.3 ,  col='blue' ,add=TRUE)


fancyarrowhead( 3, 4, 4, 4,
 headlength =  .8,
headthick =.4, pct=0.4 ,  col='blue' ,add=TRUE)









}

\keyword{aplot}
