\name{inPLOTlabel}
\alias{inPLOTlabel}
\title{
  Add text to plot near corner.
}
\description{
  Add text to plot near the designated corner.
  Offset is determined from a percentage of the xy coordinate ranges
}
\usage{
inPLOTlabel(hlab = "", pct = 0.05, side = c(4, 3), ...)
}
\arguments{
  \item{hlab}{Text to be plotted
}
  \item{pct}{Percent distance from the corner
}
  \item{side}{2-vector, (2,4) for x-sides, c(1,3) for y
}
  \item{\dots}{Other graphical parameters,e.g. col, cex, etc.
}
}
\details{
  The percent distance is based on the user limits extracted from
  the par('usr') command.

  
}
\value{x,y coordinates of the point where the text is plotted
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\examples{

plot(runif(10), runif(10) )

inPLOTlabel(hlab='Jonathan M. Lees', pct=0.05, side=c(4, 3), col='red', font=2, cex=1.5 )

inPLOTlabel(hlab='Jonathan M. Lees', pct=0.05, side=c(2, 1), col='blue' )
inPLOTlabel(hlab='Jonathan M. Lees', pct=0.02, side=c(2, 3), col='blue' )
inPLOTlabel(hlab='Jonathan M. Lees', pct=0.1, side=c(4, 1), col='purple' )



}
\keyword{misc}
