\name{jarrow}
\alias{jarrow}
\alias{jpoint}

\title{Draw Arrow Part Way
}
\description{Draw an arrow or point a specified percentage from the start (A).
}
\usage{
jarrow(A, B, pct = 0.5, pct0=0 , ...)
jpoint(A, B, pct = 0.5 )
}
\arguments{
  \item{A}{list, x,y
}
  \item{B}{list, x,y
}
  \item{pct}{percentage along A-B for arrow (0-1)
  }
    \item{pct0}{percentage along A-B for start of arrow (0-1), default=0
}
  \item{\dots}{plotting parameters, and length parameter for arrow
}
}
\details{Code here draws line from start to the new location.
}
\value{point where arrow is plotted
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}


\seealso{arrows
}
\examples{


plot(c(0, 50), c(0, 10) , type='n', asp=1  )

P1 = list(x=10, y=4)

P2 = list(x=40, y=6)
P3 = list(x=20, y=15)


 points(P1)
points(P2)
points(P3)
segments( P1$x, P1$y, P2$x, P2$y)

jarrow(P1, P2, 0.75, length=0.1, col='blue')

P3= jpoint(P1, P2, 0.75)

points(P3)

}
\keyword{misc}
