\name{perpPT}
\alias{perpPT}
\title{Perpendicular Point
}
\description{Given points V1 and V1, find a point perpendicular to the line
that is rad away from V1
}
\usage{
perpPT(Z1, Z2, rad=1, pol=1)
}
\arguments{
  \item{Z1}{point, list(x, y)
}
  \item{Z2}{point, list(x, y)
}
  \item{rad}{distance to Z1
}
  \item{pol}{polarity: multiply by -1 for opposite polarity (direction)
}

}
\details{Z1, and Z2 can be 2-vectors (x,y) .  They are converted to lists.
}
\value{list:
\item{x}{x-value}
\item{y}{y-value}
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{In general we use the right hand rule to rotate
the 90 degrees.  If pol is -1, multiply direction by -1)
}


\seealso{pvec
}
\examples{

x1 = c(0, 10)
y1 = c(0, 10)

P1 = list(x=2,y=3)
P2 = list(x=10,y=6)

P3 = perpPT(P1, P2, 2)
P4 = perpPT(P1, P2, rad=1.5, pol = -1)

plot(range(x1), range(y1), asp=1, xlab='m', type='n' , ylab='m' )

segments(P1$x, P1$y, P2$x, P2$y, lty=2)
segments(P1$x, P1$y, P3$x, P3$y)
text(P3 , 'P3', pos=3)
text(P1 , 'P1', pos=2)
text(P2 , 'P2', pos=1)
text(P4 , 'P4', pos=1, col='blue' )

arrows(P1$x, P1$y, P4$x, P4$y, col='blue')


}
\keyword{misc, drafting}
