\name{pointAB}
\alias{pointAB}
\title{Line through a point.
}
\description{Draw a line through a point with a given
angle.
}
\usage{
pointAB(P, m, ...)
}
\arguments{
  \item{P}{2-vector, point
}
  \item{m}{slope, radians
}
  \item{\dots}{graphical parameters for plotting
}
}
\details{This fundtion is similar to abline.
}
\value{graphical
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{ pvec
}
\examples{


x1 = c(0, 10)
y1 = c(0, 10)


ang1 = 40   ## degrees
P1 = c(2, 3)
P4 = pvec(P1, ang1*pi/180, 5)
plot(range(x1), range(y1), asp=1, xlab='m', type='n' , ylab='m' )
points(P4[1], P4[2], pch=6)
pointAB(P4, tan(ang1*pi/180), col=rgb(1,.8,.8)  ) 


}
\keyword{misc, drafting}
