\name{pointproj}
\alias{pointproj}
\title{Point Projection
}
\description{calculates the perpendicular distance of point P1 to line VEC
}
\usage{
pointproj(P1, VEC)
}
\arguments{
  \item{P1}{ point 2-vector, or list(x,y)
}
  \item{VEC}{4-vector: x1, x2, y1, y2. or list(x,y)
}
}
\details{
The lists are converted to vectors
}
\value{
list: x, y projection,  distance
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}


\seealso{vecproj, perpproj
}
\examples{


x1 = c(0, 10)
y1 = c(0, 10)

P1 = list(x=2,y=3)
P2 = list(x=10,y=6)

P3 = perpPT(P1, P2, 2)
P4 = perpPT(P1, P2, rad=1.5, pol = -1)

plot(range(x1), range(y1), asp=1, xlab='m', type='n' , ylab='m' )

segments(P1$x, P1$y, P2$x, P2$y, lty=2)
segments(P1$x, P1$y, P3$x, P3$y)

P5 = list(x=6,y=2)
h = pointproj(P5 , c(P1$x, P2$x,P1$y, P2$y)  )
points(P5)
segments(P5$x, P5$y, h$x, h$y)


}
\keyword{misc}
