\name{pvec}
\alias{pvec}
\title{Point Vector
}
\description{Find a point that is a specified number of degrees
and distance from a lines
}
\usage{
pvec(P, alpha, L = 7)
}
\arguments{
  \item{P}{vector, x, y
}
  \item{alpha}{angle, radians
}
  \item{L}{distance
}
}

\value{vector of (x,y) 
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\examples{

x1 = c(0, 10)
y1 = c(0, 10)

P1 = c(2,2)
ang1 = 40   ## degrees

P4 = pvec(P1, ang1*pi/180, 5)

plot(range(x1), range(y1), asp=1, xlab='m', type='n' , ylab='m' )
points(P1[1], P1[2], pch=10)
points(P4[1], P4[2], pch=6)
segments(P1[1], P1[2], P4[1], P4[2], col='blue', pch=2)
text(P4[1], P4[2], labels="P4", pos=3)


}
\keyword{drafting}
