\name{rightANG}
\alias{rightANG}
\title{Right Angle
}
\description{Plot a right angle at the point given.

}
\usage{
rightANG(P, ang, L = 0.1, ...)
}
\arguments{
  \item{P}{Point, vector (x,y)
}
  \item{ang}{
  Angle in radians
}
  \item{L}{
}
  \item{\dots}{plotting parameters
}
}
\details{Angle is given in radians
}
\value{List:
\item{x}{x-coordinates }
\item{y}{y-coordinates }
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\examples{


x1 = c(0, 10)
y1 = c(0, 10)

P1 = list(x=2,y=3)
P2 = list(x=10,y=6)

plot(range(x1), range(y1), asp=1, xlab='m', type='n' , ylab='m' )

segments(P1$x, P1$y, P2$x, P2$y, lty=2)

ang4 = atan2(P2$y-P1$y, P2$x-P1$x)

rang =  pi/2 - ang4
a.rt = rightANG(P1, rang, L=1)

### or
P3 = jpoint(P1, P2, 0.5)

rang =   ang4 + pi/2
a.rt = rightANG(P3, rang , L=1)



}
\keyword{misc}
