EarthRad <-function(lat, a = 6378.1370, b = 6356.7523)
    {
#####  get the radius of the earth for an ellipsoid
#### units of lat = degrees
### a, b are in km
        
      phi  = lat*pi/180
       ###  phi is now in radians

      if(missing(a) ) a = 6378.1370 ## km  equatorial
      
      if(missing(b) ) b = 6356.7523 ## km  polar radius
      
        TOP = (a^2*cos(phi))^2 + (b^2*sin(phi) )^2
        BOT = (a*cos(phi) )^2 + (b*sin(phi) )^2
      RPHI = sqrt(TOP/BOT)
      ######  returns units in km
        return(RPHI)
    }
