\name{EarthRad}
\alias{EarthRad}
\title{Earth Radius For Ellipsoid
}
\description{
Calculate the radius of the earth at a designated latitude given the polar and equatorial axis distances.
}
\usage{
EarthRad(lat, a = 6378.137, b = 6356.7523)
}
\arguments{
  \item{lat}{Latitude, degrees
}
  \item{a}{radius of earth equatorial axis, km
}
  \item{b}{radius of earth polar axis, km
}
}

\value{
Radius in kilometers.
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\examples{

lats = seq(from=0, to=90, by=10)
EarthRad(lats, a = 6378.137, b = 6356.7523)

}
\keyword{misc}
