##########################################################
##########################################################
### source("/home/lees/Progs/R_stuff/APRIL.FIG.R")


###  do we need this?
Calibnew = c(1,1.0, 0.0 )


### april.analA(APALL)

april.analA<-function(APALL)
  {
    for(i in 1:length(APALL))
      {
        AP = APALL[i]
        
        GG = get(AP)
        dt = 0.008
        
        infr = GG$dat[,1]/0.200
        infr = infr-mean(infr)
        x = GG$dat[,2] 
        t = dt*seq(0,length(x)-1)
        
        vel   = deconinst(x, dt, Kal,1, Calibnew, waterlevel=1.e-8)
        vel=vel-mean(vel)
        x = vel
        
        plot(t,x)
        z = RESCALE(infr, min(x), max(x), min(infr), max(infr) )
        lines(t, z, col=2)
        
        L = locator(2)
        
                                        #    plot(range(t[t>=L$x[1]&t<=L$x[2]]), range(c(infr[t>=L$x[1]&t<=L$x[2]], x[t>=L$x[1]&t<=L$x[2]])))

        flag = t>=L$x[1]&t<=L$x[2]
        
        plot(t[flag],x[flag])
        Iz = infr[flag]-mean(infr[flag])
        
        z = RESCALE(Iz, min(x[flag]), max(x[flag]), min(Iz), max(Iz) )
        
        lines(t[flag], z, col=2)
        opix = locator()
        pp = opix$x
        mp = mean(1/diff(pp))
        print(paste(sep=' ', i, "MEAN FREQ = ", mp, "HZ"))
      }

  }

##########################################################
##########################################################
### source("/home/lees/Progs/R_stuff/APRIL.FIG.R")

april.fig<-function(AP)
  {
###  april.fig(APALL[1])
    GG = get(AP)
    infr = GG$dat[,1]/0.200
    
    x = GG$dat[,2]
    ##  deconvolve and filter with correct Instrument response
    dt = 0.008
    amp = x
    vel   = deconinst(amp, 0.008, Kal,1, Calibnew, waterlevel=1.e-8)
    vel=vel-mean(vel)
    fy = vel
    fy = butfilt(fy, 0.02 , 10 , dt, "BP" , "BU" )
    fy = 1000000*trapz(fy,dt)
    
    fy = applytaper(fy)
    disp  = fy-mean(fy)
    ascd = cbind(  infr,  1000000*vel , disp )
    
    
                                        # par(mfrow=c(3,1))
                                        #plot(ascd[,1])
                                        #plot(ascd[,2])
                                        #plot(ascd[,3])
                                        #locator()
    # par(mfrow=c(1,1))
    
                                        # LABS =c("Pa", "mm/s", "mm")
    LABS =c("Pa", expression(mu*"m/s"), expression(mu*"m") )
    Notes =c("Infrasonic", "Velocity", "Displacement" )
    
    PLOT.MATAP(ascd, tim=dt*seq(0,length(x)-1), dt=0.008,  labs=LABS, sfact=1, notes=Notes)
### 

  }
##########################################################
### source("/home/lees/Progs/R_stuff/APRIL.FIG.R")



PLOT.MATAP<-function(ascd, tim=1, dt=1,  WIN=WIN, labs=LABS, notes=notes, sfact=1, LOG="", COL=col)
{

 
  if(missing(sfact)) { sfact=1}
  if(missing(dt)) { dt=1}
  if(missing(LOG)) { LOG=""  }

  
  if(missing(tim))
    {
      tim = dt*seq(from=0,to=length(ascd[,1])-1)
    }

  if(missing(WIN))
    {
      WIN =range(tim)
    }
  if(missing(notes))
    {
      note.flag = FALSE
    }
  else
     {
      note.flag = TRUE
    }

  tflag = tim>=WIN[1]&tim<=WIN[2]
  

  tr1 = 0.05
  tr2 = .9
  
  matsiz = dim(ascd)
  nn = matsiz[2]
  
  if(missing(COL)) { COL=rep(1, nn)  }
if(length(COL)<nn) {  COL=c(COL, rep(1, nn-length(COL))) }
  
    if(missing(labs)) { labs=rep(" ", nn) }
  ttics = pretty(tim[tflag], n=10 )
  atics = ttics
  if(LOG=='x')
    {
      periods = c(30,20,10,5,2,1)
      hz = 1/periods
      at1 = c(pretty(1:10), pretty(tim))
      at2 = at1[at1>0&at1<max(tim)]
      ttics = c(hz, at2 )
      
      btics = c(periods, at2 )
      atics = as.character(btics)
      atics[length(atics)] = paste(sep=' ', atics[length(atics)],"Hz")
      
      atics[btics==1] = paste(sep=' ', atics[btics==1],"Hz")
           atics[1] = paste(sep=' ', atics[1],"s")
 
      
    }


  
  dy = (1/nn)


  
  maxS = rep(0,nn)
  minS = rep(0,nn)
  diffS = rep(0,nn)

  
    for(i in 1:nn)
    {
      amp = ascd[tflag,i]
      maxS[i] = max(amp[!is.na(amp)])
      minS[i] = min(amp[!is.na(amp)])
      diffS[i] = maxS[i]-minS[i]
    }
      ##  abs waiting using only COMP
  KDIFF = which.max(diffS)
  
  if(sfact>=2)
    {
      MAXy = max(maxS)
      MINy = min(minS)
      
      maxS =rep(MAXy, nn)
      minS =rep(MINy, nn)
    }

  plot(range(tim[tflag]), c(0,1), type='n', axes=FALSE, xlab="", ylab="", log=LOG)
   box(col=grey(0.8))

  upar = par("usr")
   g = 1:nn
  leftrite = g%%2
  leftrite[leftrite==0] = 2

  
    for(i in 1:nn)
    {
      amp = ascd[tflag,i]
      amp = amp-mean(amp[!is.na(amp)])
      y3 = 1-(dy*i)
      if(sfact==1)
        {
      minamp =  min(amp[!is.na(amp)]);
      maxamp= max(amp[!is.na(amp)]);
    }
      else
        {
      minamp =  minS[i];
      maxamp= maxS[i];

        }
      z = RESCALE(amp, y3, y3+dy, minamp, maxamp )
      abline(h=y3, lty=2, col=grey(0.8))
      lines(tim[tflag], z, col=COL[i])
      ## print( c(y3, y3+dy, minamp, maxamp))
      yy = pretty(c(minamp, maxamp), n = 5)
      flg = yy>minamp & yy<maxamp
      yt = yy[flg]
      yts = RESCALE(yt, y3, y3+dy, minamp, maxamp )


      
    yl = length(yt)
      ytt = yt[c(1,yl)]
      ytst = yts[c(1,yl)]

    
                                  
     #   axis(2, tck=0.01 , at=yts, labels=yt, las=2 , line=0.1 )

      
    #  if(i==KDIFF)
    #    {
     #     axis(2, pos= upar[1] ,tck=-0.005 , at=yts, labels=yt, las=2 , line=0.1 )
     #   }
     # else
    #    {
    #      bnum = paste(sep='', "X", format.default(diffS[KDIFF]/diffS[i], digits=4))
     #     blab=bnum 
      #    text(min(tim[tflag]), y3+0.75*dy, labels=blab, adj=0)
      #  }

      if(leftrite[i]==1)
        {

      axis(4, pos= upar[leftrite[i]] ,tck=-0.005 , at=yts, labels=FALSE, las=2 , line=0.1 )
      axis(4, pos= upar[leftrite[i]] ,tck=-0.005 , at=ytst, labels=ytt, las=2 , line=0.1, cex=1.2 )
    }
      else
        {

      axis(2, pos= upar[leftrite[i]] ,tck=-0.005 , at=yts, labels=FALSE, las=2 , line=0.1 )
      axis(2, pos= upar[leftrite[i]] ,tck=-0.005 , at=ytst, labels=ytt, las=2 , line=0.1, cex=1.2 )

        }
      
      
     # axis(side=3, pos=y3+dy,   tck=0.005, at=ttics, labels=FALSE, col=grey(0.2) )
      ylab = labs[i]
      mtext(side=2, at=y3+dy/2, text=ylab , line=1, cex=1.4)
      if(note.flag==TRUE)
        {
          text(0.9*max(tim[tflag]), y3+dy-dy*0.15, notes[i], adj=1, cex=1.5)
        }
      
    }
  
  axis(side=1, tck=0.01, at=ttics, labels=FALSE)
  axis(side=1, tick=FALSE,  at=ttics, labels=atics, line=-1, cex=1.5)
  
  
  title(xlab='Time (s)', line=1.4, cex=1.5) 
  u = par("usr")
  
  
  
 
 

}

##########################################
##########################################################
##########################################################
### source("/home/lees/Progs/R_stuff/APRIL.FIG.R")


dump.ALOOK<-function(mSW, STA="", FV=NULL, RMINST=FALSE, CINTEG=c(FALSE, TRUE, TRUE, TRUE),  INTEG=FALSE, sfact=1 )
  {
### dump.LOOK(mSW)
    if(missing(STA))
      {     
        STA="for"  
      }
     if(missing(sfact)) { sfact=1}
    if(missing(FV))
      {
        FV=list(ON=FALSE, fl=0.5, fh=1.0, type="LP", proto="BU", vec=c(FALSE, TRUE, TRUE, TRUE))
      }
    if( missing(CINTEG))
      {
        CINTEG=c(FALSE, TRUE, TRUE, TRUE)
      }
    if(missing(RMINST))
      {
        RMINST = FALSE
      }
    
    if(missing(INTEG))
      {
        
        INTEG=FALSE
      }
    RET=as.list(mSW)
    names(RET)=mSW

    FVF = FV
    nn = length(mSW)
    MAT = matrix(rep(0, nn*6), ncol=6, nrow=nn)
    
    
    for(i in 1:length(mSW))
      {
        GG = get(mSW[i])
        ncomp = seq(from=1, to=length(GG$STN))
        COMP=ncomp[GG$chaname==STA]
        COMPF=ncomp[GG$STN=="for"]

        
        print(paste(sep=" ", i, mSW[i]))
        # print(COMP)
        CINTEG=rep("TRUE", length(COMP))
        CINTEG[GG$chaname[COMP]=="Infrasonic"] = "FALSE"
        FV$vec =rep("TRUE", length(COMP))
        FV$vec[GG$chaname[COMP]=="Infrasonic"] = "FALSE"

        CINTEGF=rep("TRUE", length(COMPF))
        CINTEGF[GG$chaname[COMPF]=="Infrasonic"] = "FALSE"
        FVF$vec =rep("TRUE", length(COMP))
        FVF$vec[GG$chaname[COMPF]=="Infrasonic"] = "FALSE"

        dev.set(2)
        RST = dump.Nplot(GG, COMP=COMPF, RMINST=TRUE,  INTEG=TRUE, FILT=FVF , rot=TRUE, CINTEG=CINTEGF, sfact=sfact)
        dev.set(3)
        RST = dump.Nplot(GG, COMP=COMP, RMINST=RMINST,  INTEG=INTEG, FILT=FV , rot=FALSE, CINTEG=CINTEG, sfact=sfact)
        print(paste(sep=' ', "CHOOSE WINDOW, or skip"))
        
        Gi = GG$info
        jd  = jday( Gi$yr[1], Gi$mo[1], Gi$dom[1])
        t = recdate(jd , Gi$hr[1], Gi$mn[1], Gi$sec[1]+Gi$msec[1]/1000+Gi$t1[1])
        ename = paste(sep="_", mSW[i], Gi$yr[1], Gi$mo[1], t$jday, t$hour, t$min, floor(t$sec), GG$CODE)
        title(ename)
        RET[[i]] = list(stat=matrix(NA, nrow=length(COMP), ncol=2), COMP=COMP, Click=-1)
        L = locator()
        
        if(length(L$x)>=2& (L$x[2]- L$x[1]) > 0.0)
          {

            print(paste(sep=" ", "WINDOW:", L$x[1], L$x[2],L$x[2]- L$x[1]))
            print(paste(sep=' ', "CLICK:   NE=1   SW=2   CC=3  XX=0"))
        
            RST = dump.Nplot(GG, COMP=COMP,  WIN=c(L$x[1], L$x[2]), RMINST=RMINST, INTEG=INTEG, FILT=FV , rot=FALSE, CINTEG=CINTEG, sfact=sfact)
            title(ename)
            L = locator()
            nL = length(L$x)           
           RET[[i]] = list(stat=RST, COMP=COMP, PIX=L, Click=nL)
            if(nL>=3)
           MAT[i,] = c(RST[1,2]-RST[1,1], RST[2,2]-RST[2,1],RST[3,2]-RST[3,1],
                L$x)
            
          }
        
      }
        return(RET=RET, MAT=MAT)
        
  }

##########################################################
##########################################################
### source("/home/lees/Progs/R_stuff/APRIL.FIG.R")

dump.QLOOK<-function(mSW, STA="", FV=NULL, RMINST=FALSE, CINTEG=c(FALSE, TRUE, TRUE, TRUE),  INTEG=FALSE, sfact=1 )
  {
### dump.LOOK(mSW)
    if(missing(STA))
      {     
        STA="for"  
      }
     if(missing(sfact)) { sfact=1}
    if(missing(FV))
      {
        FV=list(ON=FALSE, fl=0.5, fh=1.0, type="LP", proto="BU", vec=c(FALSE, TRUE, TRUE, TRUE))
      }
    if( missing(CINTEG))
      {
        CINTEG=c(FALSE, TRUE, TRUE, TRUE)
      }
    if(missing(RMINST))
      {
        RMINST = FALSE
      }
    
    if(missing(INTEG))
      {
        
        INTEG=FALSE
      }
    RET=as.list(mSW)
    names(RET)=mSW

    FVF = FV
    nn = length(mSW)
    MAT = matrix(rep(0, nn*6), ncol=6, nrow=nn)
    
    
    for(i in 1:length(mSW))
      {
        GG = get(mSW[i])
        ncomp = seq(from=1, to=length(GG$STN))
        COMP=ncomp[GG$chaname==STA]
        COMPF=ncomp[GG$STN=="for"]

        
        print(paste(sep=" ", i, mSW[i]))
        # print(COMP)
        CINTEG=rep("TRUE", length(COMP))
        CINTEG[GG$chaname[COMP]=="Infrasonic"] = "FALSE"
        FV$vec =rep("TRUE", length(COMP))
        FV$vec[GG$chaname[COMP]=="Infrasonic"] = "FALSE"

        CINTEGF=rep("TRUE", length(COMPF))
        CINTEGF[GG$chaname[COMPF]=="Infrasonic"] = "FALSE"
        FVF$vec =rep("TRUE", length(COMP))
        FVF$vec[GG$chaname[COMPF]=="Infrasonic"] = "FALSE"

        dev.set(2)
        RST = dump.Nplot(GG, COMP=COMPF, RMINST=TRUE,  INTEG=TRUE, FILT=FVF , rot=TRUE, CINTEG=CINTEGF, sfact=sfact)
        dev.set(3)
        RST = dump.Nplot(GG, COMP=COMP, RMINST=RMINST,  INTEG=INTEG, FILT=FV , rot=FALSE, CINTEG=CINTEG, sfact=sfact)
        print(paste(sep=' ', "CHOOSE WINDOW, or skip"))
        
        Gi = GG$info
        jd  = jday( Gi$yr[1], Gi$mo[1], Gi$dom[1])
        t = recdate(jd , Gi$hr[1], Gi$mn[1], Gi$sec[1]+Gi$msec[1]/1000+Gi$t1[1])
        ename = paste(sep="_", mSW[i], Gi$yr[1], Gi$mo[1], t$jday, t$hour, t$min, floor(t$sec), GG$CODE)
        title(ename)
        RET[[i]] = list(stat=matrix(NA, nrow=length(COMP), ncol=2), COMP=COMP, Click=-1)
        #L = locator()
        L = list( x=c(PIX[i,4]-0.5 , PIX[i,5]+0.5) )
        
        # abline(v=PIX[i, ]
        if(length(L$x)>=2& (L$x[2]- L$x[1]) > 0.0)
          {

            print(paste(sep=" ", "WINDOW:", L$x[1], L$x[2],L$x[2]- L$x[1]))
            print(paste(sep=' ', "CLICK:   NE=1   SW=2   CC=3  XX=0"))
        
            RST = dump.Nplot(GG, COMP=COMP,  WIN=c(L$x[1], L$x[2]), RMINST=RMINST, INTEG=INTEG, FILT=FV , rot=FALSE, CINTEG=CINTEG, sfact=sfact)
            title(ename)
            L = locator()
            nL = length(L$x)           
           RET[[i]] = list(stat=RST, COMP=COMP, PIX=L, Click=nL)
            if(nL>=3)
           MAT[i,] = c(RST[1,2]-RST[1,1], RST[2,2]-RST[2,1],RST[3,2]-RST[3,1],
                L$x)
            
          }
        
      }
        return(RET=RET, MAT=MAT)
        
  }

##########################################################
##########################################################
### source("/home/lees/Progs/R_stuff/APRIL.FIG.R")
