 cat("sourcing /home/lees/Progs/R_stuff/BUfilter.R\n")

###  source("/home/lees/Progs/R_stuff/BUfilter.R")

#################################################
#######
#######  R CMD SHLIB LLNfilt.o

### dyn.load("testr.so")
dyn.load("/home/lees/Progs/Rc/LLNfilt.so")


butfiltA<-function(a, ord=ord, fl=fl, fh=fh, deltat=dt, type=type, proto=pro)
{
  if(missing(deltat)) { deltat=0.008 }
  if(missing(ord)) { ord=8 }
  if(missing(fl)) { fl=0.5 }
  if(missing(fh)) { fh=50.0 }
  if(missing(type)) { type="BP" }
  if(missing(proto)) { proto="BU" }

  
  
.C("jfilt",
as.single(a),
as.integer(length(a)),
as.integer(ord),
as.character(type) ,
as.character(proto) ,
as.double(30.0) ,
as.double(0.3) ,
as.double(fl) ,
as.double(fh) ,
as.double(deltat) ,
output  = single(length(a)))$output

  
}

###  source("/home/lees/Progs/R_stuff/BUfilter.R")
#################################################

butfilt<-function(a, fl, fh, deltat, type, proto)
{
.C("jfilt",
as.single(a),
as.integer(length(a)),
as.integer(8),
as.character(type) ,
as.character(proto) ,
as.double(30.0) ,
as.double(0.3) ,
as.double(fl) ,
as.double(fh) ,
as.double(deltat) ,
output  = single(length(a)))$output
}
#################################################
###  source("/home/lees/Progs/R_stuff/BUfilter.R")
###  
FILT.spread<-function(x,y, dt, fl=fl, fh=fh, sfact=1, WIN=NULL, PLOT=TRUE)
  {
    ####  filter sweep 
    if(missing(fl))
      { fl = c(.1, 1, 2, 3, 4) }
    if(missing(fh))
      {  fh = c(1,2,3,4,5) }
    if(missing(sfact))  { sfact = 1 }
    if(missing(WIN))  { WIN=NULL }
    if(missing(PLOT))  { PLOT=TRUE }
    
    n=length(fl)
    ##  graphics.off()
   ##  par(mfrow=c(n+1, 1))
   ##  par(mai=c(0.0, .7, 0.1, 0.5))


    oky = !is.na(y)
    yrng = range(y[oky]-mean(y[oky]))
    
    FR = matrix(nrow=length(y), ncol=n+1)
    Notes = as.vector(1:(n+1))
    
    
    for(i in 1:n)
      {

        gy = y

        if(fl[i]>fh[i])
          {
            print(paste(sep=' ', "Warning on Filter definition: FL=", fl[i], " FH=", fh[i], "HZ"))
          }

        if(fh[i]>1/(2*dt))
          {
            print(paste(sep=' ', "Warning on Filter definition: FL=", fl[i], " FH=", fh[i], "HZ", "NYQ=", 1/(2*dt)))
          }
        
        
        fy = butfilt(y[oky],fl[i], fh[i], dt, "BP", "BU" )
        gy[oky] = fy
       
        FR[,i] = gy

        khigh = format.default(fh[i], digits=3)
        lhigh  = "Hz"
        if(fh[i]<1)
          {
            khigh = format.default(1/fh[i], digits=3)
              lhigh  = "s"
          }
        klow = format.default(fl[i], digits=3)
        llow  = "Hz"
        
        if(fl[i]<1)
          {
            klow = format.default(1/fl[i], digits=3)
             llow  = "s"
          }
        Notes[i] = paste(sep=' ', "BP FILTER",klow,llow , "to",khigh , lhigh)
      }
    FR[,n+1] = y-mean(y[oky])
    Notes[n+1] =paste(sep=' ',"Unfiltered")

    if(PLOT==TRUE)
      {
        if(is.null(WIN)==FALSE)
          {
            
            PLOT.MATN( FR, tim=x, WIN=WIN, dt=dt, sfact=sfact, notes=Notes, add=1)
          }
        else
          {
            PLOT.MATN( FR, tim=x, dt=dt, sfact=sfact, notes=Notes, add=1)
          }
      }
    
    invisible(list(FMAT=FR, Notes=Notes) )
    
}
#################################################
###  source("/home/lees/Progs/R_stuff/BUfilter.R")

testbutter<-function(x,y, dt)
  {
    fl = c(.1, 1, 2, 3, 4)
    fh = c(1,2,3,4,5)
    
    
    n=length(fl)
    #  graphics.off()
    par(mfrow=c(n+1, 1))
    par(mai=c(0.0, .7, 0.1, 0.5))
    
    yrng = range(y-mean(y))
    
    
    for(i in 1:n)
      {
        fy = butfilt(y,fl[i], fh[i], dt, "BP", "BU" )
        plot(x, fy, ylim=yrng, type='l', axes=FALSE, ylab="mm/s")
        axis(2)
        title(paste(sep=' ', "BP FILTER", fl[i], "to", fh[i], "Hz"))
      }
    par(mai=c(0.5, .7, 0.1, 0.5) )
    plot(x,y-mean(y), type='l', axes=FALSE, xlab="Time,s", ylab="mm/s", main="Unfiltered Data")
    axis(2)
    axis(1)

    
}
#################################################
####
### 
###  source("/home/lees/Progs/R_stuff/BUfilter.R")
