#################################################
#################################################
##########   create a simple example using one frequency
k =seq(from=0, to=63, by=1)

N = 64
M = 5
T = N/M
A = 10

xk = A * sin(2*pi*k/T)

tim = k/T

plot(tim, xk, type='l', xlab="time, s", ylab="Amplitude")
points(tim, xk, col=4)

###  there are 64 sample in 5 seconds
###

deltat = 5/64
samprate = 64/5

###  simpler plots
plot(k, xk, type='l')
points(k, xk, col=4)

Xm = fft(xk)

Im(Xm)

####  Pm = sqrt(Re(Xm * Conj(Xm)))
Pm = Mod(Xm)

##  or

Pm = (Mod(Xm)^2)/N

plot(Pm, type='p')

plot(Pm, type='s')

plot(Pm[0:32], type='s' )
points(Pm[0:32] )

##  Theoretical Peak for
##  this DFT (from notes in handout)

TheorPm = A*A*N/4

##  compare with:
 

max(Pm[0:32])

f = seq(from=0, to=N/2, by=1)

plot(f, Pm[1:33], ylab="Power Density", xlab="frequency Hz-s")

plot(f, Pm[1:33], type='h', ylab="Power Density", xlab="frequency number")



########      so, lets gather this into a simple function:
#####################################################
#####################################################
#####################################################
###########   power spectrum example function

Powerspec<-function(xk, deltat)
{
###  make a simple periodogram
N = length(xk)
Xm = fft(xk)
Pm = (Mod(Xm)^2)/N
m = floor(N/2)+1

f = seq(from=0, to=0.5, length=m )*(1/(deltat))

plot(f, Pm[1:m], type='h', ylab="Power Density", xlab="frequency Hz-s")
##  return the power spectrum for diffrent plotting
invisible(list(f=f, PS=Pm[1:m]))
}
#####################################################
#####################################################


BetterPowerspec(xk, deltat=3000, pre=2, win=TRUE, LOG=1)



#####################################################
#####################################################


## OR

f = seq(from=0, to=0.5, length=33)


plot(f, Pm[1:33], type='h', ylab="Power Density", xlab="frequency Hz-s")

##  add in rectangle showing the power spectrum bar
## the width is 1/N, the units are Hz-s (unitless or units of nyquist)

rect(f[6]-(1/N), 0, f[6]+(1/N),  Pm[6], col=2)

###########################################  Example with DFT
###########################################
###########################################
####  another example:

##  create a vector of 6 amplitudes and 6 frequencies

amps = c(2,5,6,4,9, 12)
fs = c(10, 32, 21, 45, 23, 12)

##  create a time vector with dt=0.004  (4 milliseconds)

t = seq(from=0, to=5, by=0.004)

## start with a y of all zeroes

y = rep(0, length(t))

## for each frequency add in a sinusoid
for(i in 1:length(amps))
  {
    y1 = amps[i]*sin(2*pi*fs[i]*t)
    y = y+y1
  }

###  look at the amplitude spectrum
Per = naive(y, 0.004)
 
abline(v=fs, col=rgb(1, .8, .8), lty=2)



Per = Powspec(y, 0.004, XL=c(0,60))

abline(v=fs, col=rgb(1, .8, .8), lty=2)

N = length(t)
amps^2*N/4

K = findInterval(fs, Per$f)

Per$Syy[K]

points(Per$f[K],  Per$Syy[K], pch=5, col=2)
points(fs, amps^2*N/4, pch=6, col=3)

#############  naive amplitude specturm    ########################
####################################################################
####################################################################
naive<-function(y,dt,XL=c(1,length(y)/2), LOG='', PLOT=TRUE, DB=FALSE)
  {
##  returns the amplitude spectrum of a time series
    fn = 1/(2*dt)
               ##  fn = nyquist frequency
if(missing(PLOT)) 
{ PLOT=TRUE }
if(missing(DB)) 
{ DB=FALSE }
    if( missing(XL) )
      {
        XL = c(0,fn)
      }
    if( missing(LOG) )
      {
        LOG=''
      }
    Y = fft(y)
    Pyy = Y * Conj(Y)
    n = length(Pyy)/2
    Syy = Mod(Pyy[1:n])

###   Syy is the amplitude spectrum not the power spectrum
if(DB==TRUE)
{
Syy = 20*log(Syy/max(Syy))
}
    f = (0:(length(Syy)-1))*fn/length(Syy)
    ## plot the results, add in some features to make the plotting nicer
	if(PLOT==TRUE)
	{
          plot(f, Syy, type='l', xlab="frequency", ylab="Amp", xlim=XL, log=LOG)
	}
	invisible(list(Syy=Syy, f=f))	
  }
####################################################################
##########  WELCH's METHOD
####################################################################
###############
##############  use stft  for welch's method in R
####################################################################
####################################################################
grip = scan(file="D:/LEES/CLASSES/Data_analysis/DATA/O18_GRIP.dat", list(a=0, b=0, c=0))
y = grip$c-mean(grip$c)

deltat = 20
samprate = 1/deltat

X = y
rwelch =    stft(X, win=min(80,floor(length(X)/10)), inc=min(24, floor(length(X)/30)), coef=256, wtype="hanning.window")
KK = apply(rwelch$values, 2, FUN="mean")

plot(KK, log='y')

###############  CLIMATE DATA EXAMPLE
####################################################################
####################################################################
###########
o18 = scan(file="D:/LEES/CLASSES/Data_analysis/DATA/o18.dat", list(a=0))
###   data is sample at 3000 year intervals

y=o18$a
t = seq(0, by=3000, length=length(y))
plot(t, o18$a, type='l')

y = y-mean(y)
z = (y-mean(y))*cosine.window(length(y))

plot(t,z, type='l')

Per = naive(z, 3000, LOG='y')
 
X = y-mean(y)

####    use welch's method to determine power spectrum
rwelch =    stft(X, win=min(80,floor(length(X)/10)), inc=min(24, floor(length(X)/30)), coef=256, wtype="cosine.window")
KK = apply(rwelch$values, 2, FUN="mean")

f=seq(from=0, to=0.5, length=256)*1/(3000)

plot(f, KK, log='y')

h = locator(type='p', col=2)
###  the periods are
1/h$x


###############################

###############   TAPERS
###############################

#######  tapers
a = rep(1,500)
b = spec.taper(a, 0.1)
h = hanning.window(500)

cosine.window<-function(n) 
{
    if (n == 1) 
        c <- 1
    else {
        
	a = rep(1,n)
        c <- j.taper(a, 0.1)
    }
    return(c)
}

###############
j.taper<-function (x, p = 0.1) 
{
    if (any(p < 0) || any(p > 0.5)) 
        stop("p must be between 0 and 0.5")
    a <- attributes(x)
    x <- as.matrix(x)
    nc <- ncol(x)
    if (length(p) == 1) 
        p <- rep(p, nc)
    else if (length(p) != nc) 
        stop("length of p must be 1 or equal the number of columns of x")
    nr <- nrow(x)
    for (i in 1:nc) {
        m <- floor(nr * p[i])
        if (m == 0) 
            next
        w <- 0.5 * (1 - cos(pi * seq(1, 2 * m - 1, by = 2)/(2 * 
            m)))
        x[, i] <- c(w, rep(1, nr - 2 * m), rev(w)) * x[, i]
    }
    attributes(x) <- a
    x
}




####################################################################
####################################################################
#############  CO2 EXAMPLE
data(co2)
plot(co2)

X = co2-mean(co2)
Per = naive(X, 1/12)

Powerspec(X, 1/12)

###  looks like linear trend is really very strong.
###  lets remove this and then see other periodicity

A = lm(co2 ~ time(co2))

X = A$residuals
Powerspec(X, 1/12)

h = locator(type='p', col=2)

periods = 1/h$x


X =  A$residuals
rwelch =    stft(X, win=min(80,floor(length(X)/10)), inc=min(24, floor(length(X)/30)), coef=256, wtype="cosine.window")
KK = apply(rwelch$values, 2, FUN="mean")

f=seq(from=0, to=0.5, length=256)*(1/(1/12))

plot(f, KK, log='y')

h = locator(type='p', col=2)
periods = 1/h$x



####################################################################
####################################################################
####################################################################
###########  EXAMPLE FROM DAVIS


es = scan(file="d:/LEES/CLASSES/Data_Analysis/dos_files/EISENERZ.dat", list(Hour=0,  Fe=0, CaO=0, SiO2=0, MgO=0, MnO=0, Al2O3=0, Tonnes=0))

plot(es$Hour, es$Fe, type='l')
plot(es$Hour, es$Ca, type='l')
plot(es$Hour, es$SiO2, type='l')
plot(es$Hour, es$MgO, type='l')
plot(es$Hour, es$MnO, type='l')
plot(es$Hour, es$Al2O3, type='l')



for(i in 2:length(es))
{
plot(es[[1]], es[[i]], type='l', xlab=names(es)[1] , ylab=names(es)[i])
locator()
}


par(mfrow=c(1,1))

par(mfrow=c(length(es)-1,1))
p = par("mai")
p[3] = 0.0
p[1] = 0.1
par(mai=p)

for(i in 2:length(es))
{
x = es[[i]]-mean(es[[i]])
Powerspec(x, 1)
##locator(1)
}

########################################
#########################################
###########  GRIP data

grip = scan(file="d:/LEES/CLASSES/Data_Analysis/DATA/O18_GRIP.dat", list(t1=0, o=0, t2=0))

plot(grip$t2, grip$o, type='l')
deltat= 20

plot(ts(grip$o, deltat=20))

X =  grip$o-mean(grip$o)
plot(grip$t2,X, type='l')
P = Powerspec(X, 20)



rwelch =    stft(X, win=min(80,floor(length(X)/10)), inc=min(24, floor(length(X)/30)), coef=256, wtype="cosine.window")
KK = apply(rwelch$values, 2, FUN="mean")

f=seq(from=0, to=0.5, length=256)*(1/20)

plot(f, KK, log='y')
plot(f, KK, type='l')

h = locator(type='p', col=2)
1/h$x

###  zoom in

plot(grip$t2, grip$o, type='l')
deltat= 20

win = locator(2, type='p', col=4)

flag = grip$t2>win$x[1] & grip$t2<win$x[2]
tee = grip$t2[flag]
X = grip$o[flag]
X = X - mean(X)

plot(tee,X, type='l')


rwelch =    stft(X, win=min(80,floor(length(X)/10)), inc=min(24, floor(length(X)/30)), coef=256, wtype="cosine.window")
KK = apply(rwelch$values, 2, FUN="mean")

f=seq(from=0, to=0.5, length=256)*(1/20)

plot(f, KK, type='l', log='y')

plot(f, KK, type='l')

LL = apply((rwelch$values^2)/rwelch$windowsize, 2, FUN="mean")

f=seq(from=0, to=0.5, length=256)*(1/20)

plot(f, LL, type='l', log='y')

plot(f, LL, type='l')

