################################  factor analysis "Wed Apr 20 11:59:43 2005"
####   page 502-505 in Davis


###  fa = scan(file="/home/lees/CLASS/Data_Analysis/dos_files/", skip=1, list(x1=0, x2=0))

###  make a matrix  table 6-11
gon = matrix(c(4,27,18,12,25,12,10,23,16,14,21,14), ncol=3, byrow=TRUE)


### sweep out the mean values
m.gon=apply(gon,2,mean)
agon = sweep(gon, 2,m.gon)
###   this is the X matrix in book
X = agon

###  get covariance -  R-mode Analysis
R = t(agon)%*% agon

###   get eigenvalues
egon = eigen(R)

###  note size of last eigne vector ~ 0

LAM2 = diag(egon$values[c(1,2)])
LAM = sqrt(LAM2)


###  look at SVD

sgon = svd(agon)

###  the matrix sgon$v is the U matrix in the book
U = sgon$v

##  get rid of columns that correspond to small singular values
U = sgon$v[,c(1,2)]

###  to get exact book values, switch the sign of second vector, use:
U[,2] = -U[,2]

Ar = U %*% LAM

score1 = agon %*% Ar 

plot(score1[,1], score1[,2])
text(score1[,1], score1[,2], labels=LETTERS[1:4], pos=3)

###  

###  note square of the singular values is same as eigenvalues
sgon$d^2


##########   Q-mode analysis

Q = (agon)%*% t(agon)
V = sgon$u
###   select out only "important directions" based on singular values
V = sgon$u[,c(1,2)]

####  flip the second vector to match the values in Davis
V[,2] = -V[,2]

Aq = V %*% LAM

Sq = t(X) %*% Aq

###   verify relationship:

Ar %*% LAM

##  this matches with the values calculated above.

###  according to Eckart-Young theorem, X should  be equal to:
V %*% LAM %*% t(U)

plot(Sq[,1], Sq[,2])
abline(v=0, h=0, lty=2, col=grey(0.9))
text(Sq[,1], Sq[,2], labels=1:3, pos=3)
arrows(rep(0, 3),rep(0, 3), Sq[,1], Sq[,2] )

###  figures do not look exactly like Davis because of some scaling he has done

##############################################################3
##############################################################3
##############################################################3
##############################################################3

##  read in the data

##  davis page 528
fa = scan(file="/home/lees/CLASS/Data_Analysis/dos_files/FACTOR.TXT", skip=1, list(x1=0, x2=0))
fa = scan(file="D:/LEES/CLASSES/Data_Analysis/dos_files/FACTOR.TXT", skip=1, list(x1=0, x2=0))

plot(fa$x1, fa$x2, type='p', xlim=c(0,20), ylim=c(0,20))
title("Figure 6-29a")

v = cbind(fa$x1, fa$x2)
scv = scale(v)
plot(scv[,1], scv[,2], xlim=c(-2, 2), ylim=c(-2,2), type='p')
title("Figure 6-29b")

S = var(v)

LAM2 = eigen(S)

R =  var(scv)
LAMR = eigen(R)

###  factor loadings:
UA = LAMR$vectors %*%  diag(sqrt(LAMR$values))

###  squared factor loadings should be equal to the eigenvectors
apply(UA^2, 2, sum)

######################################
######################################
####   BOXES  example

boxes = scan(file="/home/lees/CLASS/Data_Analysis/dos_files/BOXES.TXT", skip=1, list(Label='',   x1=0,     x2=0,      x3 =0,     x4=0,      x5=0,      x6 =0,     x7=0,))


boxes = scan(file="D:/LEES/CLASSES/Data_Analysis/dos_files/BOXES.TXT", skip=1, list(Label='',   x1=0,     x2=0,      x3 =0,     x4=0,      x5=0,      x6 =0,     x7=0,))

v = cbind(boxes$x1, boxes$x2, boxes$x3, boxes$x4, boxes$x5, boxes$x6, boxes$x7)


sv = var(v)

g = eigen(sv)
g$values

######

##  page 532 in Davis


###   the scale function in R sweeps the means from the columns and divides by the std

s =scale(v)

###  correlation matrix
vs = var(s)

g = eigen(vs)
g$values

trc = sum(diag(vs))

pcttrc = 100*g$values/trc
cumpct = cumsum(pcttrc)

###   to get values in book, taken negative sign
ev = -g$vectors

plot(g$values, type='p')

LAM = diag(g$values)

ev[,1] *sqrt(g$values[1])

###  factor matrix, p. 532
AR = ev %*% sqrt(LAM)
###

gp = g$values
###  zero out the non important singular values
gp[3:7] = 0

LAMP = diag(gp)
ARp = ev %*% sqrt(LAMP)

Rhat = ARp %*% t(AR)

###  DAVIS formula 6.60, residual variance covariance matrix
Res = vs-Rhat

################################
####  FIGURE ON PAGE 509  6.14
plot(v[,1], v[,2])
text(v[,1], v[,2], labels=boxes$Label, pos=4)

plot(s[,1], s[,2])
text(s[,1], s[,2], labels=boxes$Label, pos=4)

################################

loads = s %*% ARp
plot(loads[,1], -loads[,2])
text(loads[,1], -loads[,2], labels=boxes$Label, pos=4)

###   EQN 6.63 in Davis


loads2 = s %*% solve(vs) %*% ARp
plot(loads2[,1], -loads2[,2])
text(loads2[,1], -loads2[,2], labels=boxes$Label, pos=4)

###########################
###  there may be a problem with the size of the matrices
##  in that case, simply cut them down to manageable size
##  by deleting the parts that do not matter

###  the number of components that are relavant are:
p = 2
SRhat = s %*% ARp[,1:p]  %*% solve(t(ARp[,1:p]) %*% ARp[,1:p]) 
plot(SRhat[,1], -SRhat[,2])
text(SRhat[,1], -SRhat[,2], labels=boxes$Label, pos=4)

####  this is the same as what we calculated before
###########

SV = svd(s)

SV$d

################################

Q = (s)%*% t(s)


V = SV$u



###   select out only "important directions" based on singular values
V = sgon$u[,c(1,2)]

####  flip the second vector to match the values in Davis
V[,2] = -V[,2]

Aq = V %*% LAM

Sq = t(X) %*% Aq
################################
################################

w1 = apply(v*v , 1, sum)

D = diag(w1)

###   w = sweep(v, 1, wa, "/")

###  Ctheta = w %*% t(w) 

###  Davis eqn 6.72
W = sqrt(solve(D))  %*% v

###  this is the Qmode matrix stored in QMODE.TXT:
Q1 = W %*% t(W)

##  this is the rest of eqn 6.74: Davis has an error in my copy
Q = sqrt(solve(D))  %*% v %*% t(v) %*% sqrt(solve(D))
 

################################
################################

Qdavis =  matrix(scan(file="D:/LEES/CLASSES/Data_Analysis/dos_files/QMODE.TXT"), ncol=25, byrow=TRUE)


E = svd(Q)

### compare eigen values with book Table 6-22
print(round(E$d*10000)/10000, digits=6)

##  these are eignevalues since we are using the
##    cosine matrix
##  the corresponding singular values are the sqrt of these


## to be consistent with the book
U = E$v
V = E$u

V[,1] = -V[,1]
V[,2] = -V[,2]

##  zero out all eigen vectors greater than p=7
LAM = diag( rep(0, length(E$d) ) )
LAM[1:7, 1:7 ] = diag(E$d[1:7]) 
 
## factor for table 6-22
Aq = V %*% sqrt(LAM)

#######################FACT = Q %*% V %*% sqrt(LAM)


###  figure 6-33 Davis?

plot(Aq[,1], Aq[,2], asp=TRUE, xlab="Factor 1", ylab="Factor 2")
text(Aq[,1], Aq[,2], labels=LETTERS[1:length(E$v[,1])], pos=4)
abline(h=0)
title("Figure 6-33 Davis")

### figure 6-34 Davis
plot(Aq[,2], E$v[,3], asp=TRUE, xlab="Factor 2", ylab="Factor 3")
text(Aq[,2], E$v[,3], labels=LETTERS[1:length(E$v[,2])], pos=4)
title("Figure 6-34 Davis")


################################
################################

boxglyph<-function(x,y, s, d,w,h , R)
{
#########  draw a box at x,y with width=w height=h, depth=d
###  viewing angle is fixed at 1,1,1
##  there are nine lines to draw
###  from a visual perspective d = x, w=y, h=z
###  w = 3.76; d=3.66; h=0.54
A = sqrt(d^2+w^2+h^2)
d = d/A
w = w/A
h = h/A

mat = matrix(
c(0,0,h,
  d,0,h,
  d,w,h,
  0,w,h,
  d,0,0,
  d,w,0,
  0,w,0), ncol=3, byrow=TRUE)

## transform these

##  S is the scaling matrix
S = diag(s, ncol=3, nrow=3)

##  R is the rotation matrix
g = mat %*% R %*% S

##  x and y are the translations
g[,1] = g[,1]+x
g[,2] = g[,2]+y

##  plot(g[,1], g[,2], type='n', asp=TRUE)
lines(g[c(1:4, 1),1], g[c(1:4, 1),2])
###  text(g[c(1:4),1], g[c(1:4),2], labels=1:4, pos=3)
segments(g[c(2,3,4),1], g[c(2,3,4),2], g[c(5,6,7),1], g[c(5,6,7),2])
segments(g[c(5,6),1], g[c(5,6),2], g[c(6,7),1], g[c(6,7),2])

invisible(g)
}


###########################################
###########################################
###########################################

## rotations  copy from:  source("d:/LEES/R_Programs/R_stuff/rotate.R")
rotx <- function( deg )
  {
    rad1 = deg * 0.0174532;
    r = diag(3)
    r[2, 2] = cos(rad1)
    r[2, 3] = sin(rad1)
    r[3, 3] = r[2, 2]
    r[3, 2] = -r[2, 3]
    return(r)

  }
roty <- function( deg )
  {
    rad1 = deg * 0.0174532;
    r = diag(3)
    r[1, 1] = cos(rad1)
    r[3, 1] = sin(rad1)
    r[3, 3] = r[1, 1]
    r[1, 3] = -r[3, 1]
    return(r)

  }
rotz <- function( deg )
  {
    rad1 = deg * 0.0174532;
    r = diag(3)
    r[1, 1] = cos(rad1)
    r[1, 2] = sin(rad1)
    r[2, 2] = r[1, 1]
    r[2, 1] = -r[1, 2]
    return(r)

  }
###   create the rotation matrix

a1 = -45
i = -(135)

r1 = rotx(a1)
r2 = rotz(i)
R = r2 %*% r1  

##  scale the block sizes
Y = range(v[,1])
y = 0.4+(v[,1]-Y[1])/(Y[2]-Y[1])

###  set up the grid
nx = 5
side = nx
lentop = length(v[,1])

###########################################
###########################################
###########################################

######  Figure 6-13 in Davis
plot(c(0,2*(nx+1)), c(0,2*(nx+1)), asp=TRUE, type='n', axes=FALSE, xlab='', ylab='')

for(i in 1:length(v[,1]))
{
    iy=floor((i-1)/side)+1;
    ix=i-(iy-1)*nx;
    if(ix==0)
      { ix=nx;}

ix = 2*ix
iy = 2*iy

w = v[i,1]
h = v[i,3]
d = v[i,2]

##  R1 = rbind(R, c(4,5,1))
s = y[i]
G = boxglyph(iy,ix, s, d,w,h, R)   
text(G[4,1],G[4,2],labels=LETTERS[i], pos=4)

##  title(LETTERS[i])
##  locator() 
}

###########################################
###########################################
###########################################
##  scale the block sizes
Y = range(v[,1])
y = 0.4+(v[,1]-Y[1])/(Y[2]-Y[1])

###   Figure 6-14
plot(v[,1], v[,2], type='n', xlab="Length", ylab="Width")
##  text(v[,1], v[,2], labels=boxes$Label, pos=4)
title("Figure 6-14 Davis p 509")
for(i in 1:length(v[,1]))
{
w = v[i,1]
h = v[i,3]
d = v[i,2]
##  R1 = rbind(R, c(4,5,1))
s = y[i]
G = boxglyph(w, d, s, d,w,h, R)   
text(G[4,1],G[4,2],labels=LETTERS[i], pos=4)
}

###########################################
###########################################
###########################################

###  figure 6-33 Davis

xy = Aq

plot(xy[,1], xy[,2], type='n', asp=TRUE, xlim=c(0,1.5), ylim=c(-.75,.75), xlab="Factor 1", ylab="Factor 2")

### text(xy[,1], xy[,2], labels=LETTERS[1:length(xy[,1])], pos=4)
abline(h=0, lty=2, col=grey(0.9))
title("Figure 6-33 Davis")
## put in circle:
theta = 0:360
x1 = cos(theta*pi/180)
y1 = sin(theta*pi/180)
lines(x1,y1)

u = par("usr")
a1 = (u[2]-u[1])/20

y = a1+a1*(v[,1]-Y[1])/(Y[2]-Y[1])

for(i in 1:length(v[,1]))
{
w = v[i,1]
h = v[i,3]
d = v[i,2]
##  R1 = rbind(R, c(4,5,1))
s = y[i]
G = boxglyph(xy[i,1], xy[i,2], s, d,w,h, R)   
text(G[4,1], G[4,2],labels=LETTERS[i], pos=4)
}


### figure 6-34 Davis


plot(xy[,2], xy[,3], type='n', asp=TRUE, xlab="Factor 2", ylab="Factor 3")

### text(xy[,1], xy[,2], labels=LETTERS[1:length(xy[,1])], pos=4)
abline(h=0, lty=2, col=grey(0.9))
title("Figure 6-33 Davis")

u = par("usr")
a1 = (u[2]-u[1])/20

y = a1+a1*(v[,1]-Y[1])/(Y[2]-Y[1])

for(i in 1:length(v[,1]))
{
w = v[i,1]
h = v[i,3]
d = v[i,2]
##  R1 = rbind(R, c(4,5,1))
s = y[i]
G = boxglyph(xy[i,2], xy[i,3], s, d,w,h, R)   
text(G[4,1], G[4,2],labels=LETTERS[i], pos=4)
}

#########################################
#########################################
#########################################
#########################################

ig = scan(file="D:/LEES/CLASSES/Data_Analysis/dos_files/IGNEOUS.TXT", skip=1, list(Rock.name='',   Index=0,   SiO2=0,   Al2O3=0,   Fe2O3=0,   FeO=0,   MgO=0,   CaO=0,   Na2O=0,   K2O=0))


###  on gauss
ig = scan(file="/home/lees/CLASS/Data_Analysis/Data_Files/IGNEOUS.TXT", skip=1, list(Rock.name='',   Index=0,   SiO2=0,   Al2O3=0,   Fe2O3=0,   FeO=0,   MgO=0,   CaO=0,   Na2O=0,   K2O=0))


K = cbind(ig$SiO2,   ig$Al2O3,   ig$Fe2O3,   ig$FeO,   ig$MgO,   ig$CaO,   ig$Na2O,   ig$K2O)

w1 = apply(K*K , 1, sum)

D = diag(w1)

###  Davis eqn 6.72
W = sqrt(solve(D))  %*% K

### 
Q1 = W %*% t(W)

## 
Q = sqrt(solve(D))  %*% K %*% t(K) %*% sqrt(solve(D))
 
##   check result in book:
signif(Q, digits=3)

E = svd(Q)

### compare eigen values with book Table 6-22
print(round(E$d*10000)/10000, digits=6)

signif(E$d, digits=4)


##  these are eignevalues since we are using the
##    cosine matrix
##  the corresponding singular values are the sqrt of these


## to be consistent with the book
U = E$v
V = E$u

V[,1] = -V[,1]
V[,4] = -V[,4]

##  zero out all eigen vectors greater than p=7
LAM = diag( rep(0, length(E$d) ) )
LAM[1:7, 1:7 ] = diag(E$d[1:7]) 

## factor for table 6-22
Aq = V %*% sqrt(LAM)
signif(Aq[,1:7], digits=4)


plot(Aq[,1], Aq[,2], asp=TRUE, xlab="Factor 1", ylab="Factor 2")
text(Aq[,1], Aq[,2], labels=paste(ig$Rock.name, ig$Index), pos=4)
abline(h=0)

theta = 0:360
x1 = cos(theta*pi/180)
y1 = sin(theta*pi/180)
lines(x1,y1)
segments(  rep(0, length(Aq[,1])),rep(0, length(Aq[,1])),  Aq[,1], Aq[,2])
title("Figure 6-35 Davis")

### 
plot(Aq[,2], E$v[,3],  xlab="Factor 2", ylab="Factor 3")
text(Aq[,2], E$v[,3], labels=paste( ig$Index, ig$Rock.name), pos=4)

