
##  %%%%  time sequences sampled at irregular intervals
##  %  poisson processees
##  %  read in the aso data

##  analysis described in Davis, pp. 178-183


aso = scan('aso.dat')

y = rep(1,length(aso))



plot(aso, y, type='h')


plot(aso, type='p')

a = diff(aso)

length(a)

hist(a)


ma = 100*floor(min(aso)/100)
Ma = 100*ceiling(max(aso)/100)

intv = 100
K = seq(from=ma, by=intv, to=Ma)

K1 = K[1:(length(K)-1)]
K2 = K[2:length(K)]
KD = rep(1, length(K1))
for(i in 1:length(KD))
  {

        
        
     r =   sum(aso>=K1[i]&aso<K2[i]);
     KD[i] = r;
        
   }
    ##  to get a plot like Davis 4-7, try:
plot( range(c((K1+K2)/2-intv/2,(K1+K2)/2+intv/2))  , range(0, KD), type='n', ylab="Number of events", xlab=paste(sep='', intv, "-year intervals"), main="Aso Eruptions")
rect((K1+K2)/2-intv/2, rep(0, length(KD)) , (K1+K2)/2+intv/2, KD, col=gray(0.9) )
points(aso, rep(max(KD), length(aso) ) )

    
    
## plot(K1, KD, type='h', ylab="Number of events", xlab=paste(sep='', intv, "-year intervals"), main="Aso Eruptions")
##  points(aso, rep(max(KD), length(aso) ) )


##  to get a plot like Davis 4-7, try:
plot(range(K1-intv/2,K1+intv/2) , range(KD), type='n', ylab="Number of events", xlab=paste(sep='', intv, "-year intervals"), main="Aso Eruptions")
rect((K1+K2)/2-intv/2, rep(0, length(KD)) , (K1+K2)/2+intv/2, KD, col=gray(0.9) )
points(aso, rep(max(KD), length(aso) ) )




##   %%%%%%%%%%%%%%%%  Cumulative SUM

   CSK = rep(0, length(aso)) 
   
   for(i in 1:length(aso))
  {
       r = sum(aso<=aso[i]);
       
       CSK[i] = r;
       
     }

   plot(aso, CSK, pch=1, col=2, ylab="Number of Events", xlab="Year of event")
   abline(h=seq(from=10, to=max(CSK), by=10), v=pretty(aso) , lty=2, col=gray(.8) )

##  or:
   K = seq(from=ma, by=1, to=Ma)

   CSK = rep(0, length(K)) 
   
   for(i in 1:length(K))
  {
       r = sum(aso<=K[i]);
       
       CSK[i] = r;
       
     }

   plot(K, CSK, pch=1, col=2, ylab="Cumulative SUM", xlab="Year")
##




##     %%%%%%%%%%%%%%%%  Empricial Survivor
   
   b = rep(0, length(a))
   sa = sort(a);
  
   for (i in 1:length(sa))
  {
       r = sum(sa>=sa[i]);
       b[i] = r;
       
     }
   
       
   plot(sa,b, type='p', col=2, ylab="Percent survivors", xlab="Length of interval, years")


 ##   %  log empirical survivor
   plot(sa, b, log='y',  type='p', col=2, ylab="Percent survivors", xlab="Length of interval, years" )
##    %%%%%%%%%%%%%   or 
sa = min(a):max(a);
b = rep(0,length(sa));

for( i in 1:length(sa))
{
  r = sum(a>=sa[i]);
  b[i] = r;
  
}
   
       
plot(sa,b, type='p' )
 ##  %  log empirical survivor
   plot(sa, b, log='y', type='p')

################################################################
##  serial correlation  plot: t[i]-t[i-1]  vs t[i+1]-t[i]

a1 = aso[1:(length(aso)-2)]
##  lag by one:
a2 = aso[2:(length(aso)-1)]
a3 = aso[3:(length(aso))]


##   figure 4-10 in Davis
plot( a3-a2, a2-a1, type='p', main="Serial Correlation, Aso", xlab="t[i+1]-t[i]", ylab="t[i]-t[i-1]")

   
##    %  make a plot with all the figures on one page
#######################################################################
   
   
par(mfrow=c(2,2))
plot(aso, y, type='h', main="Volcanic Events at Aso Volcano, Japan")



plot(range(K1-intv/2,K1+intv/2) , range(KD), type='n', ylab="Number of events", xlab=paste(sep='', intv, "-year intervals"), main="Aso Eruptions")

rect(K1-intv/2, rep(0, length(KD)) , K1+intv/2, KD, col=gray(0.9) )
points(aso, rep(max(KD), length(aso) ) )

box()


  plot(aso, CSK, pch=1, col=2, main="Comulative Number of Events", ylab="Number of Events", xlab="Year of event")
   abline(h=seq(from=10, to=max(CSK), by=10), v=pretty(aso) , lty=2, col=gray(.8) )

  plot(sa, b, log='y',  type='p', col=2, main="Log Empirical Survivor Function", ylab="Percent survivors", xlab="Length of interval, years" )

par(mfrow=c(1,1))
