data(lynx)
postscript(file ="Lynx.ps" , horizontal=TRUE, onefile=F,print.it=F)

plot(lynx, ylab = expression("Number Lynx Trappings"),
          las = 1)
title("Annual numbers of lynx trappings for 1821-1934 in Canada")
dev.off()

data(co2)

postscript(file ="CO2.ps" ,  horizontal=TRUE, onefile=F,print.it=F)


plot(co2, ylab = expression("Atmospheric concentration of CO"[2]),
          las = 1)

dev.off()

Oinfo = scan(file="/home/lees/DAT/O18.dat", n=6)

O18 = scan(file="/home/lees/DAT/O18.dat", skip=1)


postscript(file ="DO18.ps" , horizontal=TRUE, onefile=F,print.it=F)

plot(seq(from=0, by=3, length=length(O18)), O18, type='l', xlab=expression("Time, years 10^6"), ylab="Delta O18")
dev.off()

postscript(file ="SUNSPOTS.ps" , horizontal=TRUE, onefile=F,print.it=F)

plot(sunspots)
dev.off()


data(sunspots)
plot(sunspots)
data(nhtemp)
plot(nhtemp)
data(faithful)
plot(faithful)
data(airquality)
plot(airquality)

data(airmiles)
plot(airmiles)
##############################################
##############################################
##############################################
tseis = scan(file="/home/lees/DAT/tseis", skip=1)

postscript(file ="Seismic.ps" , horizontal=TRUE, onefile=F,print.it=F)
plot(seq(0, by=0.004, length=length(tseis)) , tseis, type='l', xlab="Time, s", ylab="Amplitude" )
title("Seismic signal, DT=250 samp/s")
dev.off()
##############################################

######## interpolating irregular spaced data

make some data:

plot(c(0, 10), c(4,10), type="n")
g = locator(10)


plot(g$x, g$y, type="p")

alin = approx( g$x,  g$y, seq(from=min(g$x), to=max(g$x),  length=100) , method = "linear"  )
lines(alin$x, alin$y)

aspl = spline(g$x,  g$y, xmin=min(g$x), n=100, method = "fmm")
lines(aspl$x, aspl$y)

plot(aspl$x, aspl$y, type='l')
points(g$x, g$y)
points(aspl$x, aspl$y, col=2)
points(alin$x, alin$y, col=3)
#####

#####  create a time series object in R

ts(data = NA, start = 1, end = numeric(0), frequency = 1,
        deltat = 1, ts.eps = getOption("ts.eps"), class = , names = )

###  auto-correlation

x = 1:100
y = runif(100)
plot(x,y, type='l')

yt = ts(y, start=0, deltat=1)
plot(yt)


acf(y)

##############################################
##############################################
##############################################
##############################################


comb<-function(n, dt, dx)
  {
    x = rep(0,n)
    t = dt*seq(from=0, length=length(x), by=1)
    x[ t%%dx==0 ] = 1
    plot(x, type='l')
    return(x)
  }


x = comb(1000, 1, 50)
plot(x, type='s')
plot(x, type='l')
plot(x, type='h')


spec.pgram(x)
par(mfrow=c(1,1))

x = comb(1000, 1, 10)
spec.pgram(x)

x = comb(1000, 1, 100)
spec.pgram(x)

##################################################
##########################################
##############################################
##############################
####  create sinusoidal signals
dt = 0.001

 t = seq(0, 6, by=0.001)


#   % sample rate = 1000 Hz, 0.001 seconds 601 samples
 x = 6*sin(2*pi*50*t) + 10* sin(2*pi*120*t)

 plot(x[1:50], type='l')

 y = x + 2*rnorm(length(x))

   
 plot(y[1:50], type='l')


 plot(y, type='l')

title('sin(2*pi*50*t) + sin(2*pi*120*t)+ 2*rnorm')

Y = fft(y)

Pyy = Y * Conj(Y)


n = length(Pyy)/2

Syy = Re(Pyy[1:n])

fn = 1/(2*dt)


f = (0:(length(Syy)-1))*fn/length(Syy)

plot(f, Syy, type='l', xlim=c(0, 150))
abline(v=c(50, 120), col=2)
axis(1,at=c(50, 120) )
##############################
##############################################
##############################################
##  make a function out of the above....

naive<-function(y,dt,XL=c(1,length(y)/2), LOG='')
  {
    fn = 1/(2*dt)
               ##  fn = nyquist frequency
    if( missing(XL) )
      {
        XL = c(0,fn)
      }
    if( missing(LOG) )
      {
        LOG=''
      }
    Y = fft(y)
    Pyy = Y * Conj(Y)
    n = length(Pyy)/2
    Syy = Re(Pyy[1:n])
    f = (0:(length(Syy)-1))*fn/length(Syy)

    ## plot the results, add in some features to make the plotting nicer
    plot(f, Syy, type='l', xlab="frequency", ylab="Amp", xlim=XL, log=LOG)
  }
###############
##############################################
##############################################
###
###  run the function and test it
naive(y,dt )

naive(y,dt, XL=c(20,150) )
tapy = spec.taper(y, p=0.1)

plot(tapy)

naive(tapy,dt, XL=c(20,150) )
########  EXAMPLES  ########################
########
data(sunspots)
help(sunspots)

plot(sunspots, main = "sunspots data", xlab = "Year",
          ylab = "Monthly sunspot numbers")
naive(sunspots,1/12 )
naive(sunspots,1/12, LOG='y' )
title("sunspots: naive periodogram, dt=1/12")
locator(1)

########
data(lynx)
help(lynx)
plot(lynx)
naive(lynx, 1)
naive(lynx-mean(lynx), 1)
tapy = spec.taper(lynx-mean(lynx), p=0.1)
naive(tapy, 1)


########

##############################################
##############################################







######  create periodogram without using the fft function
##  i.e. do a DFT from scratch
periodogram <- function(x){
pi <- 3.1415
n <- length(x)
m <- round(n/2)
if(m < n/2)  m <- m
else m <- m -1
k <- c(1:m)
c.sum <- rep(0,m)
s.sum <- rep(0,m)
for (i in 1:m){
c.sum[i] <- sum(x * cos(2*pi*k[i]*c(1:n)/n))
s.sum[i] <- sum(x * sin(2*pi*k[i]*c(1:n)/n))
}
iw <- (c.sum^2 + s.sum^2)/n
return(iw)
}

pery = periodogram(y)
plot(pery)

