cat("sourcing /home/lees/Progs/R_stuff/INSTR.R\n")

###
###  CMG-40T
###  poles = c( complex(real=-.1480E+00, imaginary=0.1480E+00),  complex(real=-.1480E+00 , imaginary =-.1480E+00) )
###  zeros = c( complex(real=0.0, imaginary=0.0), complex(real=0,imaginary=0))
###  poles = complex(real=c(-.1480E+00,-.1480E+00), imaginary =(0.1480E+00, -.1480E+00))
###
###
###  source("/home/lees/Progs/R_stuff/INSTR.R")

###

## /home/lees/Equipment/Sensors

## R40T = ReadSet.Instr('/home/lees/Equipment/Sensors/CMG40T.inst.response')
## R3T  = ReadSet.Instr('/home/lees/Equipment/Sensors/CMG3T.inst.response')


ReadSet.Instr<-function(file)
  {
    cmd = paste(sep=" ","cat ", file)
    INSTF = system(cmd, intern=TRUE)
    a = unlist(strsplit(INSTF[1],split=' '))
    nz = as.numeric(a[2])
    zeros = vector(length=nz, mode="complex")
    for( i in 1:nz)
      {
        a = unlist(strsplit(INSTF[1+i],split='\\ '))
        zeros[i] = complex(real=as.numeric(a[1]), imaginary=as.numeric(a[2]))
      }
    ip= 1+nz+1
    a = unlist(strsplit(INSTF[ip],split=' '))
    np = as.numeric(a[2])
    poles = vector(length=np, mode="complex")
    for( i in 1:np)
      {
        a = unlist(strsplit(INSTF[ip+i],split='\\ '))
       poles[i] = complex(real=as.numeric(a[1]), imaginary=as.numeric(a[2]))
      }
     ip= np+nz+2+1
    a = unlist(strsplit(INSTF[ip],split=' '))
    Knorm =  as.numeric(a[2])
    ip= ip+1
    a = unlist(strsplit(INSTF[ip],split=' '))
    Sense =  as.numeric(a[2])
    return(list(np=np, poles=poles, nz=nz, zeros=zeros, Knorm=Knorm, Sense=Sense))
    
  }


PreSet.Instr<-function()
  {
    ## set up a list of instruments from passcal Guralp
###  usage    Kal = PreSet.Instr()

    types = c("40T", "3T")
    
    K = as.list(types)
    
    K[[1]] = ReadSet.Instr('/home/lees/Equipment/Sensors/CMG40T.inst.response')
    K[[2]] = ReadSet.Instr('/home/lees/Equipment/Sensors/CMG3T.inst.response')

    names(K) = types
        ##  Others?
    return(K)
  }
###
###
###  source("/home/lees/Progs/R_stuff/INSTR.R")

gpoly<-function(x)
  {
    
    e = x;  
    n = length(e);
    c = c(1, rep(0,n));
    for(j in 1:n)
      {
        c[2:(j+1)] = c[2:(j+1)] - e[j]*c[1:j];
      }
    return(Re(c))
  }
###
###  source("/home/lees/Progs/R_stuff/INSTR.R")

polyval<-function(p,x)
  {
    nc = length(p);
    ex = rev(seq(0, nc-1))
    y = rep(0, length(x))
    for( i in 1:length(x))
    y[i] = sum(p * x[i]^ex)
    
    return(y)
  }

###
###  source("/home/lees/Progs/R_stuff/INSTR.R")

makefreq<-function(n,dt)
  {
##% Make frequency vector for Fourier Transforms
##% USAGE: f=makefreq(n,dt);
##%  construct the frequency vector that is consistent with the result of an FFT.
##%  dt is the time-domain sample interval and n is the number of points.
##%
##%  See also FT and IFT.

    if( (n%%2) == 1 )
      {
        f=c(seq(0,(n-1)/2),   seq(-(n-1)/2, -1))/ (n*dt) 
                                        #   frequency vector for odd n
      }
    else
      {
        f=c( seq(0,n/2)   ,     seq(-n/2+1,-1))/(n*dt);   #  frequency vector for even n
      }
    return(f)
  }
###
###  source("/home/lees/Progs/R_stuff/INSTR.R")

FREQS<-function(b,a,w)
  {
    s = complex(real=0, imag=1)*w;
    h = polyval(b,s) / polyval(a,s)
    return(h)
  }
#### 
#### response(Kal, 1, makefreq(1000, 1), tt=c(20,0.008), plotkey=TRUE)

#### response(Kal, 1, makefreq(20, 0.008), tt=c(20,0.008), plotkey=FALSE)
####
###  source("/home/lees/Progs/R_stuff/INSTR.R")


response<-function(Kal,key,ff,tt=tt,plotkey=FALSE)
  {
    if(missing(plotkey)) { plotkey=FALSE }
    if(missing(tt)) {   tt=c(20,0.008) }

    
    Calib = Kal[[key]]
    norm  =Calib$Knorm;
    gain = Calib$Gain;
    meands=Calib$Sense;
    npole =Calib$np;
    nzero =Calib$nz;
    poles =Calib$poles;
    zeroes=Calib$zeros;

    print(paste(sep=" ","RESPONSE:", npole, nzero, norm, gain))
    print(poles)
    print(zeroes)
    
    
    bb    =gpoly(zeroes);             ##  convert zeros to polynomial coefficients 
    aa    =gpoly(poles);              ##  convert poles to polynomial coefficients


    if(length(ff)==2)
      {
        f=logspace(ff[1],ff[2]);
      }
    else
      {
        f = ff
      }
    w=2*pi*f;
    transfer=FREQS(bb,aa,w)*norm;


if(length(tt)>0)
  {
  sintr=tt[2]                   ## % sample interval
  n=floor(tt[1]/sintr)          ## % number of time points
  n=n+(n%%2)                ##  % force n to be even
  n2=n/2
  tstart=sintr*(1-n2)           ## % time of first sample
  d=rep(0, length=n)                  ## % d is a delta function at time=0
  d[n2]=1/sintr
  
  DRET=ft(d,n,tstart,sintr);      ##% fourier transform of delta function

  f1 = DRET$f
  
  RESP =(ift(DRET$G*FREQS(bb,aa,2*pi*f1)*norm,n,tstart,sintr)); ##% inv trans

  resp=Re(RESP$g)
  
}


    

    if(plotkey==TRUE)
      {
        par(mfrow=c(2,1))
        mag=Mod(transfer)
        # plot(ff, mag, log='xy', axes=FALSE)
        plot(f, mag, type='l', log='xy', axes=FALSE,   xlab="", ylab="")
        axis(1)
        axis(2)
        title(main='transfer function', xlab="frequency (Hz)", ylab='amplitude' )
        box()
        phase=Arg(transfer);
        plot(f, LocalUnwrap(phase), type='l', log='x', axes=FALSE,   xlab="", ylab="")
        axis(1)
        axis(2)
        title(main='transfer function', xlab="frequency (Hz)", ylab='phase' )
        box()
        locator(1)
         par(mfrow=c(1,1))
        plot(RESP$t, resp, type='l', main='impulse response function', xlab="time (s)", ylab='amplitude')
      }


    
    return(list(transfer=transfer  ,aa=aa, bb=bb, resp=resp))
    
    ##transfer=[]; resp=[]; t=[]; f=[];
  }
###  source("/home/lees/Progs/R_stuff/INSTR.R")


###  s = j*w;
###   hh = polyval(b,s) ./ polyval(a,s);
###   response      compute impulse response and transfer function
### Usage: [transfer,resp,f,t]=response(Calib,key,ff,tt,plotkey);
###
### Convert poles and zeros of transfer function to polynomial coefficients, 
### and calculate the amplitude and phase response, and the impulse response.
### Calib(1)    = normalization
### Calib(2)    = meands (gain)
### Calib(3)    = number of poles
### Calib(4:32) = complex poles
### Calib(33)   = number of zeros
### Calib(34:62)= complex zeros
###
### NOTE:  Gain is not included in these calculations, but normalization is.
###
### Calculate transfer function only if length(ff)>0
### Calculate instrument response only if length(tt)>0
###
###INPUT PARAMETERS:
### Calib(62xN) = complex array containing the poles and zeros of N instruments
### key         = use poles and zeros from the keyth column of Calib
### ff          = evaluate transfer function at the frequencies (Hz) in ff
###               if ff has 2 elements evaluate at log spacing from 10^f(1)->10^f(2)
### tt          = time duration (s) and sample interval (s/sample) of time vector 
###               for impulse response
### plotkey    = make plots if this parameters exists. pause after plot if plotkey>0
###
###OUTPUT PARAMETERS:
### transfer    = transfer function evaluated at frequencies (f)
### resp        = impulse response evaluated at times (t)
### f           = frequency vector corresponding to transfer function (Hz)
### t           = time vector corresponding to impulse response (s)

###  adapted from  K. Creager  kcc@geophys.washington.edu   12/30/93

##########################################################################
ft<-function(g,n,tstart,dt)
  {

#####%   ft            Fourier Transform with time shift and sample interval scaling
#####% USAGE: [G,f,t]=ft(g,n,tstart,dt);
#####% Compute the Fourier Transform of g(t) correcting for time offsets and sample
###% interval.  Output is scaled using conventions of continuous transforms in
###% Aki and Richards and in J.H. Karl.
###%
###% INPUT: g is a column vector time series evaluated at times specified by
###%        tstart and dt.  if tstart is a vector, it is the time vector and
###%        dt is not necessary. if tstart is a scalar, it is the start time
###%        and the sample interval is dt.  n is the number of points in the FFT.
###%        g is truncated or zero-padded to n points.
###%
###% OUTPUT: G is the Fourier Transform of g.  it is scaled by dt to be
###%        consistent with the continuous transform.  the time shift
###%        theorem has been used to account for time not starting at t=0.
###%        the length of G is n.
###%        f is the frequency vector for G.
###%        t is the time vector for g.
###%
###% See also IFT and MAKEFREQ.

###% K. Creager  kcc@geophys.washington.edu   12/30/93

                   
    N=length(g)                    #% length of input time-domain vector
    if(length(tstart)>1 )
      {
                                        #% define time vector
        t=tstart;
        tstart=t(1);
        dt=t(2)-t(1);
      }
    else
      {
        t=tstart+seq(from=0,by=dt,to=(N-1)*dt)    #% time vector
      }


if(length(t)!=N)
  {
  ### error('size of time and data vectors must be the same in FT')
  }

    f=makefreq(N,dt);                    #% construct the frequency vector
    i = complex(real=0, imaginary=1)   
    G=dt*fft(g)*exp(-2*pi*i*tstart*f)
                                        #% forward fourier transform with time shift
    return(list(G=G, f=f, t=t))
}


###################################################################
###################################################################
###################################################################
###  source("/home/lees/Progs/R_stuff/INSTR.R")


ift =function(G,n,tstart,dt)
{
  
  ### function [g,f,t]=ift(G,n,tstart,dt);
##%   ift           Inverse Fourier Transform, time shifts, sample interval scaling
##% USAGE: [g,f,t]=ift(G,n,tstart,dt);
##% Compute the Inverse Fourier Transform of G(f) and order the output to match
##% a time vector that starts at tstart and has a sample interval of dt.
##% n is the length of the time vector and of g.  An N point IFFT is calculated
##% where N is the length of G.  Output is scaled according to the conventions of
##% continuous transforms in Aki and Richards and in J.H. Karl.
##%
##% INPUT: G is a column vector spectrum evaluated at positive and negative
##%        frequencies as defined by MAKEFREQ.
##%        tstart, dt and n define the output time vector as described above.
##%
##% OUTPUT: g is the Inverse Fourier Transform of G.  it is scaled by dt to be
##%        consistent with the continuous transform.  the time shift
##%        theorem has been used to account for time not starting at t=0.
##%        f and t are the time and frequency vectors for g and G.
##%        the lengths of g and t are n.
##%
##% See also FT, and MAKEFREQ.

##% K. Creager  kcc@geophys.washington.edu   12/30/93


N=length(G);                    ##% length of input time-domain vector
## t=tstart(1)+[0:dt:(n-1)*dt]';   ##% time vector
t=tstart[1]+seq(from=0,by=dt,to=(n-1)*dt)
f=makefreq(N,dt)
i = complex(real=0, imaginary=1)
g=(1/(N*dt))*fft(G*exp(2*pi*i*tstart*f), inverse = TRUE); ##% inverse fourier transform with time shift
g=g[1:N];                             ##%truncate time vector to n points.

return(list(g=g, f=f, t=t))


}
###  source("/home/lees/Progs/R_stuff/INSTR.R")
logspace<-function(d1, d2, n=n)
  {
###%LOGSPACE Logarithmically spaced vector.
###%   LOGSPACE(X1, X2) generates a row vector of 50 logarithmically
###%   equally spaced points between decades 10^X1 and 10^X2.  If X2
###%   is pi, then the points are between 10^X1 and pi.
###%
###%   LOGSPACE(X1, X2, N) generates N points.
###%   For N < 2, LOGSPACE returns 10^X2.
###%
###%   See also LINSPACE, :.

###%   Copyright 1984-2002 The MathWorks, Inc. 
###%   $Revision: 5.11 $  $Date: 2002/01/24 06:05:07 $

    if(missing(n)) { n = 50 }

    if(d2 == pi)
      {
        d2 = log10(pi);
      }
    vec = c(d1+(0:(n-2))*(d2-d1)/(floor(n)-1), d2)
    
    
    y = (10)^vec
    
    return(y)
  }
##########################################
###  source("/home/lees/Progs/R_stuff/INSTR.R")

##########################################
LocalUnwrap<-function(p,cutoff=cutoff)
{
###%LocalUnwrap   Unwraps column vector of phase values.
if(missing(cutoff)) { cutoff = pi;  }
m = length(p); 

###% Unwrap phase angles.  Algorithm minimizes the incremental phase variation 
###% by constraining it to the range [-pi,pi]
dp = diff(p);                ##% Incremental phase variations
dps = (dp+pi %% 2*pi ) - pi;      ##% Equivalent phase variations in [-pi,pi)
dps[dps==-pi & dp>0] = pi;     ##% Preserve variation sign for pi vs. -pi
dpcorr = dps - dp;              ##% Incremental phase corrections
dpcorr[abs(dp)<cutoff] = 0;   ##% Ignore correction when incr. variation is < CUTOFF

##%% Integrate corrections and add to P to produce smoothed phase values
p[2:m] = p[2:m] + cumsum(dpcorr);

return(p)

}
##########################################
###  source("/home/lees/Progs/R_stuff/INSTR.R")


deconinst<-function(data, sintr, KAL,key, Calibnew, waterlevel=1.e-8)
  {

    ##  x = EJ10$dat[,2]

    #### data = deconinst(x, 0.008, Kal,1, waterlevel=1.e-8)

    
##% deconvolve instrument response
##% Usage: data=deconinst(data,Calibold,Calibnew,sintr,key,waterlevel);
##%
##% Deconvolve old instrument response from data and convolve new 
##% instrument response.  Stabalize using a waterlevel (eg = 1e-6).
##%
##%INPUT PARAMETERS:
##% data        = real matrix of time series stored by columns
##% Calibold   = complex matrix of instrument responses stored by columns
##%               There are 62 rows in a format described below.
##% Calibnew   = complex column vector describing the new instrument response
##%               If there are 62 rows it contains poles and zeros in the 
##%               format described below.
##%               If Calibnew has fewer than 62 rows, the first
##%               element is a key to the description of the new response
##%               If Calibnew(1)==3 then use a cos (hanning) taper
##%                 In this case Calibnew contains 7 numbers:
##%                 [3,waterlevel,gain,f1,f2,f3,f4]
##% sintr       = real row vector of sample intervals (s)
##%               must all be the same
##% key         = row vector containing the data columns to deconvolve
##%               for example deconvolve all m columns if key=[1:m] 
##% waterlevel  = optional parameter used to stabalize the deconvolution
##%               default value is 1.e-8
##%OUTPUT parameters:
##% data        = deconvolved data
##%



    if(missing(waterlevel))
      {
        waterlevel=1.e-8
      }                                           ##% default waterlevel

    if(exists("Calibnew")==FALSE)
      { 
        Calibnew = c(1,1.0, 0.0 )      
      }

    
    n=length(data)                          ##% number of data
    nn=next2(n)                             ##% next power of 2 for FFT
    ###   could use nextn(n,2) here
    f=makefreq(nn,sintr);                     ##% define frequency vector


    instnew =1
    meandsnew = 1
    
    ##  need to zero pad the data
    ## remove the mean also 
    why = c(data-mean(data),rep(0,nn-n))

    DATA=fft(why)
    ###  what are these?  appropriate for Myake-jima decon?
   ## Calibnew = c(3,1.0, 0.4882812, 0, 0.0, 0.4882812)
   ## Calibnew = c(3,1.0, 0.4882812, 0, -0.4882812, 0.0)
   ## Calibnew = c(3,1.0, 0.4882812 )
   ## Calibnew = c(3,1.0, 0.4882812 )

    ##   better to try this:
   ## Calibnew  Calibnew = c(1,1.0, 0.0 )

    
    
    calibkey = Calibnew[1]
    if(calibkey==3)
      {
        meandsnew=Re(Calibnew[2])
        g=abs(f);
        fcut  = Calibnew[3]*max(g)
        i3=(g<=fcut);
        fk = f[i3]
        f1 = fk[1]
        f2 = max(fk)
        f3 = min(fk)
        f4 = fk[length(fk)]
        i1=(f>=f1&f<=f2);
        i2=(f>=f3&f<=f4);
        instnew=f*0;
        instnew[!i3]=instnew[!i3]+1;
        instnew[i1]=0.5*(1-cos(pi*(f[i1]-f1)/(f2-f1)));
        instnew[i2]=0.5*(1+cos(pi*(f[i2]-f3)/(f4-f3)));
      }
    calibkey = Calibnew[1]
    if(calibkey==1)
      {
        meandsnew=Re(Calibnew[2])
        instnew=f*0;
        instnew=instnew+1
      }


    
    ##  disp(['Deconvolving instrument response from trace ',int2str(k)]);
    instold=response(KAL,key,f, plotkey=FALSE);
    
    ###plot(instold$resp, xlim=locator(2)$x)
    ###plot(f,   Mod(instold$transfer))
    ### l = locator(2)
    ###plot(f,   Mod(instold$transfer),  xlim=l$x)

    temp1= Re(instold$transfer*Conj(instold$transfer)) ;
    
    gamma=max(temp1)*waterlevel;
    
    ###  temp= Re(instnew$transfer*Conj(instold$transfer)) / (temp1+gamma);
   ###  temp=  instnew / (temp1+gamma);
###  temp=  instnew / (instold$transfer+gamma);

    ###  tempdata=Re(fft(DATA*temp,inverse = TRUE ));


    temp=instnew*Conj(instold$transfer)/(temp1+gamma)
    
    tempdata=Re(fft(DATA*temp,inverse = TRUE )/nn);
    
    da=tempdata[1:n];
    
    meandsold=KAL[[key]]$Sense
    
    d=da*meandsnew/meandsold;
    ### l = locator(2)
        ###  plot(d, xlim=l$x)
    
    return(d)
    
}
##########################################
###  source("/home/lees/Progs/R_stuff/INSTR.R")

finteg<-function(data, dt)
  {

    waterlevel=1.e-8
    
    n=length(data)                          ##% number of data
    nn=next2(n)                             ##% next power of 2 for FFT
    f=makefreq(nn, dt);                     ##% define frequency vector
    why = c(data-mean(data),rep(0,nn-n))
    DATA=fft(why)


    temp1 =  dt*f*complex(real=0, imaginary=1)*2*pi
    ## gamma=max(Re(temp1))*waterlevel;
    temp1[Im(temp1)==0.0 ] = dt*complex(real=0, imaginary=waterlevel)*2*pi

    
    
    temp=complex(real=1, imaginary=0.0)/(temp1)
    
    tempdata=Re(fft(DATA*temp,inverse = TRUE )/nn);

    da=tempdata[1:n];
    return(da)

    
  }
