######  Inversion  R Stuff
#################################################
######  source("/home/lees/Progs/R_stuff/Inv.R")



## source(
## uw_resid_stat P < lq4.1992.rloc > ho

##  ray path files
##   ident, name, trutim, ttq, ster, nnod, lolev, ifl, scor, res


##  cd /home/lees/Site/BOS/INV92/

## these are functions for reading in data from a ray file  
##  readray RAY2.B > RAY2.res
##  a = get.ray.res("/home/lees/Site/BOS/INV92/RAY2.res")
#################################################
######  source("/home/lees/Progs/R_stuff/Inv.R")

get.ray.res<-function(file)
{
	a = scan(file=file, list(id=' ', sta=' ', trutim=0,
		ttq=0,ster=0,nnod=0,lolev=0,ifl=0, 
		scor=0, res=0))

        
return(a)

}

#################################################
######  source("/home/lees/Progs/R_stuff/Inv.R")
######  res = set.res(a,stas)

set.res<-function(a, sta)
{
	res =split(a$res-a$scor, a$sta)
        cors = split(a$scor, a$sta)
        
	len = sapply(res, length)
	nms = names(res)
	mns=sapply(res, mean)
	mds=sapply(res, median)
	ista = match(nms, sta$nm)
        scor = sapply(cors, mean)
return(list(res=res, nms=nms, len=len, mns=mns, mds=mds, ista=ista, scor=scor))

}
#####
jscale<-function(a, j)
  {
     H = j*(a-min(a))/(max(a)-min(a))
     return(H)
  }
#################################################

plot.staparm<-function(lat, lon, nm, ista, g)
  {

    tom = tomo.col(100)
    plot(lon[ista], lat[ista], type='n', xlab="Lon", ylab="Lat")
    
    H = floor(jscale(g, 99))+1
    
    points(lon[ista], lat[ista],pch=16, col=tom[H])
  
    text(lon[ista], lat[ista], labels=format(g, digits=4), col=tom[H], pos=3 )
    text(lon[ista], lat[ista], labels=nm[ista], col=tom[H], pos=1 )
    
    HOZscale(g, tom ,units="N" )
    
  }
######  source("/home/lees/Progs/R_stuff/Inv.R")
###### plot.stares(res,  stas)
plot.stares<-function(res,  stas)
{

  par(mfrow=c(2,2))

    plot.staparm(stas$lat,stas$lon, stas$nm, res$ista, res$mns )
    title("Mean per Station")

  plot.staparm(stas$lat,stas$lon, stas$nm, res$ista, res$len )
  title("Number per Station")

  
  plot.staparm(stas$lat,stas$lon, stas$nm, res$ista, res$mds )
     title("Median per Station")
}
#################################################
######  source("/home/lees/Progs/R_stuff/Inv.R")

plot.res<-function(a)
{
  h = a$res-a$scor
  
        par(mfrow=c(2,2))
        plot(h, pch='.')
          abline(h=c(-0.5, 0.5), col=4)
        boxplot(h)
        abline(h=c(-0.5, 0.5), col=4)
        qqnorm(h)
        hist(h)
       abline(v=c(-0.5, 0.5), col=4)

}
#################################################
######  source("/home/lees/Progs/R_stuff/Inv.R")
######  stas = get.stas("/home/lees/Site/BOS/INV92/sta.uw.1992.LLZ")

get.stas<-function(file)
{
	a = scan(file=file, list(nm=' ',lat=0, lon=0, z=0))   
return(a)
}
#################################################
show.stas<-function(a)
{
plot(stas$lon, stas$lat, type = 'n')
text(stas$lon, stas$lat, labels=stas$nm)

}
###############
###############  
###############
########################################
tomo.col<-function(n)
{
    if ((n <- as.integer(n[1])) > 0) 
	{
	start=0
	end = 1
	specsize = end - start;
	 aa = 6.283185;
	 bb = 1.99647;
	lighterBlue = .5
	redHue = 0;
	dist = start +(seq(0,(n - 1)) * specsize) / (n - 1);
	tomoval = dist * 2 - 1.0;   #   /* Value in range [-1..1] */
	value = atan(aa*tomoval) * atan(aa*tomoval) / bb;

	hue = rep( redHue,length(tomoval))
	hue[tomoval<0] = lighterBlue
	value[value>1] = 1

	COL = hsv(h=hue , s=1.0, v=value)

	}	
	
    return(COL)

}

#################################################
######  source("/home/lees/Progs/R_stuff/Inv.R")
###############


#################################################
######  source("/home/lees/Progs/R_stuff/Inv.R")
###############


