cat("sourcing /home/lees/Progs/R_stuff/MAP.R\n")

##   source("/home/lees/Progs/R_stuff/MAP.R")
#####################
##### 1 feet = 0.3048 meters
MAPconstants<-function()
  {
 A.MAPK<<-6378206.4
 E2.MAPK<<-0.00676866
 E.MAPK<<-0.0822719
 E1.MAPK<<-0.993231340
 TwoE.MAPK<<-0.164543800
 R.MAPK<<-6378.2064 
 DEG2RAD<<-pi/180
 RAD2DEG<<-180/pi
 FEET2M<<- 0.3048
 M2FEET<<-1/FEET2M
}
###
#####################
##   source("/home/lees/Progs/R_stuff/MAP.R")
setzoom<-function()
  {
    p = locator()
    LL = XY.GLOB(p$x, p$y)
    return(list(x=LL$lon, y=LL$lat, lat=LL$lat, lon=LL$lon))
  }
##   source("/home/lees/Progs/R_stuff/MAP.R")
mlocate<-function()
  {
    p = locator()
    LL = XY.GLOB(p$x, p$y)
    return(list(x=LL$lon, y=LL$lat, lat=LL$lat, lon=LL$lon))
  }

##   source("/home/lees/Progs/R_stuff/MAP.R")

plottarg<-function(MLOC)
  {
   XY =GLOB.XY(MLOC$lat, MLOC$lon)
   rect(XY$x[1], XY$y[1], XY$x[2], XY$y[2], lwd=1.5)
  }



###
setEQSLOCS<-function(F)
{

  eq  = scan(F, list(name="", lat=0, lon=0, z=0, M=0))
  return(eq)

}
#####################################   
setEQSLLZM<-function(FL, LLIM=NULL )
{
  ##  run this on an AC file to get the LLZM file
  ## ac2latlonzM.prl < all_98_99.ac > all_98_99.LLZM

  if(missing(LLIM)) { LLIM=NULL }

  eq  = scan(FL, list(lat=0, lon=0, z=0, M=0))

  
  elon  =  fmod(eq$lon, 360.0)
  
  lat1 = LLIM$lat[1]
  lat2 = LLIM$lat[2]
  lon1 =  fmod(LLIM$lon[1], 360.0)
  lon2 =  fmod(LLIM$lon[2], 360.0)
  
  flag = eq$lat>=lat1 & eq$lat<=lat2 & elon>=lon1 & elon<=lon2

  return(list(lat=eq$lat[flag],  lon=elon[flag], z=eq$z[flag], M=eq$M[flag]))

}

#####################
##   source("/home/lees/Progs/R_stuff/MAP.R")
#####################
setMarkup<-function(LABS=NULL)
  {
    if(missing(LABS)) { LABS= NULL }
    
    if(!is.null(LABS))
      {
        N = length(LABS)
        MM = as.list(1:N)
        for(i in 1:N)
          {
            lab = LABS[i]
            print(paste(sep=' ', i, lab) )
            print("click in figure pairs for arrows")
            L = locator(2)
            apos = readline(prompt="Type in the position (1,2,3,4)  ROT(T, F):")
            kin = unlist(strsplit(apos, " "))
            pos = as.numeric(kin[1])
            rot = kin[2]
            angdeg = 180*atan2(L$y[2]-L$y[1],L$x[2]-L$x[1])/pi
            x1=L$x[1]
            y1=L$y[1]
            x2=L$x[2]
            y2=L$y[2]
            
            MM[[i]] = list(x1=x1, y1=y1, x2=x2, y2=y2, lab=lab, pos=pos,
                angdeg=angdeg, ROT=rot, ARR=TRUE, CEX=1)
            names(MM) = LABS
          }
      }
    else
      {
        print("click in figure pairs for arrows")
        L = locator()
        N = length(L$x) / 2
        MM = as.list(1:N)
        
        for(i in 1:N)
          {
            j = (i-1)*2+1
            
            arrows(L$x[j],L$y[j] ,L$x[j+1],L$y[j+1] )
             angdeg = 180*atan2(L$y[j+1]-L$y[j],L$x[j+1]-L$x[j])/pi

          
                lab = readline(prompt="Type in the label:")
             
            print(paste(sep=' ', i, lab) )
            rot = FALSE
            apos = readline(prompt="Type in the position (1,2,3,4):")
            pos = as.numeric(apos)
            x1=L$x[j]
            y1=L$y[j]
            x2=L$x[j+1]
            y2=L$y[j+1]
            

             MM[[i]] = list(x1=x1, y1=y1, x2=x2, y2=y2, lab=lab, pos=pos,
                angdeg=angdeg, ROT=rot, ARR=TRUE, CEX=1)
           
            
          }
      }
    
    return(MM)
  }
#####################
##   source("/home/lees/Progs/R_stuff/MAP.R")
#####################
Markup<-function(MM=MM, cex=cex, ...)
  {

    if(missing(cex)) { cex=1 }
    N = length(MM)
    for(i in 1:N)
      {
        if(is.null(MM[[i]]$CEX))
          { charex = cex }
        else
          {
            charex = MM[[i]]$CEX
          }

        
        
        if(MM[[i]]$ARR==TRUE)
          {
            arrows(MM[[i]]$x1,MM[[i]]$y1 , MM[[i]]$x2,MM[[i]]$y2, ...)
          }
        
        if(MM[[i]]$ROT==TRUE)
          {
            text(MM[[i]]$x1,MM[[i]]$y1, labels=MM[[i]]$lab, adj=MM[[i]]$adj,   pos=MM[[i]]$pos, srt=MM[[i]]$angdeg, cex=charex)
          }
        else
          {
            
            text(MM[[i]]$x1,MM[[i]]$y1, labels=MM[[i]]$lab, adj=MM[[i]]$adj,   pos=MM[[i]]$pos, cex=charex)
          }
        

        
      }
    
  }
#####################
##   source("/home/lees/Progs/R_stuff/MAP.R")
#####################

MAPID<-function()
  {
### 
###
    mtext("CLICK in MAP WINDOW to get points",side=3,line=2, cex=2)
    tl = locator(type='p')
    gl = XY.GLOB(tl$x, tl$y)
    
    return(gl)
  }




#####################
##   source("/home/lees/Progs/R_stuff/MAP.R")
#####################

KMscale<-function(kmL=kmL, len=500, units="km")
  {
    if(missing(kmL)) { kmL = NULL }
    
    u = par("usr")
    dy = (u[4]-u[3])*0.01
    if(is.null(kmL) )
      {
        kmL = locator(2)
        if(length(kmL)<1) { kmL =  NULL }
   
      }
    if(missing(len))
      {
       tL = (u[2]-u[1])*0.10
       L1 = pretty(tL)
       len = L1[1]
      }
    if(missing(units))
      {
        units="km"
      }

    if(is.null(kmL)==TRUE)
      {
        temx = u[1]+0.05*(u[2]-u[1])
        temy = u[3]+0.05*(u[4]-u[3])
        
        kmL=list(x=c(temx), y=c(temy))
        rect(kmL$x[1],kmL$y[1]-dy,  kmL$x[1]+len,     kmL$y[1]+2*dy, col=gray(1), border=gray(1))
        
      }
 
    segments(kmL$x[1], kmL$y[1],    kmL$x[1]+len, kmL$y[1],    lwd=2)
    segments(kmL$x[1], kmL$y[1]-dy, kmL$x[1],     kmL$y[1]+dy, lwd=2)
    segments(kmL$x[1]+len, kmL$y[1]-dy, kmL$x[1]+len,     kmL$y[1]+dy, lwd=2)

    text( kmL$x[1]+len/2, kmL$y[1], labels=paste(sep=" ", len, units) , pos=3)
    
    invisible(kmL)
  }
#####################
##   source("/home/lees/Progs/R_stuff/MAP.R")
#####################

VANE<-function(vane=vane)
  {
    if(missing(vane))
      {
        vane = locator(2)
      }
    arrows(vane$x[1], vane$y[1], vane$x[1], vane$y[2], length = 0.18)
    text(vane$x[1], vane$y[2], "N", pos=3)
    return(vane)
  }
#########################################
##   source("/home/lees/Progs/R_stuff/MAP.R")

#####################
setGenmap<-function(FN, setlim=FALSE)
{
  if(missing(setlim)) { setlim=FALSE }
  
 ##  loc = paste(sep="", FN, "/*.spmap")
 ##   c1 = paste(sep=" ", "ls -1" , loc, " > Gen.rmap")


  c1 = paste(sep=" ", "LS.prl " , FN, " > Gen.rmap")
  
  system(c1)
  
  cmap = scan("Gen.rmap", what='')
  genmap.lat=as.list(cmap)
  genmap.lon=as.list(cmap)
  genmap.kind=as.list(cmap)
  genmap.name=as.list(cmap)
  genmap.code=as.list(cmap)
  genmap.col=as.list(cmap)

  for(i in 1:length(cmap))
    {
      kay=strsplit(cmap[i], "\\.")
      nm = strsplit(kay[[1]][1], "\\/")
      len = length(nm[[1]])

      
      genmap.kind[[i]] = as.numeric(kay[[1]][2])
      genmap.col[[i]] = as.numeric(kay[[1]][3])
      genmap.code[[i]] = as.character(kay[[1]][4])

      genmap.name[[i]] = (nm[[1]][len])
      
      map1=scan(file=cmap[i], list(x=0, y=0), quiet=TRUE)
      print(paste(sep=' ', i, cmap[i]))
      
      genmap.lat[[i]]=map1$y
      genmap.lon[[i]]=map1$x
      ###  genmap.lon[[i]]=fmod(map1$y, 360.0)
    }

  
  par(mfrow=c(1,1))
  plot(unlist(genmap.lon), unlist(genmap.lat), xlab="Lon", ylab="Lat", type="n")
  for(i in 1:length(genmap.lon))
    {
      lines(unlist(genmap.lon[i]), unlist(genmap.lat[i]))
    }

  GLAT= range(unlist(genmap.lat))
  GLON= range(unlist(genmap.lon))
  SLAT = stats(unlist(genmap.lat))
  SLON = stats(unlist(genmap.lon))

  u = par("usr")
  MAPLIM  <<- list(x=c(u[1], u[2]), y=c(u[3],u[4]))
  MAPLIM$lat <<- MAPLIM$y
  MAPLIM$lon <<- MAPLIM$x

  if(setlim==TRUE)
    {
          u = par("usr")
          text(u[1]+0.05*(u[2]-u[1]), u[3]+0.05*(u[4]-u[3]),
               labels="SELECT the BOUNDS of the MAP WINDOW", cex=2, pos=4)
          print("You must click in the map to set the limits of the map")
          MAPLIM <<- locator(2)
          MAPLIM$lat <<- MAPLIM$y
          MAPLIM$lon <<- MAPLIM$x
        }
      else
        {
          u = par("usr")
          MAPLIM <<- list(x=c(u[1], u[2]), y=c(u[3],u[4]))
          MAPLIM$lat <<- MAPLIM$y
          MAPLIM$lon <<- MAPLIM$x
        }
      
    
  MLOC <<- MAPLIM
  
  setPROJ(type=2, LAT0=mean(MAPLIM$lat), LON0=mean(MAPLIM$lon),
          LATS=list(S=min(MLOC$y), N=max(MLOC$y)),
          LONS=list(E=max(MLOC$x), W=min(MLOC$x) ),
          DLAT=abs(MLOC$y[2]-MLOC$y[1]),
          DLON=abs(MLOC$x[2]-MLOC$x[1]) )
  
  return(list(lat=genmap.lat, lon=genmap.lon, kind=unlist(genmap.kind), name=unlist(genmap.name), col=unlist(genmap.col), code=unlist(genmap.code), GLAT=GLAT, GLON= GLON , SLAT=SLAT, SLON=SLON))
  
}
#########################################
##   source("/home/lees/Progs/R_stuff/MAP.R")

#####################
GENmap<-function(cmp, ADD=TRUE, ASP=TRUE, DIR=0)
{
#  plot a map created from a lees map (see above)
  if(missing(ASP)) { ASP = FALSE }
    if(missing(ADD)) { ADD = FALSE }
    if(missing(DIR)) { DIR = 0 }
    
  DX = range(unlist(cmp$lon))
  DY = range( unlist(cmp$lat))

  #  Y-direction km
  #  D1 = GreatDist(DX[1],DY[1], DX[1],  DY[2])
  #  X-direction km
  #  D2 = GreatDist(DX[1],DY[1], DX[2],  DY[1])

  #  Y-direction km
  D1 = GreatDist(DX[1],DY[1], DX[1],  DY[1]+1)
  #  X-direction km
  D2 = GreatDist(DX[1],DY[1], DX[1]+1,  DY[1])

  if(ADD==FALSE)
    {
  if(ASP==TRUE)
    {
      ASPRAT = D1$dkm/D2$dkm
      plot(unlist(cmp$lon), unlist(cmp$lat), asp=ASPRAT, xlab="Lon", ylab="Lat", xlim=cmp$ZM$x, ylim=cmp$ZM$y, type="n")
      
    }
  else
    {
        plot(unlist(cmp$lon), unlist(cmp$lat), xlab="Lon", ylab="Lat", xlim=cmp$ZM$x, ylim=cmp$ZM$y, type="n")

    }
}
 
  for(i in 1:length(cmp$lon))
    {

      x = fmod(unlist(cmp$lon[i]), 360)
      y = unlist(cmp$lat[i])

      if( DIR == -1 )
        {
          x = x-360
        }
      
      if(cmp$kind[i] == 1)
        {
          points(x, y)
        }
      if(cmp$kind[i] == 2)
        {
          lines(x, y)
        }
      if(cmp$kind[i] == 3)
        {
          polygon(x, y, col=gray(.95))
        }
    }
  
}
#####################
##   source("/home/lees/Progs/R_stuff/MAP.R")
#####################
GPROJm<-function(cmp, LAT=x, LON=y, pts=NULL, ADD=TRUE, WIN=NULL,
                   ASP=TRUE, NUM=FALSE, COL=FALSE, SEL=NULL, PLOT=TRUE)
{
#  plot a map created from a lees map (see above)
  if(missing(ASP)) { ASP = FALSE }
    if(missing(ADD)) { ADD = TRUE }
    if(missing(pts)) { pts = NULL }
    if(missing(NUM)) { NUM = FALSE }
    if(missing(COL)) { COL = FALSE }
    if(missing(WIN)) { WIN = NULL }
      if(missing(PLOT)) { PLOT = TRUE }
    if(missing(SEL)) { SEL = 1:length(cmp$lon) }
  
  DX = range(unlist(cmp$lon))
  DY = range( unlist(cmp$lat))
  if(!is.null(pts))
    {
      PX = range(unlist(pts$lon))
      PY = range( unlist(pts$lat))
    }
  
  #  Y-direction km
  #  D1 = GreatDist(DX[1],DY[1], DX[1],  DY[2])
  #  X-direction km
  #  D2 = GreatDist(DX[1],DY[1], DX[2],  DY[1])

  #  Y-direction km
  # D1 = GreatDist(DX[1],DY[1], DX[1],  DY[1]+1)
  #  X-direction km
  # D2 = GreatDist(DX[1],DY[1], DX[1]+1,  DY[1])
  

  if(ADD==FALSE)
    {
      if( is.null(WIN) )
        {
          PKM = gclc( LAT , LON ,  c(unlist(cmp$lat), pts$lat), c(unlist(cmp$lon), pts$lon)  )
        }
      else
        {
          PKM = gclc( LAT , LON , WIN$lat,  WIN$lon) 
        }
      EX = PKM$y
      WHY = PKM$x
      if(ASP==TRUE)
        {
          dasp = 1
          ##  plot(EX, WHY, type='n', asp=dasp, ylab="North, km", xlab="East, km")
          ## plot(EX, WHY, type='n', asp=dasp, ann=FALSE, axes=FALSE)
        }
      else
        {
          dasp = NA
        }
      
      plot(EX, WHY, type='n', asp=dasp, ann=FALSE, axes=FALSE)
      if(PLOT==FALSE) { return  }
    }
  
  
  for(i in SEL)
    {
      PKM = gclc( LAT , LON ,  unlist(cmp$lat[i]), unlist(cmp$lon[i])  )
      EX = PKM$y
      WHY = PKM$x
      mcol = 1
      if(COL==TRUE)
        {
          mcol = i
        }
      if(cmp$kind[i] == 1)
        {
          points(EX, WHY, col=mcol)
        }
      if(cmp$kind[i] == 2)
        {
          lines(EX, WHY, col=mcol)
        }
      if(cmp$kind[i] == 3)
        {
          polygon(EX, WHY, col=gray(.95))
        }
      if(NUM==TRUE)
        {
          text(EX[1], WHY[1], labels=paste(sep=':', i, cmp$name[i]))
        }
    }
  if(!is.null(pts))
    {
      PKM = gclc( LAT , LON , pts$lat, pts$lon )
      EX = PKM$y
      WHY = PKM$x
      points(EX, WHY, pch=6, cex=1.2)
      text(EX, WHY, labels=pts$name, cex=1.2, pos=4)
      
    }
}
#################################################################
##   source("/home/lees/Progs/R_stuff/MAP.R")
projtype<-function()
  {
    print("Projection Types")
    print("0 = None")
    print("1 = merc.sphr")
    print("2 = utm.sphr")
    print("3 = lambert.cc")
    print("")    
    print(paste(sep=" ", "Current:", PROJ.DATA$type))



  }
#################################################################
##   source("/home/lees/Progs/R_stuff/MAP.R")
#####################
setPROJ<-function(type=1, LAT0=LAT, LON0=LON ,LAT1=LAT,  LAT2=LAT,LATS=NULL, LONS=NULL, DLAT=NULL, DLON=NULL,FE=0,FN=0)
  {
    if(missing(type)) { type = 1 }
    if(missing(LAT0)) { LAT0 = 0 }
    if(missing(LON0)) { LON0 = 0 }
    if(missing(LAT1)) { LAT1 = 0 }
    if(missing(LAT2)) { LAT2 = 0 }

    if(missing(DLAT)) { DLAT = 1 }
    if(missing(DLON)) { DLON = 1 }
    
    if(missing(LATS)) { LATS =  list(S=LAT0-DLAT, N=LAT0+DLAT) }
    if(missing(LONS)) { LONS =  list(E=LON0-DLON, W=LON0+DLON) }
      if(missing(FE)) { FE=0}	
  if(missing(FN)) { FN=0}	
    
    LON0=fmod(LON0, 360)
    
    MAPconstants()
    PROJ.DATA<<-list(type=type, LAT0=LAT0, LON0=LON0,LAT1=LAT1, LAT2=LAT2,
			LATS=LATS, LONS=LONS, DLAT=DLAT, DLON=DLON, FE=FE,FN=FN)
    
  }
#####################
GLOB.XY<-function(LAT, LON)
  {


    if(PROJ.DATA$type==0)
      {
        XY = list(x=LON, y=LAT)
      } 
    if(PROJ.DATA$type==1)
      {
        XY = merc.sphr.xy(PROJ.DATA$LON0 , LAT, LON)
      }
    if(PROJ.DATA$type==2)
      {
        XY = utm.sphr.xy( LAT, LON)
      }
    if(PROJ.DATA$type==3)
      {
        XY = lambert.cc.xy( LAT, LON)
      }

    return(XY)

  }
#############
XY.GLOB<-function(x, y)
  {

    if(PROJ.DATA$type==0)
      {
        
        LL = list(lon=x , lat=y)
        
      }
    if(PROJ.DATA$type==1)
      {
        LL = merc.sphr.ll(PROJ.DATA$LON0 , x , y)
      }
    if(PROJ.DATA$type==2)
      {
        LL = utm.sphr.ll( x , y)
      }
    if(PROJ.DATA$type==3)
      {
        LL = lambert.cc.ll( x , y)
      }

    return(LL)

  }
#############
#################################################################
##   source("/home/lees/Progs/R_stuff/MAP.R")

InRect<-function(x, y, X1, Y1, X2, Y2)
  {
    V = x>X1&x<X2&y>Y1&y<Y2
    return(V)
  }
###
SELmap<-function(cmp,WIN=NULL)
  {
    if(missing(WIN)) { WIN = NULL }
    sel = rep(0,length(cmp$lat))
    KNUM =  1:length(cmp$lat)
    
  for(i in KNUM)
    {

      
      y =  unlist(cmp$lat[i])
      x =  unlist(cmp$lon[i])
      V = InRect(x,y,WIN$x[1], WIN$y[1], WIN$x[2], WIN$y[2])
      if(length(x[V])>=1)
        {
          sel[i] = 1
        }
      
     
      
    }


    return(KNUM[sel==1])
    
  }
#################################################################
##   source("/home/lees/Progs/R_stuff/MAP.R")
#######
PROJmap<-function(cmp, pts=NULL, ADD=TRUE, WIN=NULL, ASP=TRUE, NUM=FALSE,
                  COL=FALSE, SEL=NULL, PLOT=TRUE, dcol=1)
{
#  plot a map created from a lees map (see above)
  ##  the WIN list must have a lat-lon designation
  if(missing(ASP)) { ASP = FALSE }
  if(missing(ADD)) { ADD = TRUE }
  if(missing(pts)) { pts = NULL }
  if(missing(NUM)) { NUM = FALSE }
  if(missing(COL)) { COL = FALSE }
  if(missing(WIN)) { WIN = NULL }
  if(missing(PLOT)) { PLOT = TRUE }
  if(missing(SEL)) { SEL = 1:length(cmp$lon) }
  
  if(missing(dcol)) { dcol = 1 }

  
  DX = range(unlist(cmp$lon))
  DY = range( unlist(cmp$lat))
  if(!is.null(pts))
    {
      PX = range(unlist(pts$lon))
      PY = range( unlist(pts$lat))
    }


  if(ADD==FALSE)
    {
      if( is.null(WIN) )
        {
          PKM = GLOB.XY(c(unlist(cmp$lat), pts$lat), c(unlist(cmp$lon), pts$lon)  )
        }
      else
        {
          if( is.null(WIN$lat)==TRUE) { WIN$lat = WIN$y }
          if( is.null(WIN$lon)==TRUE) { WIN$lon = WIN$x }
             
          PKM = GLOB.XY( WIN$lat,  WIN$lon) 
        }
      
      EX = PKM$x
      WHY = PKM$y
      
      if(ASP==TRUE)
        {
          dasp = 1
          ##  plot(EX, WHY, type='n', asp=dasp, ylab="North, km", xlab="East, km")
          ## plot(EX, WHY, type='n', asp=dasp, ann=FALSE, axes=FALSE)
        }
      else
        {
          dasp = NA
        }
      
      plot(EX, WHY, type='n', asp=dasp, ann=FALSE, axes=FALSE)

    }
  
  if(PLOT==FALSE)
    {
      ###   print("PLOT==FALSE:  NOT PLOTTING LINES AND POINTS");
      return(0)
    }
  
  for(i in SEL)
    {
      PKM = GLOB.XY(   unlist(cmp$lat[i]), unlist(cmp$lon[i])  )
      EX = PKM$x
      WHY = PKM$y
      mcol = dcol
      if(COL==TRUE)
        {
          mcol = cmp$col[i]
        }
      if(cmp$kind[i] == 1)
        {
          points(EX, WHY, col=mcol)
        }
      if(cmp$kind[i] == 2)
        {
          lines(EX, WHY, col=mcol)
        }
      if(cmp$kind[i] == 3)
        {
          polygon(EX, WHY, col=gray(.95))
        }
      if(NUM==TRUE)
        {
          text(EX[1], WHY[1], labels=paste(sep=':', i, cmp$name[i]))
        }
    }
  
  if(!is.null(pts))
    {
      PKM = GLOB.XY( pts$lat, pts$lon )
      EX = PKM$x
      WHY = PKM$y
      points(EX, WHY, pch=6, cex=1.2)
      text(EX, WHY, labels=pts$name, cex=1.2, pos=4)
      
    }
}
#################################################################
###
##   source("/home/lees/Progs/R_stuff/MAP.R")


PROJAXESmap<-function(GRID=FALSE, WIN=NULL, ...)
{
  
  if(missing(GRID)) { grid=FALSE }
  if(missing(WIN)) {  WIN=NULL }

  u = par('usr')
  

  GG = XY.GLOB(c(u[1], u[2]), c(u[3], u[4]))

  
  
  if( is.null(WIN) )
    {
      rnglon = range(GG$lon)
      rnglon = fmod(rnglon, 360.);
      
      lats = pretty(range(GG$lat))
      lons = pretty(rnglon)
      
      
      LAT = min(lats)
      LON = min(lons)
  
    }
  else
    {
      rnglon = range(WIN$lon)

      
      rnglon = fmod(rnglon, 360.);
      
      lats = pretty(range(WIN$lat))
      lons = pretty(rnglon)
      
      LAT = min(WIN$lat)
      LON = min(WIN$lon)
      


    }

  lenlon = length(lons)
  lenlat = length(lats)
  
  PKM = GLOB.XY( rep(LAT,length(lons)) ,lons )
  
  axis(1,at=PKM$x, labels=lons, ...)
  
  if(GRID==TRUE)
    {
      for( k in lons)
        {
          D = GLOB.XY( lats ,rep(k, length=lenlat)  )
          lines(D$x, D$y, lty=2, col=grey(0.8))
        }
      #   abline( v=PKM$x, lty=2, col=grey(0.8))
      
    }
  
  
  PKM = GLOB.XY( lats,  rep(LON,length(lats)) )
  axis(2,at=PKM$y, labels=lats, ...)
  
  if(GRID==TRUE)
    {
      for( k in lats)
        {
          D = GLOB.XY( rep(k, length=lenlon) , lons  )
          lines(D$x, D$y, lty=2, col=grey(0.8))
        }
      ## abline(h=PKM$y, lty=2, col=grey(0.8) )
      
    }
  invisible(list(LATS=lats, LONS=lons))
  
}
#####################
##   source("/home/lees/Progs/R_stuff/MAP.R")

PROJpoints<-function(lat, lon, COL=1, PCH=6, LAB=NULL)
  {
    if(missing(LAB)) { LAB=NULL }
    if(missing(COL)) { COL=1 }
    if(missing(PCH)) { PCH=6 }
       
    XY = GLOB.XY(lat, lon)
    points(XY$x, XY$y, pch=PCH, col=COL)
    if(!is.null(LAB) )
      text(XY$x, XY$y, LAB, pos=4, col=COL)
  }
##   source("/home/lees/Progs/R_stuff/MAP.R")
#####################
PROJbox<-function(box, COL=1)
  {
    if(missing(COL)) { COL=1 }
    XY = GLOB.XY(box$lat, box$lon)
    rect(XY$x[1], XY$y[1], XY$x[2], XY$y[2], border=COL)
  }

##   source("/home/lees/Progs/R_stuff/MAP.R")

#####################
SUBmap<-function(cmp, tbox, pts=null)
{

  
  DX = range(unlist(cmp$lon))
  DY = range( unlist(cmp$lat))
  
  BX = c(DX[1]-(DX[2]-DX[1])/20, DX[2]+(DX[2]-DX[1])/20)
  BY = c(DY[1]-(DY[2]-DY[1])/20, DY[2]+(DY[2]-DY[1])/20)


  X = range(tbox$x)
  Y =  range(tbox$y)

 polygon(c(X[1], X[2], X[2], X[1]), c(Y[1], Y[1], Y[2], Y[2])     , col=gray(1))


  # plot(unlist(cmp$lon), unlist(cmp$lat), asp=ASPRAT, xlab="Lon", ylab="Lat", xlim=cmp$ZM$x, ylim=cmp$ZM$y, type="n")
  
  for(i in 1:length(cmp$lon))
    {
      x = RESCALE(unlist(cmp$lon[i]),X[1], X[2], BX[1], BX[2])
      y = RESCALE(unlist(cmp$lat[i]),Y[1], Y[2], BY[1], BY[2])
 
      if(cmp$kind[i] == 1)
        {
          points(x,y)
        }
      if(cmp$kind[i] == 2)
        {
         
          lines(x,y)
        }
      if(cmp$kind[i] == 3)
        {
          polygon(x,y, col=gray(.95))
        }
    }
  if(!missing(pts))
  {
    x = RESCALE(pts$lon,X[1], X[2], BX[1], BX[2])
    y = RESCALE(pts$lat,Y[1], Y[2], BY[1], BY[2])
    points(x, y)
    text(x,y,pts$name, pos=4)
    
  }

}

#######################################################
#######################################################
#######################################################

##   source("/home/lees/Progs/R_stuff/MAP.R")
#####################
##  phi = lat ; lam=lon
merc.sphr.xy<-function(LON0, phi, lam)
  {

    
    theta = (fmod(lam, 360)  - LON0);
    
    ####  theta = fmod(theta, 360) 
    x = DEG2RAD * R.MAPK * theta;
    y = R.MAPK * log(tan(DEG2RAD * (45 + phi / 2)));
    return(list(x=x, y=y))
  }

merc.sphr.ll<-function(LON0, x, y)
  {
    phi = 90 - RAD2DEG * 2 * atan(exp(-y / R.MAPK));
    lam = RAD2DEG * (x / R.MAPK) + LON0;
    return(list(lat=phi, lon=lam))
  }
################

utm.sphr.xy<-function(  phi,  lam)
  {
   
    
    k0 = 1.0;
    theta = (lam - PROJ.DATA$LON0)
    
    B = cos(DEG2RAD *phi) * sin(DEG2RAD *theta);
    x = 0.5*R.MAPK*k0*log( (1+B)/(1-B));
    y = R.MAPK * k0* (  atan( tan(DEG2RAD *phi)/cos(DEG2RAD *theta)) - DEG2RAD*PROJ.DATA$LAT0 );
    return(list(x=x, y=y))
  }

utm.sphr.ll<-function( x, y)
  {
    k0 = 1.0;
    R<-	6378.2064
   
    D = y/(R.MAPK*k0) + DEG2RAD *PROJ.DATA$LAT0;
    a1 = RAD2DEG *asin( sin(D)/cosh(x/(R.MAPK*k0)) );
    a2 = RAD2DEG * atan( sinh(x/(R.MAPK*k0))/cos(D)) + PROJ.DATA$LON0;
    
    phi = a1;
    lam = a2;
    
    return(list(lat=a1, lon=a2))
  }

###############################################
##  Lambert Conformal Conic Projection
#
# phi1 = First standard parallel
# phi2 = Second standard parallel
# phi0 = Central meridian
# lam0 = Lat of projection origin
# FE   = False easting
# FN   = False northing

lambert.cc.xy<-function(phi,lam)
  {
	###  lambert conformal conic Snyder(USGS) p. 104

lam = fmod(lam, 360)	

 
    phi0 = PROJ.DATA$LAT0
    lam0 = PROJ.DATA$LON0
    phi1 = PROJ.DATA$LAT1
    phi2 = PROJ.DATA$LAT2
	FE = PROJ.DATA$FE
	FN = PROJ.DATA$FN

##  print(paste(sep=' ', phi,lam, phi0, lam0,  phi1,  phi2, FE, FN))

#  Constants:
phi =phi*pi/180
lam =lam*pi/180
phi1=phi1*pi/180 
phi2=phi2*pi/180 
phi0=phi0*pi/180
lam0=lam0*pi/180
R = A.MAPK

n=log(cos(phi1)/cos(phi2))/log(tan(pi/4+phi2/2)/tan(pi/4+phi1/2))  #15-3
F=cos(phi1)*(tan(pi/4+phi1/2))^n/n                                 #15-2
rho0=R*F/(tan(pi/4+phi0/2))^n                                      #15-1a

## print(paste(sep=' ',R, n, F, rho0))


rho = R*F/((tan(pi/4+phi/2))^n)                                    #15-1
theta = n*(lam-lam0)                                               #14-4
x = rho*sin(theta)+FE                                              #14-1
y = rho0-rho*cos(theta)+FN                                         #14-2
##  print(paste(sep=' ',rho, theta, x, y))

    return(list(x=x, y=y))
  }

lambert.cc.ll<-function(x,y)
  {
###  lambert conformal conic Snyder(USGS) p. 104

    phi0 = PROJ.DATA$LAT0
    lam0 = PROJ.DATA$LON0
    phi1 = PROJ.DATA$LAT1
    phi2 = PROJ.DATA$LAT2
	FE = PROJ.DATA$FE
	FN = PROJ.DATA$FN
 
#  Constants:
phi1=phi1*pi/180 
phi2=phi2*pi/180 
phi0=phi0*pi/180
lam0=lam0*pi/180
R = A.MAPK

x=x-FE
y=y-FN

n=log(cos(phi1)/cos(phi2))/log(tan(pi/4+phi2/2)/tan(pi/4+phi1/2))  #15-3
## print(paste(sep=' ', "n=", n))
F=cos(phi1)*(tan(pi/4+phi1/2))^n/n                                 #15-2
## print(paste(sep=' ', "F=", F))

rho0=R*F/(tan(pi/4+phi0/2))^n                                      #15-1a
##print(paste(sep=' ', "rho0=", rho0))

#  Calc rho,theta, phi, and lambda

rho=sign(n)*(x^2+(rho0-y)^2)^(1/2)                                 #14-10
## print(paste(sep=' ', "rho=", rho))


theta=atan(x/(rho0-y))                                             #14-11
## print(paste(sep=' ', "theta=", theta))

lam=theta/n+lam0                                                   #14-9
phi=2*atan((R*F/rho)^(1/n))-pi/2                                   #15-5

lon=(lam)*180/pi
lat=(phi)*180/pi
    
    return(list(lat=lat, lon=lon))
  }
###############################################
##  Lambert Azimuthal Equal Area Projection
#
# phi1 = First standard parallel
# phi2 = Second standard parallel
# phi0 = Central meridian
# lam0 = Lat of projection origin
# FE   = False easting
# FN   = False northing

lambert.ea.xy<-function(phi,lam)
  {
	###  lambert azimuthal equal area Snyder(USGS) p. 185

lam = fmod(lam, 360)	

 
    phi0 = PROJ.DATA$LAT0
    lam0 = PROJ.DATA$LON0
    phi1 = PROJ.DATA$LAT1
    phi2 = PROJ.DATA$LAT2
	FE = PROJ.DATA$FE
	FN = PROJ.DATA$FN

##  print(paste(sep=' ', phi,lam, phi0, lam0,  phi1,  phi2, FE, FN))

#  Constants:
phi =phi*pi/180
lam =lam*pi/180
phi1=phi1*pi/180 
phi2=phi2*pi/180 
phi0=phi0*pi/180
lam0=lam0*pi/180
R = A.MAPK


## print(paste(sep=' ',R, n, F, rho0))


rho = 2*R*sin(c/2)                       # 24-1
theta = pi-Az                            # 20-2
hp = cos(c/2)                            # 24-1a
##  kp = sec(c/2)                            # 24-1b


kp = sqrt(2/(1 + sin(phi1)*sin(phi)+cos(phi1)*cos(phi)*cos(lam-lam0)))  ## 22-2

x = R*kp*cos(phi)*sin(lam-lam0) +FE         #22-4



y = R*kp*(cos(phi1)*sin(phi)-sin(phi1)*cos(phi)*cos(lam-lam0))  + FN ## 22-5
##  print(paste(sep=' ',rho, theta, x, y))

    return(list(x=x, y=y))
  }

lambert.ea.ll<-function(x,y)
  {
###  lambert conformal conic Snyder(USGS) p. 104

    phi0 = PROJ.DATA$LAT0
    lam0 = PROJ.DATA$LON0
    phi1 = PROJ.DATA$LAT1
    phi2 = PROJ.DATA$LAT2
	FE = PROJ.DATA$FE
	FN = PROJ.DATA$FN
 
#  Constants:
phi1=phi1*pi/180 
phi2=phi2*pi/180 
phi0=phi0*pi/180
lam0=lam0*pi/180
R = A.MAPK

x=x-FE
y=y-FN

n=log(cos(phi1)/cos(phi2))/log(tan(pi/4+phi2/2)/tan(pi/4+phi1/2))  #15-3
## print(paste(sep=' ', "n=", n))
F=cos(phi1)*(tan(pi/4+phi1/2))^n/n                                 #15-2
## print(paste(sep=' ', "F=", F))

rho0=R*F/(tan(pi/4+phi0/2))^n                                      #15-1a
##print(paste(sep=' ', "rho0=", rho0))

#  Calc rho,theta, phi, and lambda

rho=sign(n)*(x^2+(rho0-y)^2)^(1/2)                                 #14-10
## print(paste(sep=' ', "rho=", rho))


theta=atan(x/(rho0-y))                                             #14-11
## print(paste(sep=' ', "theta=", theta))

lam=theta/n+lam0                                                   #14-9
phi=2*atan((R*F/rho)^(1/n))-pi/2                                   #15-5

lon=(lam)*180/pi
lat=(phi)*180/pi
    
    return(list(lat=lat, lon=lon))
  }
