##
##
##
##  cd /home/lees/Site/NAndes
##  cd RMAP
##
## leesmap2splus.prl < ../Ecuador/carn_ridge.lees
########## leesmap2splus.prl < ../Ecuador/coast.lees
## leesmap2splus.prl < ../Ecuador/shore.lees
## leesmap2splus.prl < ../Ecuador/border.lees


##  NAmap = setGenmap("/home/lees/Site/NAndes/RMAP")

##   DETmap = setGenmap("/home/lees/Site/NAndes/Ecuador/RMAP")
##  cd /home/lees/Site/NAndes/Ecuador/RMAP/RIV
## leesmap2splus.prl < ../../river.lees
## cd ../STATE
## leesmap2splus.prl < ../../state.lees

#### ## ##  stbdrs  = grep("STAT", DETmap$name)
## ## ## ## rivbdrs = grep("RIV", DETmap$name)

RIVmap = setGenmap("/home/lees/Site/NAndes/Ecuador/RMAP/RIV")
STATmap = setGenmap("/home/lees/Site/NAndes/Ecuador/RMAP/STATE")
BRDmap = setGenmap("/home/lees/Site/NAndes/Ecuador/RMAP/BOARD")

RIVmap$col=rep(XMCOL[22], length(RIVmap$kind))
STATmap$col=rep(XMCOL[19], length(STATmap$kind))
BRDmap$col=rep(XMCOL[25], length(BRDmap$kind))

ACTIVSTA = scan(file="/home/lees/Site/NAndes/stalist.2", list(name='',
  lat1=0, lat2=0, latns='', lon1=0, lon2=0, lonew='', z=0))

ACTIVSTA$LAT = ACTIVSTA$lat1+ACTIVSTA$lat2/60
ACTIVSTA$LON = ACTIVSTA$lon1+ACTIVSTA$lon2/60

ACTIVSTA$LAT[ACTIVSTA$latns=='s'] = -ACTIVSTA$LAT[ACTIVSTA$latns=='s']
ACTIVSTA$LON[ACTIVSTA$lonew=='w'] = -ACTIVSTA$LON[ACTIVSTA$lonew=='w']

ACTIVSTA$LOC =  GLOB.XY(ACTIVSTA$LAT, ACTIVSTA$LON)

ACTIVSTA$x = ACTIVSTA$LOC$x
ACTIVSTA$y = ACTIVSTA$LOC$y

NANMAP(PLOT=FALSE, WIN=ECzoom)
 PROJmap(NAmap, ADD=TRUE,  WIN=ECzoom, ASP=TRUE, COL=TRUE)
 points(ACTIVSTA$x, ACTIVSTA$y, pch=25, cex=1.5, col=XMCOL[53])
 points(mariosta$XY$x, mariosta$XY$y, pch=6, col=XMCOL[22])
 text(mariosta$XY$x, mariosta$XY$y, labels=mariosta$name , col=XMCOL[22], pos=3)
    
 text(ACTIVSTA$x, ACTIVSTA$y, labels=ACTIVSTA$name, col=XMCOL[53], pos=1)


  points(volcs$x, volcs$y, pch=17, cex=0.8, col=2)

  ### text(volcs$x, volcs$y, labels=ALLVOL$name[sub], col=2, pos=4)

alandsta = list(x=c(ACTIVSTA$x, SS1$x, SS$x), y=c(ACTIVSTA$y, SS1$y, SS$y) )

volcreg = locator(type='l' )



kin = inpoly(alandsta$x, alandsta$y , volcreg)
points(alandsta$x[kin==1], alandsta$y[kin==1], col=XMCOL[56])


kdist = dist(cbind(alandsta$x[kin==1], alandsta$y[kin==1]), method = "euclidean", diag = FALSE, upper = FALSE)
kdist = as.matrix(kdist)
diag(kdist) = 10000
median(apply(kdist , 2 , min))
  
PROJmap(STATmap, ADD=TRUE,  WIN=ECzoom, ASP=TRUE, COL=TRUE)
PROJmap(RIVmap, ADD=TRUE,  WIN=ECzoom, ASP=TRUE, COL=TRUE)

PROJmap(BRDmap, ADD=TRUE,  WIN=ECzoom, ASP=TRUE, COL=TRUE)

########################################################
source("/home/lees/Progs/R_stuff/xmcolor.R")
setXMCOL()

slabcont<-function(x,y,z, levs=25,  POL=POL)
{
  if(missing(POL)) {  POL=NULL }
    if(missing(levs)) {  levs=15 }

  JSUR = data.frame(cbind(x=x, y=y,  z=z))
  JSUR.kr <- surf.gls(3, expcov, JSUR, d=200)
  prsurf <- prmat(JSUR.kr,   min(JSUR$x), max(JSUR$x), min(JSUR$y), max(JSUR$y) , 100)
  if(!is.null(POL))
    {
      d =  dim(prsurf$z)
      
      INZ = matrix(ncol=d[1], nrow=d[2])
      xpo = matrix(rep(prsurf$x,length(prsurf$y)), ncol=length(prsurf$x),  nrow = length(prsurf$y))

      ypo = matrix(rep(prsurf$y,length(prsurf$x)), ncol=length(prsurf$x),  nrow = length(prsurf$y))
      
      for(i in 1:d[1])
        {
          x = xpo[,i]
          y = ypo[i,]
          INZ[,i] = inpoly(x, y, POL)
        }

      prsurf$z[INZ==0] = NA
    }
  dlev = pretty(range(c(min(JSUR$z),max(JSUR$z))), n=levs)

  contour(prsurf, levels=dlev, add=TRUE)

  return(list(JSUR=JSUR, prsurf=prsurf, levs=levs, dlev =dlev, POL=POL))


}

########################################################
#######################################
NANMAP <-function(PLOT=TRUE, WIN=GL)
  {
    if(missing(PLOT)) { PLOT = TRUE }
    if(missing(WIN)) { WIN=GL  }
    
    PROJmap(NAmap, ADD=FALSE,  WIN=WIN, ASP=TRUE, COL=TRUE, PLOT=PLOT)
    AXESmap(NAmap, GRID=TRUE,  WIN=WIN)
    box()
  }
#######################################


##  START:
NAmap = setGenmap("/home/lees/Site/NAndes/RMAP")
GENmap(NAmap)
MLOC = locator(2)
rect(MLOC$x[1], MLOC$y[1],MLOC$x[2],MLOC$y[2])
OLOC = locator(1)

NAmap$col[NAmap$col==5] = grey(0.5)
NAmap$col[NAmap$col==16] = "black"

##########  setPROJ(type=1, LAT0=NAmap$SLAT$mean, LON0=NAmap$SLON$mean )

setPROJ(type=1, LAT0=OLOC$y, LON0=OLOC$x ,
        LATS=list(S=min(MLOC$y), N=max(MLOC$y)),
        LONS=list(E=max(MLOC$x), W=min(MLOC$x) ),
        DLAT=abs(MLOC$y[2]-MLOC$y[1]),
        DLON=abs(MLOC$x[2]-MLOC$x[1]) )

PROJ.DATA

  
bot.surf = scan(file="bot_surf_pnts.gmt", list(lon=0, lat=0, z=0))

write(t(cbind(fmod(bot.surf$lon, 360), bot.surf$lat, bot.surf$z)), file="bot_surf_pnts.gmt2", ncolumns=3 )


DUPS = duplicated(bot.surf$lat)&duplicated(bot.surf$lon)
BOT = GLOB.XY(bot.surf$lat[!DUPS], bot.surf$lon[!DUPS] )
BOT$z = bot.surf$z[!DUPS]


CH = chull(BOT$x, BOT$y)
CHC = list(x=c(BOT$x[CH], BOT$x[CH[1]]) , y=c(BOT$y[CH], BOT$y[CH[1]]))

####  determine window
PROJmap(NAmap,  WIN=NULL , ADD=FALSE, ASP=TRUE)
AXESmap(NAmap, GRID=TRUE)

L = locator(2)

GL1 = XY.GLOB(L$x, L$y)


L = locator(2)
GL2 = XY.GLOB(L$x, L$y)

GL = GL1 
#  GL = GL2

NANMAP()

ALLVOL = scan(file="/home/lees/Site/World/v.out", list(name="", lat=0, lon=0, z=0, kat=0,du="", t=0))

POL = list(y=bot.surf$lat[CH], x=fmod(bot.surf$lon[CH], 360) )

pic = inpoly(fmod(ALLVOL$lon, 360) , ALLVOL$lat, POL)

sub = pic==1
volcs = GLOB.XY( ALLVOL$lat[sub], ALLVOL$lon[sub] )


points(volcs$x, volcs$y, pch=2, col=2)


engdahl = setEQSLLZM("/home/lees/Site/engdahl.LLZM", list(lat=NAmap$GLAT, lon=NAmap$GLON) )

NAeqs = setEQSLLZM("/home/lees/Site/NAndes/Ecuador/all_98_99.LLZM", list(lat=NAmap$GLAT, lon=NAmap$GLON) )


epts = GLOB.XY(engdahl$lat,fmod(engdahl$lon, 360) )
pts = GLOB.XY(NAeqs$lat, fmod(NAeqs$lon, 360) )


SCONT = slabcont(BOT$x  , BOT$y  , BOT$z,levs=25,  POL=list(x=c(BOT$x[CH], BOT$x[CH[1]]), y=c(BOT$y[CH], BOT$y[CH[1]])) )

points(BOT$x  , BOT$y, pch=3)


NSLAB.XY = GLOB.XY(NSLAB$lat, NSLAB$lon)

points(NSLAB.XY$x, NSLAB.XY$y, pch = 5)

NSLAB = list(lat=nslab$lat, lon=nslab$lon, z=nslab$z)

chnslab  = chull(NSLAB.XY$x, NSLAB.XY$y)
lines(NSLAB.XY$x[chnslab], NSLAB.XY$y[chnslab])
nslabpol = list(x=NSLAB.XY$x[chnslab], y=NSLAB.XY$y[chnslab])

NANMAP(PLOT=TRUE, WIN=ECzoom)
#######
kpol = inpoly(BOT$x, BOT$y , nslabpol )

NBOT = list(x=c(BOT$x[kpol==0], NSLAB.XY$x), y=c(BOT$y[kpol==0], NSLAB.XY$y), z=c( BOT$z[kpol==0], NSLAB$z ) )


chnbot  = chull(NBOT$x, NBOT$y)


NCONT = slabcont(NBOT$x  , NBOT$y  , NBOT$z, levs=25,  POL=list(x=c(NBOT$x[chnbot]), y=c(NBOT$x[chnbot])) )
NCONT = slabcont(NBOT$x  , NBOT$y  , NBOT$z, levs=25, POL=POLCONT)

BSLAB = list(lon=c(BOT$lon[kpol==0], NSLAB$lon), lat=c(BOT$lat[kpol==0], NSLAB$lat), z=c(NBOT$z))


write(t(cbind(fmod(BSLAB$lon, 360), BSLAB$lat , NBOT$z )), file="bot_surf_pnts3.gmt", ncolumns=3 )

plot(fmod(BSLAB$lon, 360), BSLAB$lat, type='p')




###
NANMAP(PLOT=FALSE)


image(NCONT$prsurf, col = rainbow(100), add=FALSE, asp=1)

contour(NCONT$prsurf, levels=dlev, add=TRUE)

PROJmap(NAmap, ADD=TRUE,  WIN=ECzoom, ASP=TRUE, COL=TRUE)

points(NBOT$x, NBOT$y)

lines(POLCONT$x, POLCONT$y)


###

postscript(file ="NANDEScont3.ps" ,  horizontal=FALSE, onefile=FALSE, print.it=FALSE)
nkmsc = locator()


NANMAP(PLOT=FALSE, WIN=CONTzoom$LL)
image(NCONT$prsurf, col = rainbow(100), add=TRUE)
PROJmap(NAmap, ADD=TRUE,  WIN=CONTzoom$LL, ASP=TRUE, COL=FALSE, dcol=XMCOL[60])
contour(NCONT$prsurf, levels=dlev, add=TRUE)
title(main="Seismicity Horizon in Northern Andes Subduction Zone", xlab="Lon", ylab="Lat")
KMscale(nkmsc, len=500)
box()

segments(xsecs$XY1$x[c(1,3,6)], xsecs$XY1$y[c(1,3,6)], xsecs$XY2$x[c(1,3,6)], xsecs$XY2$y[c(1,3,6)], lwd=2)
text(xsecs$XY1$x[c(1,3,6)], xsecs$XY1$y[c(1,3,6)], labels=xslabs[c(1,3,6)], pos=3, cex=1.5)



dev.off()

xsecs=scan(file="/home/lees/Site/NAndes/Ecuador/SAVE_xsecs", list(lat1=0, lon1=0,  lat2=0, lon2=0, a1=0, a2=0, dep=0, front=0, back=0))

xsecs$XY1 = GLOB.XY(xsecs$lat1, xsecs$lon1)
xsecs$XY2 = GLOB.XY(xsecs$lat2, xsecs$lon2)
xslabs = 1:6

segments(xsecs$XY1$x[c(1,3,6)], xsecs$XY1$y[c(1,3,6)], xsecs$XY2$x[c(1,3,6)], xsecs$XY2$y[c(1,3,6)], lwd=2)
text(xsecs$XY1$x[c(1,3,6)], xsecs$XY1$y[c(1,3,6)], labels=xslabs[c(1,3,6)], pos=3, cex=1.2)



CONTzoom = locator()
CONTzoom$LL = XY.GLOB(CONTzoom$x, CONTzoom$y)

Ky = NCONT$prsurf$y[NCONT$prsurf$y>=CONTzoom$y[1] & NCONT$prsurf$y<=CONTzoom$y[2]]
Kx = NCONT$prsurf$x[NCONT$prsurf$x>=CONTzoom$x[1] & NCONT$prsurf$x<=CONTzoom$x[2]]

Kz = NCONT$prsurf$z[ NCONT$prsurf$x>=CONTzoom$x[1] & NCONT$prsurf$x<=CONTzoom$x[2],    NCONT$prsurf$y>=CONTzoom$y[1] & NCONT$prsurf$y<=CONTzoom$y[2] ]

NANMAP(PLOT=FALSE, WIN=CONTzoom$LL)
image(Kx, Ky,Kz , col = rainbow(100), add=TRUE)
PROJmap(NAmap, ADD=TRUE,  WIN=CONTzoom$LL, ASP=TRUE, COL=TRUE)
contour(NCONT$prsurf, levels=dlev, add=TRUE)



###   filled.contour(NCONT$prsurf, levels=dlev, add=TRUE)

#######################################################################################
#######################################################################################
#######################################################################################

##  
###    this sets PROJ.DATA



##   source("/home/lees/Progs/R_stuff/MAP.R")


FL = "/home/lees/Site/engdahl.LLZM"

engdahl = setEQSLLZM("/home/lees/Site/engdahl.LLZM", list(lat=NAmap$GLAT, lon=NAmap$GLON) )


NAeqs = scan(file='/home/lees/Site/NAndes/all_98_99.pts_gmt', list(lon=0, lat=0, c=0,v=0, a=0,b=0,d=''))

epts = GLOB.XY(engdahl$lat,engdahl$lon)
points(epts$x, epts$y, pch='.', col=2)
points(epts$x, epts$y, pch=4, cex=0.5, col=2)


pts = GLOB.XY(NAeqs$lat, NAeqs$lon)
points(pts$x, pts$y, pch=8, cex=0.5, col=4)

NAeqs = scan(file='/home/lees/Site/NAndes/all_98_99.pts_gmt', list(lon=0, lat=0, c=0,v=0, a=0,b=0,d=''))


pts = GLOB.XY(NAeqs$lat, NAeqs$lon)
points(pts$x, pts$y, pch=8, col=2)

########################
       z <- -NAeqs$z
       x <- NAeqs$lon
       y <- NAeqs$lat


for( i in seq(from=-135, to=135, by=10))
  {
    m = paste(sep=' ', "NANDES EQs", i)
scatterplot3d(x, y, z, angle=i, highlight.3d=TRUE, col.axis="blue", col.grid="lightblue", main=m, pch=20)
locator()
}

 data(trees)
       s3d <- scatterplot3d(trees, type="h", highlight.3d=TRUE,
           angle=55, scale.y=0.7, pch=16, main="scatterplot3d - 5")
       # Now adding some points to the "scatterplot3d"
       s3d$points3d(seq(10,20,2), seq(85,60,-5), seq(60,10,-10),
           col="blue", type="h", pch=16)
       # Now adding a regression plane to the "scatterplot3d"
       attach(trees)
       my.lm <- lm(Volume ~ Girth + Height)
       s3d$plane3d(my.lm)




########################


bot.surf = scan(file="bot_surf_pnts.gmt", list(lon=0, lat=0, z=0))

#####  check to see if there are duplicated points:
DUPS = duplicated(bot.surf$lat)&duplicated(bot.surf$lon)

BOT = GLOB.XY(bot.surf$lat[!DUPS], bot.surf$lon[!DUPS] )

BOT$z = bot.surf$z[!DUPS]

points(BOT$x, BOT$y, pch=3)


SLAB.bot = data.frame(x=c(BOT$x)  , y=c(BOT$y)  , z=c(BOT$z) )

SLAB.kr <- surf.gls(2, expcov, SLAB.bot, d=200, nx=10000)


prsurf <- prmat(SLAB.kr,   min(SLAB.bot$x), max(SLAB.bot$x), min(SLAB.bot$y), max(SLAB.bot$y) , 100)

trsurf <- trmat(SLAB.kr, min(SLAB.bot$x), max(SLAB.bot$x), min(SLAB.bot$y), max(SLAB.bot$y), 50)

contour(trsurf)

prsurf <- prmat(SLAB.kr,   min(SLAB.bot$x), max(SLAB.bot$x), min(SLAB.bot$y), max(SLAB.bot$y) , 500)

contour(prsurf, add=TRUE, nlevels=25)


CH = chull(BOT$x, BOT$y)

lines(BOT$x[CH], BOT$y[CH], col=2)

points(prsurf$x, prsurf$y, col=3)


SCONT = slabcont(BOT$x  , BOT$y  , BOT$z,levs=25,  POL=list(x=c(BOT$x[CH], BOT$x[CH[1]]), y=c(BOT$y[CH], BOT$y[CH[1]])) )


 dlev = pretty(range(c(max(SCONT$JSUR$z), min(SCONT$JSUR$z))), n=25)

 contour(SCONT$prsurf, levels=dlev, add=TRUE, col=3)


###  FIGURE:
postscript(file ="NANDEScont2.ps" ,  horizontal=FALSE, onefile=FALSE, print.it=FALSE)

par(bg=grey(0.8) )
par(bg="white")

color.pr(color="white")
color.pr(color="white")

NANMAP()

points(epts$x, epts$y, pch=4, cex=0.3, col=XMCOL[15])
points(pts$x, pts$y, pch=8, cex=0.3, col=XMCOL[11])
contour(SCONT$prsurf, levels=SCONT$dlev, add=TRUE, col=XMCOL[23])
points(volcs$x, volcs$y, pch=17, cex=0.8, col=2)
PROJmap(NAmap, ADD=TRUE,  WIN=GL, ASP=TRUE, COL=TRUE)
box()


### OPTIONAL:
### points(BOT$x, BOT$y, pch=18)

dev.off()

###  proposed stations:   points_gmt

mariosta = scan("mario_sta.gmt", list(lon=0, lat=0, col=0, r=0, a=0, b=0, name=""))
jOBS = scan("jOBS.gmt", list(lon=0, lat=0, col=0, r=0, a=0, b=0, name=""))
jsta = scan("jsta.gmt", list(lon=0, lat=0, col=0, r=0, a=0, b=0, name=""))
mariosug = scan("mario_sug.gmt", list(lon=0, lat=0, col=0, r=0, a=0, b=0, name=""))

mariosta$XY = GLOB.XY(mariosta$lat, mariosta$lon)
jOBS$XY = GLOB.XY(jOBS$lat, jOBS$lon)
jsta$XY = GLOB.XY(jsta$lat, jsta$lon)
mariosug$XY = GLOB.XY(mariosug$lat, mariosug$lon)


points(mariosta$XY$x, mariosta$XY$y, pch=6, col=XMCOL[22])

points(jOBS$XY$x, jOBS$XY$y, pch=16, cex=1.5, col=XMCOL[44])
points(jsta$XY$x, jsta$XY$y, pch=16, cex=1.5, col=XMCOL[5])
points(mariosug$XY$x, mariosug$XY$y, pch=16, cex=1.5, col=XMCOL[5])

#######################

ECLL  = locator(2)

ECzoom = XY.GLOB(ECLL$x, ECLL$y)
kmLz = locator(2)

postscript(file ="Ecuador.zoom1.ps" ,  horizontal=FALSE, onefile=FALSE, print.it=FALSE)


donan<-function(WIN=ECzoom)
  {
    if(missing(WIN)) { WIN=ECzoom }
    
    NANMAP(PLOT=FALSE, WIN=WIN)
    image(NNG$x, NNG$y, (ZZimg), col=cmap, asp=1, add=TRUE)
    contour( NNG$x, NNG$y, (ZZimg) , levels=seq(from=-3000, to=-1000, by=500)  ,add=TRUE, col=1)

    points(epts$x, epts$y, pch=4, cex=0.3, col=XMCOL[15])
    points(pts$x, pts$y, pch=8, cex=0.3, col=XMCOL[11])
    contour(NCONT$prsurf, levels=NCONT$dlev, add=TRUE, col=XMCOL[23])
    points(volcs$x, volcs$y, pch=17, cex=0.8, col=2)
    PROJmap(NAmap, ADD=TRUE,  WIN=WIN, ASP=TRUE, COL=TRUE)
    box()
    points(mariosta$XY$x, mariosta$XY$y, pch=6, col=XMCOL[22])
    
    points(jOBS$XY$x, jOBS$XY$y, pch=16, cex=1.5, col=XMCOL[44])
    points(SS1$x, SS1$y, pch=16, cex=1.5, col=XMCOL[5])

  }

### points(jsta$XY$x, jsta$XY$y, pch=16, cex=1.5, col=XMCOL[5])
### points(mariosug$XY$x, mariosug$XY$y, pch=16, cex=1.5, col=XMCOL[5])
### points(mariosug$XY$x, mariosug$XY$y, pch=3, cex=1.5, col=XMCOL[5])

SS1 =  list(x=c(jsta$XY$x,mariosug$XY$x ), y = c(jsta$XY$y, mariosug$XY$y), name=c(jsta$name,mariosug$name ) , lat=c( jsta$lat,  mariosug$lat), lon=c( jsta$lon,  mariosug$lon)  )

plot( c(jOBS$lon, SS1$lon,ACTIVSTA$LON,  mariosta$lon ), c( jOBS$lat, SS1$lat, ACTIVSTA$LAT,mariosta$lat ) ,
       ,type='n')

plot( c( SS1$lon,ACTIVSTA$LON,  mariosta$lon ), c( SS1$lat, ACTIVSTA$LAT,mariosta$lat ) ,
       ,type='n', xlim=c(-81.57169, -72.40080))

LIM=locator(2)

plot( c( SS1$lon,ACTIVSTA$LON,  mariosta$lon ), c( SS1$lat, ACTIVSTA$LAT,mariosta$lat ) ,
       ,type='n', xlim=LIM$x, ylim=LIM$y, asp=1)

##########



points(jOBS$lon, jOBS$lat, pch=16, col= XMCOL[44])
points(SS1$lon, SS1$lat, pch=16, col=XMCOL[5])
points( ACTIVSTA$LON, ACTIVSTA$LAT, pch=17, col=2)
points( mariosta$lon, mariosta$lat, pch=6, col=XMCOL[22] )

points( SS$LL$lon-360, SS$LL$lat, pch=15, col=1 )

GENmap(NAmap, ADD=TRUE, DIR=-1)


leg = c("Active station", "Catalog Stations", "Proposed Land 1", "Proposed Land 2", "Proposed OBS")
legloc=locator()
legend(legloc, legend=leg,  col=c(2, XMCOL[22],XMCOL[5], 1, XMCOL[44]),
       pch=c(17,  6, 16, 15, 16))




text( mariosta$lon[ma], mariosta$lat[ma], labels=mariosta$name[ma], pos=4 )
##########
postscript(file ="NANDES.STA.plots.ps" ,  horizontal=TRUE, onefile=FALSE, print.it=FALSE)

par(mfrow=c(1,2))
plot( c(jOBS$XY$x, SS1$x, ACTIVSTA$x,  mariosta$XY$x ), c( jOBS$XY$y, SS1$y, ACTIVSTA$y, mariosta$XY$y ) ,
       ,type='n', axes=FALSE, ann=FALSE, asp=1)

#  points(jOBS$XY$x, jOBS$XY$y, pch=16, col= XMCOL[44])
#  points(SS1$x, SS1$y, pch=16, col=XMCOL[5])
points( ACTIVSTA$x, ACTIVSTA$y, pch=17, col=2)
points( mariosta$XY$x, mariosta$XY$y, pch=6, col=XMCOL[22] )

#  points( SS$x, SS$y, pch=15, col=1 )

PROJmap(NAmap, ADD=TRUE,  WIN=GL, ASP=TRUE, COL=TRUE)
AXESmap(NAmap, GRID=TRUE,  WIN=GL)
title(xlab="Lon", ylab="Lat", main="Current Station Catalog" )
box()

##########

plot( c(jOBS$XY$x, SS1$x, ACTIVSTA$x,  mariosta$XY$x ), c( jOBS$XY$y, SS1$y, ACTIVSTA$y, mariosta$XY$y ) ,
       ,type='n', axes=FALSE, ann=FALSE, asp=1)

points(jOBS$XY$x, jOBS$XY$y, pch=16, col= XMCOL[44])
points(SS1$x, SS1$y, pch=16, col=XMCOL[5])
points( ACTIVSTA$x, ACTIVSTA$y, pch=17, col=2)
points( mariosta$XY$x, mariosta$XY$y, pch=6, col=XMCOL[22] )

points( SS$x, SS$y, pch=15, col=1 )

PROJmap(NAmap, ADD=TRUE,  WIN=GL, ASP=TRUE, COL=TRUE)
AXESmap(NAmap, GRID=TRUE,  WIN=GL)
title(xlab="Lon", ylab="Lat", main="NASCAR Stations + Catalog Stations")
box()


legend(legloc, legend=leg,  col=c(2, XMCOL[22],XMCOL[5], 1, XMCOL[44]),
       pch=c(17,  6, 16, 15, 16))

dev.off()

##########


ma = match(ACTIVSTA$name, mariosta$name)
points( mariosta$lon[ma], mariosta$lat[ma], pch=17, col=6 )


text(SS1$x, SS1$y, labels=1:length(SS1$x),pos=3, col=XMCOL[5])


donan()

points(SS1$x, SS1$y, pch=16, cex=1.5, col=XMCOL[5])


KMscale(kmLz, len=100)


legLL = locator(2)

leg = c("Active Volc", "Current Stations", "Proposed Land 1", "Proposed Land 2", "Proposed OBS")
legend(legLL$x[1], legLL$y[1], legend=leg,  col=c(2, XMCOL[22],XMCOL[5], 1, XMCOL[44]),
       pch=c(17,  6, 16, 15, 16))




dev.off()


SS = list(x=c(SHIFTsta$x, SHIFTsta2$x ) , y=c(SHIFTsta$y, SHIFTsta2$y))

points(SS$x, SS$y, pch=15, cex=1.5)

text(SS$x, SS$y, labels=1:length(SS$x),pos=3)

ii = identify(SS1$x, SS1$y, n=1)

jident(SS1)

     
IS = jident(SS1)
text(SS1$x[IS], SS1$y[IS], labels=IS,pos=3)

IS = jident(SS1)

##################################################
postscript(file ="Ecuador.sta.shift.ps" ,  horizontal=FALSE, onefile=FALSE, print.it=FALSE)

donan()
points(SS$x, SS$y, pch=15, cex=1.5)
arrows(SS1$x[IS], SS1$y[IS], SS$x, SS$y, length = 0.05, lwd=2, col=grey(0.75) )

KMscale(kmLz, len=100)
legend(legLL$x[1], legLL$y[1], legend=leg,  col=c(2, XMCOL[22],XMCOL[5], 1, XMCOL[44]),
       pch=c(17,  6, 16, 15, 16))
title("NASCAR Land Deployment with 2nd Year Shift")

dev.off()
#######

SS$LL  = XY.GLOB(SS$x, SS$y)
SS$FROM  = XY.GLOB(SS1$x[IS], SS1$y[IS])




write(t(cbind(SS$LL$lon-360, SS$LL$lat)), file="move2.sta", ncolumns=2 )

write( paste(">\n", SS$FROM$lon, SS$FROM$lat, "\n", SS$LL$lon, SS$LL$lat, sep=' '),file="segs2.gmt" ) 






write(t(cbind(SS$FROM$lon, SS$FROM$lat, SS$LL$lon, SS$LL$lat   )), file="move2.sta", ncolumns=2 )


##################################################




###  find typical station spacing:

stadist = dist(cbind( c(SS1$x, SS$x), c(SS1$y, SS$y) ), method = "euclidean", diag = FALSE, upper = FALSE)
adist = as.matrix(stadist)
diag(adist) = 10000
               ####    mean nearest neigbour distance:
land.station.spacing = median(apply(adist , 2 , min))
56.52075

###############

mariodist = dist( cbind(mariosta$XY$x, mariosta$XY$y), method = "euclidean", diag = FALSE, upper = FALSE)
mdist = as.matrix(mariodist)
diag(mdist) = 10000
               ####    mean nearest neigbour distance:
mario.station.spacing = median(apply(mdist , 2 , min))
=9
###############
 
actdist = dist( cbind(ACTIVSTA$x, ACTIVSTA$y), method = "euclidean", diag = FALSE, upper = FALSE)
actdist = as.matrix(actdist)
diag(actdist) = 10000
               ####    mean nearest neigbour distance:
act.station.spacing = median(apply(actdist , 2 , min))
=9


format.default(tstart, digits=5)

write(paste(ACTIVSTA$name, format.default(ACTIVSTA$LAT, digits=5), format.default(ACTIVSTA$LON, digits=5), ACTIVSTA$z/1000 ,sep=' '), file="ACTIVE.sta.LLZ")


temp = SS1$name[IS]
substr(temp, 1,1) = "N"


text(SS1$x[IS], SS1$y[IS], labels=SS1$name[IS], pos=4)

text(SS$x, SS$y, labels=temp, pos=2)


write( paste(temp,   format.default(SS$LL$lat, digits=5),
format.default(SS$LL$lon-360, digits=5), rep(0, length(SS$LL$lon))), file="MOVE2.sta.LLZ")







###############
stadist = dist(cbind( c(SS1$x), c(SS1$y) ), method = "euclidean", diag = FALSE, upper = FALSE)
adist = as.matrix(stadist)
diag(adist) = 10000
               ####    mean nearest neigbour distance:
land.station.spacing = median(apply(adist , 2 , min))
84.3585




## check by plotting neighbors with arrows:
neighbs = apply(adist ,1 , which.min)
plot( jsta$XY$x, jsta$XY$y, type='p' )
arrows(jsta$XY$x, jsta$XY$y, jsta$XY$x[neighbs], jsta$XY$y[neighbs])



#######################
obsdist = dist(cbind( jOBS$XY$x, jOBS$XY$y ), method = "euclidean", diag = FALSE, upper = FALSE)
odist = as.matrix(obsdist)

diag(odist) = 10000

obs.station.spacing = mean(apply(odist , 2 , min))
118.3

#######################

alldist = dist(cbind( c(SS1$x, SS$x, jOBS$XY$x, mariosta$XY$x), c(SS1$y, SS$y, jOBS$XY$y, mariosta$XY$y ) ), method = "euclidean", diag = FALSE, upper = FALSE)
alldist = as.matrix(alldist)
diag(alldist) = 10000
               ####    mean nearest neigbour distance:
land.station.spacing = median(apply(alldist , 2 , min))
about 30 km


#######################

library(sn)

kneighb = nnbr( cbind( jsta$XY$x, jsta$XY$y ), 1)
kneighb = nnbr( cbind( jOBS$XY$x, jOBS$XY$y), 1)

plot(jsta$XY$x, jsta$XY$y, pch=16, cex=1.5, col=XMCOL[5], type='p')


stats(stadist)
stats(obsdist)

knbr  = nnbr( cbind( (LL$x-mean(LL$x))/sqrt(var(LL$x)) , (LL$y-mean(LL$y))/ sqrt(var(LL$y) )) , 1 )

cl <- factor(c(rep("s",length(jsta$XY$x))))

knn(cbind( jsta$XY$x, jsta$XY$y ) , cbind( jsta$XY$x, jsta$XY$y ), cl , k = 1, prob=TRUE)



X11()
dev.set(3)

SHOWPAL(XMCOL)

dev.next()
dev.set( dev.next())

library(netcdf)

NAMET = open.netCDF("/home/lees/Site/NAndes/NANDES.grd")
names.netCDF(NAMET)

NANGRD = read.netCDF(NAMET)

close.netCDF(NAMET)

names(NANGRD)


ox = seq(from=NANGRD$"x_range"[1], to=NANGRD$"x_range"[2], by=NANGRD$"spacing"[1])
oy = seq(from=NANGRD$"y_range"[1], to=NANGRD$"y_range"[2], by=NANGRD$"spacing"[2])

Z = image(NANGRD$"z", ncol=NANGRD$"dimension"[1], nrow=NANGRD$"dimension"[2])



image(ox, oy, Z, col = terrain.colors(50)) 

persp()
############################
spatial ANalysis of earthquake distribution



plot(c(epts$x,pts$x), c(epts$y,pts$y), type='n')

points(epts$x, epts$y, pch=4, cex=0.3, col=XMCOL[15])
points(pts$x, pts$y, pch=8, cex=0.3, col=XMCOL[11])

J = locator()


plot(c(epts$x,pts$x), c(epts$y,pts$y), type='n', xlim=J$x, ylim=J$y)

points(epts$x, epts$y, pch=4, cex=0.3, col=XMCOL[15])
points(pts$x, pts$y, pch=8, cex=0.3, col=XMCOL[11])

AX = c(epts$x,pts$x)
AY = c(epts$y,pts$y)
AZ = c(engdahl$z,NAeqs$z)

#################

##  define geometry of area of interest:

BB = GLOB.XY( GL$lat, GL$lon)

dx = diff(BB$x)
dy = diff(BB$y)

dkm=100
NN = round(max(c(dx,dy)/dkm))

xvec = BB$x[1]+dkm*seq(0, NN)
yvec = BB$y[1]+dkm*seq(0, NN)

xmin = min(xvec)
ymin = min(yvec)
xmax = max(xvec)
ymax = max(yvec)

##  create a matrix of block numbers

flag = AX >= xmin & AX<=xmax & AY>=ymin & AY<=ymax


BX = AX[flag]
BY = AY[flag]

points(BX, BY, type='p')

RX = floor((BX-xmin)/dkm)+1
RY = floor((BY-ymin)/dkm)+1

points(dkm*RX+xmin, dkm*RY+ymin, type='p', col=3)

blks = xyztoi(RX, RY, rep(1,length(RX)), NN, NN, 1)

length(blks)


SAZ = split(AZ[flag], blks)

NSAZ =sapply(SAZ, "length")

mnSAZ =sapply(SAZ, "min")
mxSAZ =sapply(SAZ, "max")

nblks = 

iblks = as.numeric(names(mxSAZ[NSAZ>5]))

xblks = itoxyz(iblks, NN, NN, 1)

xyztoi(xblks$ix, xblks$iy, xblks$iz, NN, NN, 1)


x = dkm*(xblks$ix-1)+BB$x[1]
y = dkm*(xblks$iy-1)+BB$y[1]

z = (mxSAZ[NSAZ>5])

names(z) = NULL

SS = slabcont(x,y,z, levs=25,  POL=NULL)

NANMAP(PLOT=FALSE)

jgrid(xvec, yvec, col=grey(0.8))

contour(SS$prsurf, levels=SCONT$dlev, add=TRUE, col=XMCOL[9])

image(SS$prsurf,  col = rainbow(100), add=TRUE)

points(BOT$x  , BOT$y, pch=1)
points(x  , y, pch=15, col=2)

contour(SCONT$prsurf, levels=SCONT$dlev, add=TRUE, col=XMCOL[23])

LCONT  = SCONT$prsurf
LCONT$z = log(LCONT$z)


image(LCONT, col = rainbow(100),  add=TRUE)


image(SCONT$prsurf, breaks=51, add=TRUE)

PROJmap(NAmap, ADD=TRUE,  WIN=GL, ASP=TRUE, COL=TRUE)




#########################

#####  different Tack -


L = locator(2)
y1 = min(L$y)
y2 = max(L$y)

flagy = AY>=y1 & AY<=y2

YX = AX[flagy]
YY = AY[flagy]
YZ = AZ[flagy]

plot(YX, YZ, type='p')

dkm = 50
dkm = 100

Xbins = c(min(YX), min(YX)+   dkm*seq(1,floor(1+(max(YX)-min(YX))/dkm)))




binum = floor(1+(YX-min(YX))/dkm)

sbin = split(YZ, binum)
nambin = as.numeric(names(sbin))
xbin =   min(YX)-(dkm/2)+nambin*(dkm)


thresh = 5
maxbin = sapply(sbin, max)
lenbin = sapply(sbin, length)

plot(YX, YZ, type='p')


abline(v=Xbins)
points(Xbins+dkm/2, rep(0, length(Xbins)), pch=3, col=3)


       
points(xbin[lenbin>thresh],maxbin[lenbin>thresh], pch=6, col=2)

smod = smooth.spline(xbin[lenbin>thresh],maxbin[lenbin>thresh], df=10)
lines(smod, col="blue")

predict.smooth.spline(smod, Xbins, deriv = 0, ...)

predict(smod, Xbins, deriv = 0, ...)


text(YX, YZ, labels=binum)

MAXCUT<-function(YX,YZ,thresh=5, dkm=100)
  {
    binum = floor(1+(YX-min(YX))/dkm)
    sbin = split(YZ, binum)
    nambin = as.numeric(names(sbin))
    xbin =   min(YX)-(dkm/2)+nambin*(dkm)
    maxbin = sapply(sbin, max)
    lenbin = sapply(sbin, length)
    z=maxbin[lenbin>thresh]
    names(z) = NULL
    return(list(x=xbin[lenbin>thresh],z=z))

  }


whys = seq(from=BB$y[1], to=BB$y[2], by=100)
npts = as.list(1:length(whys))

for(i in 1:length(whys) )
  {
    y = whys[i]
    y1 = y-50
    y2= y+50
    flagy = AY>=y1 & AY<=y2
    
    YX = AX[flagy]
    YY = AY[flagy]
    YZ = AZ[flagy]
    
    npts[[i]] = MAXCUT(YX, YZ, thresh=5, dkm=100)

  }

names(unlist(npts))

##########################################
###  BIG scale map: GL = GL1
###  SMALLer scale map GL = GL2
NANMAP(PLOT=FALSE)

##    jgrid(xvec, yvec, col=grey(0.8))


contour(SCONT$prsurf, levels=SCONT$dlev, add=TRUE, col=XMCOL[22])

LCONT  = SCONT$prsurf
LCONT$z = log(LCONT$z)


image(LCONT, col = rainbow(100),  add=TRUE)

RZ = range(SCONT$prsurf$z[!is.na(SCONT$prsurf$z)])
##############
postscript(file ="Ecd_seismo_cont.ps" ,  horizontal=FALSE, onefile=FALSE, print.it=FALSE)

NANMAP(PLOT=FALSE)

image(SCONT$prsurf, zlim=c(0,800),col = rainbow(100),  levels=SCONT$dlev,add=TRUE)
contour(SCONT$prsurf, levels=SCONT$dlev, add=TRUE, col=XMCOL[22])

PROJmap(NAmap, ADD=TRUE,  WIN=GL, ASP=TRUE, COL=TRUE)
box()

HOZscale( SCONT$prsurf$z, col=rainbow(100)  , units="Km")
title(main="Depth to Bottom of Seismic Zone",xlab="Lon", ylab="Lat" )

dev.off()

##############
geoid= matrix(scan(file='geoid_eq.dat'), ncol=129, nrow=129, byrow=FALSE)

UL = list(nlat=129, nlon= 129, lat=8.125, lon=-103.875, d=0.25)

alats = rev(UL$lat-seq(from=0,by=UL$d, length=UL$nlat))
alons = UL$lon+seq(from=0,by=UL$d, length=UL$nlon)
image(alons,alats,  geoid)
GEOID = GLOB.XY(alats,alons)
image(GEOID$x,GEOID$y, col=rainbow(100),  geoid, add=TRUE)

####################
mapleg = scan(file='geoid_SA.leg')

UL = list(nlat=169, nlon= 97, lat=mapleg[2], lon=mapleg[3], d=0.25)

geoid= matrix(scan(file='geoid_SA.dat'), ncol=169, nrow=97, byrow=FALSE)

alats = rev(UL$lat-seq(from=0,by=UL$d, length=UL$nlat))
alons = UL$lon+seq(from=0,by=UL$d, length=UL$nlon)
image(alons,alats,  geoid, col=rainbow(100)  )
####################
cmap = heat.colors(100)
cmap = rainbow(100)

cmap =terrain.colors(100)

cmap =topo.colors(100)

cmap = cm.colors(100)


NANMAP(PLOT=FALSE)

image(GEOID$x,GEOID$y,  geoid, col=cmap , add=TRUE)

contour(SCONT$prsurf, levels=SCONT$dlev, add=TRUE, col=XMCOL[49])
PROJmap(NAmap, ADD=TRUE,  WIN=GL, ASP=TRUE, COL=TRUE)
box()


####################
image(GEOID$x,GEOID$y,  geoid, col=cmap, asp=1)

PROJmap(NAmap, ADD=TRUE,  WIN=GL, ASP=TRUE, COL=TRUE)
contour(SCONT$prsurf, levels=SCONT$dlev, add=TRUE, col=XMCOL[49])


box()

####################
topography


topo = scan(file="/home/lees/Bware/Topo/NANDES_ASCII.lonlat", list(lon=0,lat=0,z=0) )

plot(topo$lon, topo$lat, pch='.')


TOPO  = GLOB.XY(topo$lat, topo$lon)

JTOP   = data.frame(cbind(x=TOPO$x, y=TOPO$y,  z=topo$z))

JTOP.kr  =  surf.gls(2, expcov, JTOP, d=0.7)

toposurf  =  prmat(JTOP.kr,   min(JTOP$x), max(JTOP$x), min(JTOP$y), max(JTOP$y) , 100)


image(toposurf, col=cmap , add=TRUE)


x1 = sort(unique(TOPO$x))

y1 = sort(unique(TOPO$y))

TOP.LAT = sort(unique(topo$lat))
TOP.LON = fmod(sort(unique(topo$lon)), 360)

GENmap(NAmap)
GENmap(NAmap, ADD=TRUE, DIR=-1)


image(TOP.LON,(TOP.LAT), ZTOP, col=cmap, asp=1, add=TRUE)


ZTOP = matrix(topo$z, ncol=length(x1), nrow = length(y1))

ZZ = ZTOP[  , rev(1:length(TOP.LAT)) ]

TOPXY  = GLOB.XY(TOP.LAT, TOP.LON)

image(TOP.LON,(TOP.LAT), ZZ, col=cmap, asp=1, add=TRUE)

image(TOPXY$x, TOPXY$y, ZZ, col=cmap, asp=1, add=TRUE)


  image(x1,y1, ZTOP, col=cmap, asp=1, add=TRUE)

  
###     ITOP = interp(TOPO$x, TOPO$y,  topo$z, xo=GEOID$x, yo=GEOID$y)

cmap =terrain.colors(100)

NANMAP(PLOT=FALSE)
image(TOPXY$x, TOPXY$y, ZZ, col=cmap, asp=1, add=TRUE)
PROJmap(NAmap, ADD=TRUE,  WIN=GL, ASP=TRUE, COL=TRUE)
contour(SCONT$prsurf, levels=SCONT$dlev, add=TRUE, col=XMCOL[49])

###

grd2xyz NANDES.grd > NANDES.xyz
grdinfo NANDES.grd
awk '{ print $3 }' < NANDES.xyz > NANDES.z

ove% grdinfo NANDES.grd
NANDES.grd: Title:
NANDES.grd: Command: grdmath -V seafloor.grd nandestopo.grd AND = NANDES.grd
NANDES.grd: Remark:
NANDES.grd: Normal node registration used
NANDES.grd: grdfile format # 0
NANDES.grd: x_min: 254 x_max: 294 x_inc: 0.00833333 units: user_x_unit nx: 4801
NANDES.grd: y_min: -36 y_max: 8 y_inc: 0.00833333 units: user_y_unit ny: 5281
NANDES.grd: z_min: -7466.98 z_max: 6645.14 units: user_z_unit
NANDES.grd: scale_factor: 1 add_offset: 0


NANDES.grd = scan(file='/home/lees/Site/NAndes/NANDES.xyz',list(x=0, y=0, z=0))
NANDES.z = scan(file='/home/lees/Site/NAndes/NANDES.z')


ngridlon = seq(from=254, by=0.00833333, length=4801)
ngridlat = seq(from=-36, by=0.00833333, length=5281)

NNG =  GLOB.XY(ngridlat, ngridlon)

NANMAP(PLOT=FALSE)

ZZ = matrix(NANDES.z, nrow=5281, ncol=4801, byrow=TRUE)

image(NNG$x, NNG$y, (ZZimg), col=cmap, asp=1, add=TRUE)

PROJmap(NAmap, ADD=TRUE,  WIN=GL, ASP=TRUE, COL=TRUE)
contour(SCONT$prsurf, levels=SCONT$dlev, add=TRUE, col=XMCOL[49])

ZZimg = ZZ[  , rev(1:length(NNG$y)) ]

###
grdcut /data/whiskey/lees/DUMP/world.grd -R264/294/-24/10 -Gzoom.grd  -V
grd2xyz zoom.grd > zoom.xyz
grdinfo zoom.grd 
###  R
NANDES.grd = scan(file='/home/lees/Site/NAndes/zoom.xyz',list(x=0, y=0, z=0))

nx = 361
ny = 409
dx = 0.0833333
dy = 0.0833333
xmin = 264
xmax = 294
ymin = -24
ymax = 10

ZZ = matrix(NANDES.grd$z, nrow=ny, ncol=nx, byrow=TRUE)
ngridlon = seq(from=xmin, by=dx, length=nx)
ngridlat = seq(from=ymin, by=dy, length=ny)
NNG =  GLOB.XY(ngridlat, ngridlon)
ZZimg = t(ZZ[ rev(1:ny), ])

#####  Figure with Topography
cmap =topo.colors(100)
cmap =terrain.colors(100)

##### NANDES.XY =  GLOB.XY(NANDES.grd$x, NANDES.grd$y)

##### topo = data.frame(x=NANDES.XY$x  , y=NANDES.XY$y  , z=NANDES.grd$z )

##### topo.kr <- surf.gls(2, expcov,topo , d=200, nx=400)


contour( NNG$x, NNG$y, (ZZimg) , add=TRUE, col=2)

prsurf <- prmat(SLAB.kr,   min(SLAB.bot$x), max(SLAB.bot$x), min(SLAB.bot$y), max(SLAB.bot$y) , 100)


postscript(file ="topo_vs_slab.ps" ,  horizontal=FALSE, onefile=FALSE, print.it=FALSE)

NANMAP(PLOT=FALSE)

image(NNG$x, NNG$y, (ZZimg), col=cmap, asp=1, add=TRUE)

PROJmap(NAmap, ADD=TRUE,  WIN=GL, ASP=TRUE, COL=TRUE)
contour(NCONT$prsurf, levels=SCONT$dlev, add=TRUE, col=XMCOL[53])
box()
title(main="Topography vs Slab",xlab="Lon", ylab="Lat" )
points(volcs$x, volcs$y, pch=2, col=2)
contour( NNG$x, NNG$y, (ZZimg) , levels=seq(from=-3000, to=-1000, by=500)  ,add=TRUE, col=1)

KMscale(kmL, len=500)

Markup(JJ, cex=1.5, length = 0.05, lwd=2)


### NAMARKS()

### kmL = locator(2)


dev.off()
##########
##########  preparation of Mark up points




MIDS = MAPID()
TMIDS = c("Nazca Ridge", "Carnegie Ridge", "Present Convergence 61 mm/yr")

JMARKS = c("Nazca Ridge", "Carnegie Ridge", "Present Convergence\n61 mm/yr", "Grijalvy\nFracture\nZone")

JJ = setMarkup(LABS=JMARKS)

JJ = setMarkup(LABS=TMIDS)

XMIDS = GLOB.XY(MIDS$lat, MIDS$lon)
points(XMIDS$x, XMIDS$y)
RANGS = rep(0,length(TMIDS))
LATS = rep(0,length(TMIDS))
LONS = rep(0,length(TMIDS))
EXMID = rep(0,length(TMIDS))
WHYMID = rep(0,length(TMIDS))
ADJ = rep(0,length(TMIDS))

for(i in 1:length(TMIDS))
    {
      j = (i-1)*2+1
      x1 = XMIDS$x[j]
      y1 = XMIDS$y[j]
      x2 = XMIDS$x[j+1]
      y2 = XMIDS$y[j+1]

      RANGS[i] = 180*atan2(y2-y1, x2-x1)/pi
      EXMID[i] =  x1
      WHYMID[i] = y1
      gl = XY.GLOB(x1, y1)
      
      LATS[i] = gl$lat
      LONS[i] = gl$lon
      ADJ[i] = 0
      
    }
    ADJ[3] = 0.5
################



    for(i in 1:length(JJ))
      {
        JJ[[i]]$CEX = 1.2
      }


 JJ[[1]]$ARR = FALSE
 JJ[[2]]$ARR = FALSE
 JJ[[2]]$pos = 4

JJ[[4]]$CEX = 1

################   PLOT MARK UP

NAMARKS<-function()
  {
    u = par("usr")
    for(i in 1:length(TMIDS))
      {
        text(EXMID[i], WHYMID[i], labels=TMIDS[i], srt=RANGS[i], adj=ADJ[i])
      }

    i = 3
    d1 = 0.08*(u[2]-u[1])
    x1 = EXMID[i]
    y1 = WHYMID[i]
    angle = RANGS[i]
    d1 = 
    x2 = x1+  d1* cos( pi*(angle)/180)
    y2 = y1+  d1* sin( pi*(angle)/180)


    arrows(x1, y1, x2, y2, length = 0.05, lwd=2)
    
  }




#####

cmap = rainbow(100)
postscript(file ="geoid_vs_slab.ps" ,  horizontal=FALSE, onefile=FALSE, print.it=FALSE)

NANMAP(PLOT=FALSE)

image(GEOID$x,GEOID$y,  geoid, col=cmap , add=TRUE)

contour(SCONT$prsurf, levels=SCONT$dlev, add=TRUE, col=XMCOL[53])
PROJmap(NAmap, ADD=TRUE,  WIN=GL, ASP=TRUE, COL=TRUE)
box()
title(main="Geoid vs Slab",xlab="Lon", ylab="Lat" )

dev.off()
#####

cmap = rainbow(100)
postscript(file ="geoid_vs_slab.ps" ,  horizontal=FALSE, onefile=FALSE, print.it=FALSE)

NANMAP(PLOT=FALSE)

image(GEOID$x,GEOID$y,  geoid, col=cmap , add=TRUE)



### contour( NNG$x, NNG$y, (ZZimg) , levels=seq(from=-3000, to=-1000, by=500)  ,add=TRUE, col=1)
contour( GEOID$x,GEOID$y,  geoid  , levels=pretty(range(geoid), n=20), add=TRUE, col=XMCOL[53])

contour( NNG$x, NNG$y, (ZZimg)   ,add=TRUE, col=1)



##  contour(SCONT$prsurf, levels=SCONT$dlev, add=TRUE, col=XMCOL[53])
PROJmap(NAmap, ADD=TRUE,  WIN=GL, ASP=TRUE, COL=TRUE)
box()
title(main="Geoid vs Slab",xlab="Lon", ylab="Lat" )

dev.off()

#####
calcol = scan(file="/home/lees/Site/NAndes/cal_color.cptR", list(z1=0, r1=0,g1=0,b1=0, z2=0,  r2=0,g2=0,b2=0, note=" ") )

rng = range(ZZimg)
ncol = 100

levs = seq(from=rng[1], to=rng[2], length=100)

calcol$z1[1]-levs

calcol$COL1 = rgb(calcol$r1/255,calcol$g1/255, calcol$b1/255)


cmap =topo.colors(100)
cmap = calcolmap


NANMAP(PLOT=FALSE)
image(NNG$x, NNG$y, (ZZimg), col=cmap, asp=1, add=TRUE)

contour( GEOID$x,GEOID$y,  geoid  , levels=pretty(range(geoid), 20), add=TRUE, col=XMCOL[53])

###################


persp(NNG$x, NNG$y, (ZZimg), theta = 0, phi = 90, r=4000, col="grey" , scale = FALSE,
      ltheta = -120, shade = 0.75, border = NA, expand=0.5, box = FALSE )

persp( alons,alats,  geoid , theta = 0, phi = 90, r=4000, col="grey" , scale = FALSE,
      ltheta = -120, shade = 0.75, border = NA, expand=0.5, box = FALSE )


persp( SCONT$prsurf , theta = 0, phi = 90, r=500, col="grey" , scale = FALSE,
      ltheta = -90, lphi=30, border = NA , shade=2, box = FALSE )


persp( NCONT$prsurf , theta = 0, phi = 90, r=500, col="grey" , scale = FALSE,
      ltheta = -90, lphi=30, border = NA , shade=2, box = FALSE )



###################

    par(bg = "slategray")
     persp(x, y, z, theta = 135, phi = 30, col = fill, scale = FALSE,
           ltheta = -120, lphi = 15, shade = 0.65, axes = FALSE)



     persp(x, y, z, theta = 0, phi = 90, col = "green3", scale = FALSE,
           ltheta = -120, shade = 0.75, border = NA, box = FALSE)


###################


intvals = findInterval(levs, calcol$Z)

n2 = length(calcol$z2)
calcol$Z =  c(calcol$z1, calcol$z2[n2],calcol$z2[9]+3000)
calcol$R1 = c(calcol$r1, calcol$r2[n2], calcol$r2[n2])
calcol$G1 = c(calcol$g1, calcol$g2[n2], calcol$g2[n2])
calcol$B1 = c(calcol$b1, calcol$b2[n2], calcol$b2[n2])

calcol$R2 = c(calcol$r2, calcol$r2[n2], calcol$r2[n2])
calcol$G2 = c(calcol$g2, calcol$g2[n2], calcol$g2[n2])
calcol$B2 = c(calcol$b2, calcol$b2[n2], calcol$b2[n2])

vec = cbind(calcol$R2-calcol$R1, calcol$G2-calcol$G1,  calcol$B2-calcol$B1)


lens = sqrt((calcol$R2-calcol$R1)^2 + (calcol$G2-calcol$G1)^2 +  (calcol$B2-calcol$B1)^2)



dis = (calcol$Z[intvals]-levs)/(calcol$Z[intvals]-(calcol$Z[intvals+1]))

co = cbind(floor(dis*vec[intvals,1]+calcol$R1[intvals]) , floor(dis*vec[intvals,2]+calcol$G1[intvals]), floor(dis*vec[intvals,3]+calcol$B1[intvals]))

calcolmap = rgb(r=co[,1]/255, g=co[,2]/255, b=co[,3]/255)


#######################

1 1  400 400 50 5.0  5.0
-10.0 0.0 0.0 
88.0 0.0 0.0

NANMAP(PLOT=FALSE)
PROJmap(NAmap, ADD=TRUE, ASP=TRUE, COL=TRUE)

org = list(lon=-88, lat=-10,  nx=400, ny=400, nz= 50, dx= 5.0, dy=  5.0)
org$XY =  GLOB.XY(org$lat, fmod(org$lon, 360) )
points(org$XY$x, org$XY$y, pch=5, col=2)
lines( c(org$XY$x[1], org$XY$x[1]+org$nx*org$dx, org$XY$x[1]+org$nx*org$dx, org$XY$x[1], org$XY$x[1]),
      c(org$XY$y[1], org$XY$y[1], org$XY$y[1]+org$ny*org$dy, org$XY$y[1]+org$ny*org$dy, org$XY$y[1]))


targ =locator()
#  round(targ$x, digits=3)
#  round(targ$y, digits=3)

  NANMAP(PLOT=FALSE, WIN=ECzoom)
    points(epts$x, epts$y, pch=4, cex=0.3, col=XMCOL[15])
    points(pts$x, pts$y, pch=8, cex=0.3, col=XMCOL[11])
 points(volcs$x, volcs$y, pch=17, cex=0.8, col=2)
    PROJmap(NAmap, ADD=TRUE,  WIN=ECzoom, ASP=TRUE, COL=TRUE)
    box()
points(mariosta$XY$x, mariosta$XY$y, pch=6, col=XMCOL[22])
    
    points(jOBS$XY$x, jOBS$XY$y, pch=16, cex=1.5, col=XMCOL[44])
    points(SS1$x, SS1$y, pch=16, cex=1.5, col=XMCOL[5])

targ$LL = XY.GLOB(targ$x, targ$y)
targ$LL$lon=round(targ$LL$lon, digits=3)
targ$LL$lat=round(targ$LL$lat, digits=3)


org = list(lon=targ$LL$lon[1], lat=targ$LL$lat[1],  nx=120, ny=160, nz=50, dx= 2, dy=3)
org$XY =  GLOB.XY(org$lat, fmod(org$lon, 360) )
points(org$XY$x, org$XY$y, pch=5, col=2)
lines( c(org$XY$x[1], org$XY$x[1]+org$nx*org$dx, org$XY$x[1]+org$nx*org$dx, org$XY$x[1], org$XY$x[1]),
      c(org$XY$y[1], org$XY$y[1], org$XY$y[1]+org$ny*org$dy, org$XY$y[1]+org$ny*org$dy, org$XY$y[1]))

##############################



###  cd /home/lees/Progs/Palette
###  makepal 100 -t -x > tomo100.R

A = GXMA("/home/lees/Site/NAndes/Ecuador/hay5.RIMAGE")

donan()
source("/home/lees/Progs/Palette/tomo100.R")
###  this gets the tomocolor palette
image(A$kmx, A$kmy, t(A$z) , col=tomocolors, asp=1, add=TRUE)

postscript(file ="CheckerDetail_5.ps" ,  horizontal=FALSE, onefile=FALSE, print.it=FALSE)

donan()
image(A$kmx, A$kmy, t(A$z) , col=tomocolors, asp=1, add=TRUE)
rect(min(A$kmx), min(A$kmy), max(A$kmx), max(A$kmy))
AXESmap(NAmap, GRID=TRUE,  WIN=ECzoom)
title(xlab="Lon", ylab="Lat", main="Checkerboard Test Detail: 20-30 km Depth")

KMscale(kmLz, len=100)
dev.off()
#######
RG = GXMA("/home/lees/Site/NAndes/Ecuador/gross5.RIMAGE")

RG = GXMA("/home/lees/Site/NAndes/Ecuador/G13.RIMAGE")



ECL2  = locator(2)

ECZ2 = XY.GLOB(ECL2$x, ECL2$y)
kmLz2 = locator(2)

donan(WIN=ECZ2)

image(RG$kmx, RG$kmy, t(RG$z) , col=tomocolors, asp=1, add=TRUE)

postscript(file ="CheckerGross_13.ps" ,  horizontal=FALSE, onefile=FALSE, print.it=FALSE)

donan(WIN=ECZ2)
image(RG$kmx, RG$kmy, t(RG$z) , col=tomocolors, asp=1, add=TRUE)
rect(min(RG$kmx), min(RG$kmy), max(RG$kmx), max(RG$kmy))
contour(SCONT$prsurf, levels=SCONT$dlev, add=TRUE, col=XMCOL[23])

PROJmap(NAmap, ADD=TRUE,  WIN=ECZ2, ASP=TRUE, COL=FALSE, dcol=3)
AXESmap(NAmap, GRID=TRUE,  WIN=ECZ2)
title(xlab="Lon", ylab="Lat", main="Checkerboard Large Scale: 100-110 km Depth")


KMscale(kmLz2, len=500)

dev.off()


#######

EQ2002=scan(file="/home/lees/Site/NAndes/Ecuador/2002.DAT", list(lat=0, lon=0, z=0, yr=0, mo=0, d=0, h=0, m=0, s=0))

plot(EQ2002$lon, EQ2002$lat, type='p')


EQ2002$XY = GLOB.XY(EQ2002$lat, EQ2002$lon)



NANMAP(PLOT=TRUE, WIN=ECzoom)
points(EQ2002$XY$x, EQ2002$XY$y, pch=4)

#######
## read in cross section picks from geotouch

nslab = scan(file="/home/lees/Site/NAndes/slab_zoom.picks", list(d=0, z=0, j='', lat=0, lon=0, j2=' ', sec=0))
NSLAB = list(lat=nslab$lat, lon=nslab$lon, z=nslab$z)
rm(nslab)



