 R<-6378.2064
 DEG2RAD<-pi/180
 RAD2DEG<-180/pi
 EARTHRAD<- 6378.163
 PO180<-pi/180

##### source("/home/lees/Progs/R_stuff/Part.Mo.R")
##### source("/home/lees/Progs/R_stuff/p3d.R")

wazi<-function(ain, len, shift, p )
{
##X## very old version of particle motion analysizer
  
#  particle motion estimator
#    len=window length   shift=10 samples  p=pre-event offset(0.1)
	opar=par()
	alen=length(ain$dat[,1])
	dt=ain$info$dt[1]
	ex = ain$t

	dat = ain$dat


	comp = ain$comp
	sta = ain$sta[1]


	ascd = ain$data
	fil = ain$info$fn[1]
	pfil  = "" 
	id = ain$info$fn[1]
	sec = ain$info$sec
 	az = ain$az
	
  	aex=rep(0,alen)
 	aaz=rep(0,alen)
  	ai=rep(0,alen)
  	rateig=rep(0,alen)

	winlen=len*dt
 	winn=len
  	winhalf=winn/2
	k = winn/2
   	wincen=ex[k]-ex[1]	
   	wina=(wincen/dt)-winhalf
    	winb=(wincen/dt)+winhalf
  
  	k=len/2
  	j=1
  
  	mintic=round(min(ex)*10)/10
  	maxtic=round(max(ex)*10)/10
  	xtics=seq(from=mintic, to=maxtic, by=1)

  	# for each trace, find pre-event DC offset and remove that from the whole trace
	# do not remove the mean again below, that would be wrong

  	ax=1:length(ex)

	#   here we determine a limit on X

  	flagax = ax[ex<p]
  	tem=dat[ flagax ,]
  	mns=apply(tem,2,mean)
  	dtem=sweep(dat, 2, mns)

  while(k<(alen-len/2))
    {
      wincen=ex[k]-ex[1]
      wina=round((wincen/dt)-winhalf+1)
      winb=round((wincen/dt)+winhalf+1)
      
      winb=min(winb,alen)
print(c(wina, winb))

      tem=dtem[wina:winb,]
					# need to remove the mean value from each column (we did this above)
					#    NO:  tem_sweep(tem, 2, apply(tem,2,mean))
      
      covtem=t(tem) %*% (tem)
      eg=eigen(covtem)
					# Be_winn*diag(1,nrow=3) + matrix(c(-1,1,1,1,-1,1,1,1,-1),nrow=3)*covtem
					# Beg_eigen(Be)
      
					# Kappa=log(Beg$values[1]/Beg$values[2])/log(Beg$values[2]/Beg$values[3])
      
      
      aex[j]=ex[k]
      ## rateig[j]=sqrt( eg$values[2]^2 + eg$values[3]^2 ) / eg$values[1]


      ##  Joydeep recommends using the following measure of rectilinearity
      ## jepsen and kennett, 1990, bssa, 80b, #6, 2032-2052.

      rateig[j]= 1 - ((eg$values[2]+eg$values[3])/(2*eg$values[1]))


      
					#  rateig[j]=Kappa

      #   careful here: be sure the azimuth below is calculated in the N-E-Down coordinate system
#   1=Z   2=N   3=E
#  this means that the real azimuth is 90-alpha  where alpha is the counter-clockwise
#  coordinate angle derived below

      alpha=RAD2DEG*atan(eg$vectors[2,1], eg$vectors[3,1])

       az=90-alpha


      inci=RAD2DEG*atan(eg$vectors[1,1], sqrt(eg$vectors[2,1]^2+eg$vectors[3,1]^2))


### convert angles so that they are orientations as shiftnd not simply directions
###  this is because the direction is irrelevant and -10deg=170deg orientation

      if(az<0) az=az+180
      aaz[j]=az
      if(inci<0)inci=abs(inci)
      ai[j]=inci
      
      k=k+shift
      j=j+1
    }
  jall=j-1
  

  dev.set(which=2)
#########   old: par(mfrow=c(6, 1) )
  par(mfrow=c(3, 1) )
  par(mai=c(0.0, .5, 0.1, 0.5) )
  for(i in 1:3)
    { 
      plot(ex,dat[,i],axes=FALSE, xlab="",ylab="", type="l")
      
      axis(1,tck=.03,at=xtics,lab=FALSE)
      axis(2, las=1)
      axis(3,tck=.03,at=xtics,lab=FALSE)
      box()
      locy=0.8*max(ascd[,i])

      if(comp[i]=="SHV"||comp[i]=="4" ) tcomp="Vertical"
      if(comp[i]=="SHN"|| comp[i]=="5") tcomp="North"
      if(comp[i]=="SHE" || comp[i]=="6") tcomp="East"
      if(comp[i]=="V"||comp[i]=="4" ) tcomp="Vertical"
      if(comp[i]=="N"|| comp[i]=="5") tcomp="North"
      if(comp[i]=="E" || comp[i]=="6") tcomp="East"
       if(comp[i]=="G1V"||comp[i]=="4" ) tcomp="Vertical"
      if(comp[i]=="G1N"|| comp[i]=="5") tcomp="North"
      if(comp[i]=="G1E" || comp[i]=="6") tcomp="East"
     



      text(ex[1], locy,paste(sta,tcomp,sep=" : ") ,cex=.8, adj=0)
      
      
     #  plot.ps(ain)
     #  plot.t1t2(ain)
      
 #      letter.it(i,2)
      
    }	
  i=3
  locy=0.8*max(ascd[,i])
					#  locy=0.95*min(dat[,i])
					# text(max(ex), locy, paste(ain$fil, ain$pfil,ain$id, ain$sec,sep=" : ") , cex=.8,  adj=1, col=3)
  
#######  NOW plot New Stuff  ############################
##  this switches to the other opened window

    dev.set(which=3)
  par(mfrow=c(3, 1) )
  par(mai=c(0.0, .5, 0.1, 0.5) )



####  RATIO
  

  plot(aex[0:jall],rateig[0:jall],xlim=range(ex),axes=FALSE, xlab="",ylab="RatEig")
  locy=0.8*max(rateig[0:jall])
  
  axis(2, las=1)
 # axis(1,at=xtics,tck=.03, las=1,   mgp=c(.1,.1,0))
  axis(3,at=xtics,tck=.03,lab=FALSE)
  mtext( paste(fil, pfil,id, sec,sep=" : ") , line=0.1)
  
 #  plot.ps(ain)
#   plot.t1t2(ain)
  box()
 #  letter.it(4,2)


  # dev.prev()

  #   invisible(par(opar))

#####    INC ANGLE
  
  plot(aex[0:jall],ai[0:jall],xlim=range(ex),ylim=c(0,90),axes=FALSE, xlab="",ylab="IncAng, deg")
					#   abline(h=c(0))
					#   axis(2, las=1)
 #  axis(2, at=c(-60, -30,0,30 , 60), tck=1, las=1, lty=2, lwd=0.5)
axis(2, at=seq(0,90, by=10), tck=1, las=1, lty=2, lwd=0.5)
  axis(3,at=xtics,tck=.03,lab=FALSE)
#   plot.ps(ain)
#   plot.t1t2(ain)
  
#   letter.it(5,2)
  box()

  incpar=par()

  figinc=par("fig")
  

#####   Azimuth
 #  par(mai=c(0.2, .5, 0.15, 0.5) )

  plot(aex[1:jall],aaz[1:jall],xlim=range(ex),ylim=c(0,180),axes=FALSE, xlab="",ylab="Az, deg")
 # axis(2, at=c(-150,-100, -50,0,50, 100, 150), tck=1, las=1, lty=2, lwd=0.5)
  axis(2, at=seq(0,180, by=20), tck=1, las=1, lty=2, lwd=0.5)
  axis(3,at=xtics,tck=.03,lab=FALSE)
  axis(1,at=xtics,tck=.03, las=1,   mgp=c(.1,.1,0))

  AZ=az
  if(AZ>180) AZ=AZ-360
					# abline(h=c(0))
  abline(h=c(AZ),lty=4, col=2)
					#     locy=0.8*max(aaz[0:jall])
  locy=165
  text(max(xtics), 0.8*max(aaz[0:jall]), paste("AZ=",format.default(AZ, digits=3)) ,adj=1, cex=.8, col=2)
  box()
  

#   plot.ps(ain)
#   plot.t1t2(ain)

  # plot.medbars(ain,aex[1:jall], aaz[1:jall]   )

   figaz=par("fig")
   usraz=par("usr")
  
					#     locy=0.9*min(aaz[0:jall])
  locy=-165
  m=max(aex[0:jall])
  segments( m-winlen, locy, m , locy, lwd=3)
  
#   letter.it(6,2)
  
  azpar=par()
    
  list(aex=aex[1:jall], rateig=rateig[1:jall], aaz=aaz[1:jall], ai=ai[1:jall], figaz=figaz, azpar=azpar, incpar=incpar )	
  
  
}

#######################################################################################
#######################################################################################
#######################################################################################
######### aa = Cazi(a1, 60, 1, 0.1)
## aa = Cazi(a1, 20, 1, 0.1)



Cazi<-function(ain, len, shift, p )
{
##X##  (older version)  
##X## #  particle motion estimator
##X## #    len=window length   shift=10 samples  p=pre-event offset(0.1)
	opar=par()
	alen=length(ain$data[,1])
	dt=ain$info$dt[1]
	ex = ain$t

	dat = ain$data


	comp = ain$comp
	sta = ain$sta[1]


	ascd = ain$data
	fil = ain$info$fn[1]
	pfil  = "" 
	id = ain$info$fn[1]
	sec = ain$info$sec
 	az = ain$az
	
  	aex=rep(0,alen)
 	aaz=rep(0,alen)
  	ai=rep(0,alen)
  	rateig=rep(0,alen)

	winlen=len*dt
 	winn=len
  	winhalf=winn/2
	k = winn/2
   	wincen=ex[k]-ex[1]	
   	wina=(wincen/dt)-winhalf
    	winb=(wincen/dt)+winhalf
  
  	k=len/2
  	j=1
  

  # 	xtics=pretty(seq(from=min(ex), to=max(ex), N=10))
  	xtics=pretty(ex, n=10)


	mintic=min(xtics)
	maxtic=max(xtics)

  	# for each trace, find pre-event DC offset and remove that from the whole trace
	# do not remove the mean again below, that would be wrong

  	ax=1:length(ex)

	#   here we determine a limit on X

  	flagax = ax[ex<p]
  	tem=dat[ flagax ,]
  	mns=apply(tem,2,mean)
  	dtem=sweep(dat, 2, mns)

  while(k<(alen-len/2))
    {
      wincen=ex[k]-ex[1]
      wina=round((wincen/dt)-winhalf+1)
      winb=round((wincen/dt)+winhalf+1)
      
      winb=min(winb,alen)
print(c(wina, winb))

      tem=dtem[wina:winb,]
					# need to remove the mean value from each column (we did this above)
					#    NO:  tem=sweep(tem, 2, apply(tem,2,mean))
      
      covtem=t(tem) %*% (tem)
      eg=eigen(covtem, symmetric = TRUE )
					# Be=winn*diag(1,nrow=3) + matrix(c(-1,1,1,1,-1,1,1,1,-1),nrow=3)*covtem
					# Beg=eigen(Be)
      
					# Kappa=log(Beg$values[1]/Beg$values[2])/log(Beg$values[2]/Beg$values[3])
      
      
      aex[j]=ex[k]
      ## rateig[j]=sqrt( eg$values[2]^2 + eg$values[3]^2 ) / eg$values[1]


      ##  Joydeep recommends using the following measure of rectilinearity
      ## jepsen and kennett, 1990, bssa, 80b, #6, 2032-2052.

      rateig[j]= 1 - ((eg$values[2]+eg$values[3])/(2*eg$values[1]))


      
					#  rateig[j]=Kappa

      #   careful here: be sure the azimuth below is calculated in the N-E-Down coordinate system
#   1=Z   2=N   3=E
#  this means that the real azimuth is 90-alpha  where alpha is the counter-clockwise
#  coordinate angle derived below

      alpha=RAD2DEG*atan(eg$vectors[2,1], eg$vectors[3,1])

       az=90-alpha


      inci=RAD2DEG*atan(eg$vectors[1,1], sqrt(eg$vectors[2,1]^2+eg$vectors[3,1]^2))


### convert angles so that they are orientations as shiftnd not simply directions
###  this is because the direction is irrelevant and -10deg=170deg orientation

      if(az<0) az=az+180

      aaz[j]=az
      if(inci<0)inci=abs(inci)
      ai[j]=inci
      
      k=k+shift
      j=j+1
    }
  jall=j-1
  
  dev.set(which=2)
#########   old: par(mfrow=c(6, 1) )
  par(mfrow=c(6, 1) )
  par(mai=c(0.0, .5, 0.1, 0.5) )
  for(i in 1:3)
    { 
      plot(ex,dat[,i],axes=FALSE, xlab="",ylab="", type="l")
      
      axis(1,tck=.03,at=xtics,lab=FALSE)
      axis(2, las=1)
      axis(3,tck=.03,at=xtics,lab=FALSE)
      box()
      locy=0.8*max(ascd[,i])

      if(comp[i]=="SHV"||comp[i]=="4" ) tcomp="Vertical"
      if(comp[i]=="SHN"|| comp[i]=="5") tcomp="North"
      if(comp[i]=="SHE" || comp[i]=="6") tcomp="East"
      if(comp[i]=="V"||comp[i]=="4" ) tcomp="Vertical"
      if(comp[i]=="N"|| comp[i]=="5") tcomp="North"
      if(comp[i]=="E" || comp[i]=="6") tcomp="East"
       if(comp[i]=="G1V"||comp[i]=="4" ) tcomp="Vertical"
      if(comp[i]=="G1N"|| comp[i]=="5") tcomp="North"
      if(comp[i]=="G1E" || comp[i]=="6") tcomp="East"
     
      text(ex[1], locy,paste(sta,tcomp,sep=" : ") ,cex=.8, adj=0)
      
       plot.ps(ain)
       plot.t1t2(ain)
      
      letter.it(i,2)
      
    }	
  i=3
  locy=0.8*max(ascd[,i])
					#  locy=0.95*min(dat[,i])
					# text(max(ex), locy, paste(ain$fil, ain$pfil,ain$id, ain$sec,sep=" : ") , cex=.8,  adj=1, col=3)
  
#######  NOW plot New Stuff  ############################
##  this switches to the other opened window

##    dev.set(which=3)
##  par(mfrow=c(3, 1) )
  par(mai=c(0.0, .5, 0.1, 0.5) )


#####   Azimuth
 #  par(mai=c(0.2, .5, 0.15, 0.5) )

  plot(aex[1:jall],aaz[1:jall],xlim=range(ex),ylim=c(0,180),axes=FALSE, xlab="",ylab="Az, deg")

 # axis(2, at=c(-150,-100, -50,0,50, 100, 150), tck=1, las=1, lty=2, lwd=0.5)
  axis(2, at=seq(0,180, by=20), tck=1, las=1, lty=2, lwd=0.5)
  axis(3,at=xtics,tck=.03,lab=FALSE)
 #  axis(1,at=xtics,tck=.03, las=1,   mgp=c(.1,.1,0))

  AZ= ain$az[1]

  if(AZ>180) AZ=AZ-360
					# abline(h=c(0))
  abline(h=c(AZ),lty=4, col=2)
    #   locy=0.8*max(aaz[0:jall])
  locy=165
  text(max(xtics), locy, paste("AZ=",format.default(AZ, digits=3)) ,adj=1, cex=1.2, col=2)
  box()
  

   plot.ps(ain)
   plot.t1t2(ain)

 #  plot.medbars(ain,aex[1:jall], aaz[1:jall]   )

   figaz=par("fig")
   usraz=par("usr")
  
     locy=0.9*min(aaz[0:jall])
 	#   locy=-165
  m=max(aex[0:jall])
  segments( m-winlen, locy, m , locy, lwd=3)
  
   letter.it(4,2)
  
  azpar=par()
    


#####    INC ANGLE
  
  plot(aex[0:jall],ai[0:jall],xlim=range(ex),ylim=c(0,90),axes=FALSE, xlab="",ylab="IncAng, deg")
					#   abline(h=c(0))
					#   axis(2, las=1)
 #  axis(2, at=c(-60, -30,0,30 , 60), tck=1, las=1, lty=2, lwd=0.5)
axis(2, at=seq(0,90, by=10), tck=1, las=1, lty=2, lwd=0.5)
  axis(3,at=xtics,tck=.03,lab=FALSE)
   plot.ps(ain)
   plot.t1t2(ain)
  
   letter.it(5,2)
  box()

  incpar=par()

  figinc=par("fig")
  
####  RATIO
  

  plot(aex[0:jall],rateig[0:jall],xlim=range(ex),axes=FALSE, xlab="",ylab="RatEig")
  locy=0.8*max(rateig[0:jall])
  
  axis(2, las=1)
  axis(1,at=xtics,tck=.03, las=1,   mgp=c(.1,.1,0))
  axis(3,at=xtics,tck=.03,lab=FALSE)
  mtext( paste(fil, pfil,id, sec,sep=" : ") , line=0.1)
  
   plot.ps(ain)
   plot.t1t2(ain)
  box()
   letter.it(6,2)


  # dev.prev()

  #   invisible(par(opar))

  list(aex=aex[1:jall], rateig=rateig[1:jall], aaz=aaz[1:jall], ai=ai[1:jall], figaz=figaz, azpar=azpar, incpar=incpar )	
  
  
}

#############################
########
plot.t1t2<-function(ain)
{
 ##X##  plot arrival times for T1 and T2 (coso reflections) 
  u=par("usr")
  py1=u[4]-0.1*(u[4]-u[3])
  pyt=u[4]-0.05*(u[4]-u[3])
  py2=u[4]-0.25*(u[4]-u[3])
  if( ain$T1[1] > 0 ) 
    { 
      pex=ain$T1[1]
      abline(v=pex, col=3, lty=3)
      arrows(pex, py1, pex, py2, length=.05, code=2)
      text(pex, pyt, "T1", adj=0)
      
    }
  if( ain$T2[1] > 0 ) 
    { 
      pex=ain$T2[1]
      abline(v=pex, col=3, lty=3)
      arrows(pex, py1, pex, py2, length=.05 )
      text(pex, pyt, "T2", adj=0)
      
    }


}
########
plot.ps<-function(ain)
{
 ##X## plot P and S arrival times in the seismogram
  u=par("usr")
  pyt=u[4]-0.05*(u[4]-u[3])
  abline(v=ain$p, col=2, lty=3)
  text(ain$p, pyt, "P", adj=0)
  if( ain$s > 0 ) 
    {
      abline(v=ain$s, col=2, lty=3)
      text(ain$s, pyt, "S", adj=0)
    }
}



########
plot.medbars<-function(ain, wex, aaz)
{
##X## 
  winaz=30*ain$dt
  locid=wex>ain$p&wex<(ain$p+winaz)  
  mdazp=median(aaz[locid])

  segments( ain$p, mdazp,   ain$p+winaz , mdazp , col=3)
  mlow=quantile(aaz[locid], 0.25)
  mhi=quantile(aaz[locid], 0.75)
  error.bar( ain$p+winaz/2, mdazp ,mlow, mhi, incr=FALSE, add=TRUE)

 if( ain$s > 0 ) 
    {
         winaz=40*ain$dt

      locid=wex>ain$s&wex<(ain$s+winaz)  
      mdazs=median(aaz[locid])
      mlow=quantile(aaz[locid], 0.25)
      mhi=quantile(aaz[locid], 0.75)
      error.bar( ain$s+winaz/2, mdazs ,mlow, mhi, incr=FALSE, add=TRUE)
      segments( ain$s, mdazs,   ain$s+winaz , mdazs , col=3)

    }
 if( ain$T1 > 0 ) 
    {
         winaz=30*ain$dt

      locid=wex>ain$T1&wex<(ain$T1+winaz)  
      mdazT1=median(aaz[locid])
      mlow=quantile(aaz[locid], 0.25)
      mhi=quantile(aaz[locid], 0.75)
      error.bar( ain$T1+winaz/2, mdazT1 ,mlow, mhi, incr=FALSE, add=TRUE)

      segments( ain$T1, mdazT1,   ain$T1+winaz , mdazT1 , col=3)
    }
 if( ain$T2 > 0 ) 
    {
         winaz=40*ain$dt

      locid=wex>ain$T2&wex<(ain$T2+winaz)  
      mdazT2=median(aaz[locid])
      segments( ain$T2, mdazT2,   ain$T2+winaz , mdazT2 , col=3)
      mlow=quantile(aaz[locid], 0.25)
      mhi=quantile(aaz[locid], 0.75)
      error.bar( ain$T2+winaz/2, mdazT2 ,mlow, mhi, incr=FALSE, add=TRUE)
    }


}
########
 
	   
Letlabs=paste("(", LETTERS,")", sep="")
	   
letlabs=paste("(", letters,")", sep="")
	   
##### source("/home/lees/Progs/R=stuff/Part.Mo.R")

## plot(1:10, 1:10)

## letter.it(1,1)
## letter.it(1,2)
## letter.it(1,3)
## letter.it(1,4)
	   

###########################################
###########################################
###########################################
##### source("/home/lees/Progs/R_stuff/Part.Mo.R")

grotseis<-function(ang, flip=FALSE)
{
  if(missing(flip)) { flip = FALSE }
                                        # angle is in degrees
  a=ang*pi/180
  if(flip)
    {
      f =-1;
    }else
  {
    f = 1;
  }
                                        #  the minus 1 on the vertical is for flipping it.
  rot=matrix(c(f, 0, 0, 0, cos(a), sin(a), 0, -sin(a), cos(a)), ncol=3)

  return(rot)

}
###########################################
read3comp<-function(len, shift, show.it, man.pick)
{
    
  ascin<<-scan(file="asc.info", list(pfil="",id="",sec=0,sta="",comp="",n=0, dt=0, p=0, s=0, evla=0, evlo=0, evel=0, stla=0, stlo=0,stel=0, az=0, T1=0, T2=0))
  nn=length(ascin$comp)
  ascd1=scan(file="asc.data")
  angd=coso.sta$rot[match(ascin$sta[1], coso.sta$sta)]
  rmat=grotseis(angd)
  ascd<<-matrix(ascd1,ncol=nn,nrow=ascin$n[1]) %*% rmat
  #  this is to rotate to N-S   E-W  the angles are provided by Joydeep's program
					#   azi(len,shift)
  if(show.it==1) a3<<-see3comp(man.pick)
}

POL.AZ<-function(Ofile)
{
  dev.set(which=2) 
  tem=read3comp(100,10, 1, 0)
  #locator(1)
  dev.set(which=2) 
  woz=Cazi(a3, 20, 1, 0.1)
  dev.set(which=3) 			
  gaz=mgetaz(woz, Ofile)
#  dev.set(which=2) 
  p=locator(1)
					# locator(1)
}

