#######################
####  source("/home/lees/Progs/R_stuff/RAYSHADE.R")


####  source("RAYSHADE.R"); save.image()




#####  programs for converting models into rayshade format
DEG2RAD =  0.017453293
RAD2DEG = 57.295778667
PI     =   3.141592654
PIO2    = 1.570796327
SQRT2    =    1.414213562
EARTHRAD = 6378.163
ECCEN =0.0033670033
PO180 =0.017453293
#####################################
###########################
################################

LLZ2xyz<-function( lat,  lon, elev)
{
  rad = EARTHRAD+elev;
  
  theta = 1.570796327-0.017453293*lat;
  phi = 0.017453293*lon;
  
  x =    rad * sin(theta) * cos(phi)   ;
  y =    rad * sin(theta) * sin(phi)   ;
  z =    rad * cos(theta);
  return(list(x=x, y=y, z=z))
}

RSsta<-function(LAT, LON, Z)
  {
    pts=LLZ2xyz(LAT, LON, Z)
    

    
  }


#####################################
###########################
################################


RSleesmap<-function(MAP, LIM=c(-180, -90, 180, 90),  MAPfilers="MAP.RS")
{
  
  if(missing(LIM)) { LIM=c(min(MAP$POINTS$lon), min(MAP$POINTS$lat), max(MAP$POINTS$lon), max(MAP$POINTS$lat))  }
  if(missing(MAPfilers)) {  MAPfilers="MAP.RS" }
###  determine stroke inclusion
  
###  (x2>=x3)&&(x4>=x1)&& (y2>=y3)&&(y4>=y1)
  
  y1 = MAP$STROKES$LAT1
  y2 = MAP$STROKES$LAT2
  x1 = MAP$STROKES$LON1
  x2 = MAP$STROKES$LON2
  
  y3 = LIM[2]
  y4 = LIM[4]
  x3 = LIM[1]
  x4 = LIM[3]
  
  fence1=-2.0
  fence2=0.0
  
  OUT = y1>=y4 | x1>=x4 | y2 <= y3 | x2 <= x3
  
  IN = which(!OUT)
  
###
  
  Kstroke = length(MAP$STROKES$num)
#### 
  write( file=MAPfilers, "#define mapz1 6373" )

write( file=MAPfilers, "#define mapz2 6371", append=TRUE )
  write(file=MAPfilers,"name MAP", append=TRUE)
  write(file=MAPfilers,"list", append=TRUE)
  
  for(i in IN)
    {
      
      
      j1 = MAP$STROKES$index[i]+1
      j2 = j1+MAP$STROKES$num[i]-1
      
      
      if(MAP$STROKES$style[i]==2)
        {
          fzee = 0
          MP1 = LLZ2xyz(MAP$POINTS$lat[j1:j2], MAP$POINTS$lon[j1:j2], fence1)
          
          MP2 = LLZ2xyz(MAP$POINTS$lat[j1:j2], MAP$POINTS$lon[j1:j2], fence2)
          
          K = length(MP1$x)
          
          mp1 = paste(sep=' ', "poly", MP1$x[1:(K-1)], MP1$y[1:(K-1)], MP1$z[1:(K-1)])
          mp2 = paste(sep=' ', MP1$x[2:(K)], MP1$y[2:(K)], MP1$z[2:(K)])
          
          mp3 = paste(sep=' ', MP2$x[2:(K)], MP2$y[2:(K)], MP2$z[2:(K)])
          mp4 = paste(sep=' ', MP2$x[1:(K-1)], MP2$y[1:(K-1)], MP2$z[1:(K-1)])
          
          write(file=MAPfilers, paste(sep="\n", mp1, mp2,mp3, mp4), append=TRUE)
          
          
          
        }
      
      
      ##  locator()
      
    }
  write(file=MAPfilers,"end", append=TRUE)
  write(file=MAPfilers,"object Black_Noshadow MAP", append=TRUE)
  write(file=MAPfilers,"", append=TRUE)
  
}
#####################################
###########################
################################


RSsta<-function(INLL=1, filename="LL.sta")
{
if(missing(filename)) 
{
	LL = INLL
}
if(missing(INLL)) 
{

LL = scan(file=filename, list(nam="", lat=0, lon=0, z=0))
}

P = LLZ2xyz(LL$lat, LL$lon, LL$z)

bsiz = .25/4;

stafilers="STA.RS"
stars = paste(sep=' ', "box",P$x-bsiz, P$y-bsiz, P$z, P$x+bsiz, P$y+bsiz, P$z-bsiz)

write(file=stafilers,"name STAS")
write(file=stafilers,"list", append=TRUE)

write(file=stafilers,stars, append=TRUE)

write(file=stafilers,"end", append=TRUE)
write(file=stafilers,"object Green STAS", append=TRUE)
write(file=stafilers,"", append=TRUE)



}

#####################################
###########################
################################

RSvolc<-function(INLL=1, filename="LL.sta")
{
if(missing(filename)) 
{
	LL = INLL
}
if(missing(INLL)) 
{

LL = scan(file=filename, list(nam="", lat=0, lon=0, z=0))
}

VOL = scan(file="LL.sta", list(nam="", lat=0, lon=0, z=0))

volcfilers="VOLC.RS"


write(file=volcfilers,"#define vrad1 10.0")
write(file=volcfilers,"#define vrad2 5.0", append=TRUE)
write(file=volcfilers,"#define vheight 7.0 ", append=TRUE)
write(file=volcfilers,"#define vheight2 3.5 ", append=TRUE)

write(file=volcfilers,"name VOLCS", append=TRUE)
write(file=volcfilers,"list", append=TRUE)

fzee = 0.0;
VP1 = LLZ2xyz(VOL$lat, VOL$lon, fzee)
vols1 = paste(sep=' ', "cone  vrad1",VP1$x, VP1$y, VP1$z)

  fzee = -7.0;
VP2 = LLZ2xyz(VOL$lat, VOL$lon, fzee)
vols2 = paste(sep=' ', "  vrad2",VP2$x, VP2$y, VP2$z)

fzee = -3.5;
VP3 = LLZ2xyz(VOL$lat, VOL$lon, fzee)
vols3 = paste(sep=' ', "cone  vrad2",VP3$x, VP3$y, VP3$z, "0.0", VP2$x, VP2$y, VP2$z)


write(file=volcfilers, paste(sep="\n", vols1, vols2,vols3), append=TRUE)

write(file=volcfilers,"end", append=TRUE)
write(file=volcfilers,"object Gold_Metalic VOLCS", append=TRUE)
write(file=volcfilers,"", append=TRUE)

}
################################

RSeqs<-function(filename="msh.erupt.LLZ")
{

EQ = scan(file=filename  , list(lat=0, lon=0, z=0))

EQfilers="EQ.RS"


write(file=EQfilers,"name EQS")
write(file=EQfilers,"list", append=TRUE)
EP1 = LLZ2xyz(EQ$lat, EQ$lon, -EQ$z)

EQrs = paste(sep=' ', "sphere .1", EP1$x, EP1$y, EP1$z)

write(file=EQfilers,"name EQS")
write(file=EQfilers,"list", append=TRUE)
write(file=EQfilers, EQrs, append=TRUE)

write(file=EQfilers,"end", append=TRUE)
write(file=EQfilers,"object Red EQS", append=TRUE)
write(file=EQfilers,"", append=TRUE)

}
################################
#####################################
###########################
################################


RSsetup<-function()
{

LLcen = XY.GLOB(mean(MOD$x) ,mean(MOD$y) )


LLcen$z = -mean(MOD$D)
lookp = LLZ2xyz(LLcen$lat, LLcen$lon, LLcen$z)

srad = max(max(x), max(y))/110


## EYE = LLcen
## eyep = LLZ2xyz(EYE$lat, EYE$lon, EYE$z)

eyep =list(x=lookp$x,y=lookp$y-50,z=lookp$z+20)

RAYOUT="TESTHEL.raysh"


write(file=RAYOUT,paste(sep=" ", "eyep ", eyep$x, eyep$y,eyep$z))

write(file=RAYOUT,paste(sep=" ","up  0 0 1"), append=TRUE)

write(file=RAYOUT, paste(sep=" ", "lookp ", lookp$x,lookp$y,lookp$z), append=TRUE)

write(file=RAYOUT, paste(sep=" ","fov      45.000     45.000"), append=TRUE)
write(file=RAYOUT, paste(sep=" ","screen        700       700"), append=TRUE)
write(file=RAYOUT, paste(sep=" ","light 1.2 point", lookp$x+100,lookp$y-100,lookp$z-50), append=TRUE)
write(file=RAYOUT, paste(sep=" ","light 0.7 point", lookp$x-100,lookp$y-100,lookp$z-50), append=TRUE)


write(file=RAYOUT,"noshadow", append=TRUE)
write(file=RAYOUT,paste(sep="" , "background 0.4 0.4 0.5"), append=TRUE)

write(file=RAYOUT, "#include \"colors_def\" ", append=TRUE)

write(file=RAYOUT, "#include \"BLOBS.RS\" ", append=TRUE)
write(file=RAYOUT, "#include \"EQ.RS\" ", append=TRUE)
write(file=RAYOUT, "#include \"STA.RS\" ", append=TRUE)




}
