############  functions for performing cross correlations in R (splus)
###  source("/home/lees/Progs/R_stuff/XCOR.R")
###
getlim<-function(a1, a2, dt)
{
  xt=1:length(a2)  
  par(mfrow = c(2,1))
  plot(xt, a2, type = 'l')
  plot(xt, a1, type = 'l')
  loc = locator(2)
  round(loc$x)

}
###
##
xchug<-function(a1,a2, lim1, dt,tskip)
{

  Ilim = a1[lim1[1]:lim1[2]]
  par(mfrow=c(1,1))
  plot(Ilim, type = 'l')
  print("click in plot")
  locator(1)

  xci = xcrude(Ilim, a1, dt, tskip)
  abline(v=dt*lim1 )
  locator(1)
  print("click in plot")
  xcs = xcrude(Ilim, a2, dt, tskip)
  abline(v=dt*lim1)
  xTIM  = dt*seq(0,length(a1))
  xtims = xTIM[!is.na(xci)]
  ti = xtims[xci[!is.na(xci)]==max(xci[!is.na(xci)])]
  xtims = xTIM[!is.na(xcs)]
  tseis = xtims[xcs[!is.na(xcs)]==max(xcs[!is.na(xcs)])]

  DELT = tseis-ti
  print(paste("Delta T =", DELT))
  if(is.na(DELT))
    {
      print(paste("tseis =", tseis, " ti =", ti))
    }
  return(DELT)

}
###
##
xchug1<-function(i4, s4, lim1, dt, tskip)
{
  lim1 =  getlim(i4, s4, dt)
  xchug(i4, s4, lim1, dt, tskip)
}

###
###
xcrude<-function(a1, a2, dt, tskip)
{
                                        #  a1, a2, = time series
                                        #   dt = sam,ple rate in seconds
                                        #    tskip in seconds
                                        # b1 = ts(a1, deltat=dt)
                                        # b2 = ts(a2, deltat=dt)
  n1 = length(a1)
                                        #  here make sure n1 is even
  e1 = 2*floor(n1/2)

  A1 = a1[1:e1]-mean(a1[1:e1])
  n1 = length(A1)
  V1 = var(A1)

                                        # par(mfrow = c(3,1))

  n2 = length(a2)

  kn1 = floor(n1/2)

  skip = round(tskip/dt)
  nn = round(n2/skip)


  mbeg = kn1+1
  mend = n2-kn1-1
  m = seq(mbeg, mend, by=skip)

  s1 = rep(NA, n2)
  for( i in m)
    {
      k1 = i-kn1
      k2 = i+kn1-1


      D2 = a2[k1:k2]-mean(a2[k1:k2])

      V2 = var(D2)
      s1[i] = (sum(D2*A1)/sqrt(V1*V2)/n1)
    }

  xt =  dt* c(0:(n2-1))
                                        #  plot(xt, s1, type = 'l')

  par(mfrow = c(2,1))
  
  par(mai=c(0.0, .7, 0.1, 0.5) )
  plot(xt, a2, ,axes=F, xlab="", type = 'l')
  axis(1,tck=.03,lab=F)
  axis(2, las=1)
  box()
  par(mai=c(0.5, .7, 0.0, 0.5) )
  plot(xt, s1, type = 'p', ylim=c(-1,1))

  s2 = s1
  s2[is.na(s1)] = min(s1[!is.na(s1)])

  ti = xt[s2==max(s2)]

  text(ti, max(s2), labels="MAX", adj=c(0, 0) )


  s1
}
###################################################################
###  source("/home/lees/Progs/R_stuff/XCOR.R")

xcor2<-function(a1, a2, DT, PLOT=FALSE, LAG=100)
{
  if(missing(PLOT)) { PLOT=FALSE }

  n1 = length(a1)
  n2 = length(a2)
  n = max(c(n1,n2))

  ts1 = c(a1-mean(a1), rep(0,n-n1))
  ts2 = c(a2-mean(a2), rep(0,n-n2))
  
  b1 = ts(ts1, deltat=DT)
  b2 = ts(ts2, deltat=DT)
  
  if(PLOT==TRUE)
    {
      par(mfrow = c(3,1))  

    }
  if(missing(LAG)) { LAG=round(n/4) }

  xc =ccf(b1, b2, lag.max = LAG , type ="correlation",  plot = FALSE )
  
  if(PLOT==TRUE)
    {
      EX = DT*(1:n)
      plot(DT*(1:n), ts1, xlab="time, s", type = 'l')
      plot(DT*(1:n), ts2, xlab="time, s", type = 'l')
      k = which.max(ts2)
      mlag = xc$lag[which.max(xc$acf)]
      gex = k+mlag/DT
      if(gex>0 & gex<=n)
        {
          segments(EX[k], ts2[k], EX[gex], ts2[k], col=rgb(1,0,0))
          abline(v=EX[gex], col=rgb(1,0,0), lty=2)
        }
      else
        {
          segments(EX[n/2], ts2[k], EX[(n/2)+mlag/DT], ts2[k], col=rgb(1,0,0))
        }
      plot(xc)
      points(xc$lag[which.max(xc$acf)], max(xc$acf), col=2)
    }
  return(xc)
}
###################################################################
###  source("/home/lees/Progs/R_stuff/XCOR.R")

xcor3<-function(a1, a2, DT, PLOT=FALSE)
{
  if(missing(PLOT)) { PLOT=FALSE }
  b1 = ts(a1, deltat=DT)
  b2 = ts(a2, deltat=DT)

  n1 = length(a1)
  n2 = length(a2)
  if(PLOT)
    {
      par(mfrow = c(3,1))  
      plot(DT*(1:n1), a1, type = 'l')
      plot(DT*(1:n2), a2, type = 'l')
    }
  xc = ccf(b1, b2, lag.max = n1+n2 , type ="correlation",  plot = PLOT )
  return(xc)

}

#############################################################
#############################################################
#############################################################
###  source("/home/lees/Progs/R_stuff/XCOR.R")


JXCOR<-function(dat, DT, PLOT=FALSE, PIC=FALSE)
{
######  create a correlation matrix with a matrix of signals
  ## DT = delta time (sample interval), s
  ##  dat = matrix of time series
  ##        matrix is NxM  where N = number of traces, M=number of samples/trace

  if(missing(PLOT)) { PLOT=FALSE }
  if(missing(PIC)) { PIC=FALSE }
  
  dims = dim(dat)
  n = dims[2]
  ex = DT*seq(0,dims[1]-1)

  LAG = matrix(ncol=n, nrow=n)
  COR = matrix(ncol=n, nrow=n)
                                        #   first plot the signals and determine an xlim
  if(PLOT==TRUE)
    {
      par(mfrow=c(n,1))
      par(mai=c(.1, .5 , .1, .5))
      for(i in 1:n)
        {
          plot(ex,dat[,i], type='l',main=i)
          Sys.sleep(0.5)
        }
    }

  if(PIC==TRUE)
    {
      print(paste(sep=' ',"Click twice in figure to select a window"))
      xa = locator(2)
      flag = ex>xa$x[1]&ex<xa$x[2]
    }
                                        #   do correlations
  for(i in 1:(n-1))
    {
      LAG[i,i] = 0.0
      COR[i,i] = 1.0
      
      
      for(j in i:(n))
        {
          xc = xcor2(dat[,i], dat[,j], DT, PLOT=PLOT)
          xlag = xc$lag[which.max(xc$acf)]
          LAG[i,j] = xlag
          COR[i,j] = max(xc$acf)
          COR[j,i] = COR[i,j] 
          
        }

    }
  
  LAG[n,n] = 0.0
  COR[n,n] = 1.0
  if(PLOT==TRUE)
    {
      par(mfrow=c(1,1))
    }
  
  return(list(LAG=LAG, COR=COR) )
}
#############################################################
#############################################################
#############################################################

###  source("/home/lees/Progs/R_stuff/XCOR.R")
PLXCOR<-function(dat, DT, lags, v)
{
                                        #  plot the traces in vector v using the lags from the
                                        #  correlation matrix lags
                                        # DT = delta time (sample interval), s
                                        #  dat = matrix of time series
  
  dims = dim(dat)
  n = dims[2]
  kv = length(v)
  ex = DT*seq(0,dims[1]-1)
                                        #   first plot the signals and determine an xlim
  par(mfrow=c(kv,1))
  par(mai=c(.1, .5 , .1, .5))


  
  nd = dat[ , v]
  exd = dat[ , v]
  for(i in 1:kv )
    {
      plot(ex,dat[,v[i]], type='l')
      exd[,i] = ex+lags[1,v[i]]
    }

  locator(1)
  par(mfrow=c(1,1))
  matplot(exd, nd, type='l')
  
  
}
#############################################################
#############################################################
#############################################################

###  source("/home/lees/Progs/R_stuff/XCOR.R")
getphaselag<-function(y1,y2, DT, PLOT=FALSE)
  {

############ dyn.load("/home/lees/Progs/Rc/MTAPSRC.so")
if(missing(PLOT)) { PLOT=FALSE }

MTS1 =   mtapspec(y1 , DT , klen=4096,  MTP=list(kind=2,nwin=5, npi=3,inorm=0)  )
MTS2 =   mtapspec(y2 , DT , klen=4096,  MTP=list(kind=2,nwin=5, npi=3,inorm=0)  )

#####names(MTS1)
#####dim(MTS1$Rspec)
AA = MTS1$Rspec*MTS1$Rspec+MTS1$Ispec*MTS1$Ispec
BB = MTS2$Rspec*MTS2$Rspec+MTS2$Ispec*MTS2$Ispec
ABr = MTS1$Rspec*MTS2$Rspec+MTS1$Ispec*MTS2$Ispec
ABi = MTS1$Rspec*MTS2$Ispec-MTS1$Ispec*MTS2$Rspec

aa = apply(AA, 1, sum)
bb = apply(BB, 1, sum)
abre  = apply(ABr, 1, sum)
abim  = apply(ABi, 1, sum)


phase = atan2(abim,abre)

abre = abre / (sqrt(aa) * sqrt(bb));
abim = abim / (sqrt(aa) * sqrt(bb));

cohere = sqrt((abre)^2 + (abim)^2);


###matplot(cbind(y1,y2), type='l', lty=1)

nphase = LocalUnwrap(phase)
###plot(MTS1$freq, nphase)

wgt = (cohere)^2 / (1.0- (cohere)^2 ) ;


###plot(MTS1$freq, cohere)


MOD = lm(nphase[MTS1$freq<20] ~ MTS1$freq[MTS1$freq<20] ,  weights=wgt[MTS1$freq<20])
###plot(MTS1$freq, nphase)
###abline(MOD)
phaselag = MOD$coefficients[2]/(2.0*pi);


par(mfrow=c(2,1))


matplot(cbind(y1,y2))

# plag = locator()

matplot(cbind(y1,lag(y2,floor(phaselag/DT)) ))

###  matplot(cbind(v1,lag(v2,round(abs(diff(plag$x)))) ), type='l', lty=1)



return(phaselag)
  }

#############################################################

###  source("/home/lees/Progs/R_stuff/XCOR.R")


GLUEseisMAT<-function(GFIL)
      {
	###  find duplicated stations in a matrix and
        ###   fill in the traces that are continuations
	### return the new matrix and the vector duplicates
	dot = which(duplicated(GFIL$KNOTES))
	G = GFIL$JMAT
	for(i in 1:length(dot))
	  {
	    w = which(!is.na(match(GFIL$KNOTES, GFIL$KNOTES[dot[i]])))
	    
	    a = G[,w[1]]
	    a[!is.na(G[,w[2]])] = G[!is.na(G[,w[2]]), w[2]]
	    G[,w[1]]  = a 
	    
	  }
	invisible(list(JMAT=G, dpl=dot) )
	
      }

GLUEseisSTR<-function(GFIL)
      {
	###  find duplicated stations in a matrix and
        ###   fill in the traces that are continuations
	### return the new matrix and the vector duplicates
	dot = which(duplicated(GFIL$KNOTES))
	G = GFIL$JSTR
	for(i in 1:length(dot))
	  {
	    w = which(!is.na(match(GFIL$KNOTES, GFIL$KNOTES[dot[i]])))
	    
	    a = G[[w[1]]]
            b = G[[w[2]]]
	    a[!is.na(b)] = b[!is.na(b)]

            
	    G[[w[1]]]  = a 
	    
	  }
	invisible(list(JSTR=G, dpl=dot) )
	
      }



#############################################################
#############################################################
#############################################################

###  source("/home/lees/Progs/R_stuff/XCOR.R")

KARCOR<-function(PIXF, FL = 1/50,  FH = 5,  BEF=2, AFT=8, PLOT=FALSE, ORD=NULL)
{
  if(missing(FL)) { FL = 1/50 }
   if(missing(FH)) { FH = 5 }
   if(missing(PLOT)) { PLOT=FALSE }
  if(missing(BEF)) { BEF=2 }
   if(missing(AFT)) { AFT=8 }
   if(missing(ORD)) { ORD=NULL }


  INPUTF = deparse(substitute(PIXF))

  
    OUT = as.list(1:length(PIXF))    
  
  for(i in 1:length(PIXF))
    {
      ## readline("hit the enter key")
      
      fname  = PIXF[[i]]$name 
      GFIL = KAR.Gdat(fname, DIR)
      DT = GFIL$dt
      ##   PLOT.MATN(GFIL$JMAT[,GFIL$ok], DT=GFIL$dt, notes=GFIL$KNOTES[GFIL$ok], COL=GFIL$pcol[GFIL$ok])
      if(PLOT)
        {
          PLOT.MATN(GFIL$JMAT,  dt=GFIL$dt, notes=GFIL$KNOTES, COL=GFIL$pcol)
          locator()
        }
      G = GLUEseis(GFIL)
      GFIL$JMAT = G$JMAT

      if(!is.null(ORD))
        {
          GFIL$STNS


        }
      
      if(length(PIXF[[i]]$w1$x)>0)
        {
          jj = GFIL$COMPS==4
          
          jj[G$dpl] = FALSE
          
          
          if(PLOT)
            {
              PLOT.MATN(GFIL$JMAT[,jj], dt=GFIL$dt, notes=GFIL$KNOTES[jj], COL=GFIL$pcol[jj])
              abline(v=PIXF[[i]]$w1$x)
              locator()
            }
          
          tim = GFIL$dt*seq(from=0,to=length(GFIL$JMAT[,1])-1)
          win =  list(x=c(PIXF[[i]]$w1$x[1]-BEF, PIXF[[i]]$w1$x[1]+AFT))
          tflag = tim>=win$x[1]&tim<=win$x[2]


          VMAT = GFIL$JMAT[tflag,jj]
          FMAT = VMAT
          vnotes = GFIL$KNOTES[jj]
          
          dm = dim(VMAT)
          for(j in 1:dm[2])
            {
              y = VMAT[,j]
              fy = butfilt(y,FL, FH , dt, "BP" , "BU" )
              FMAT[,j] = fy
              ##  vnotes[j] = anotes[j]
              
            }
          if(PLOT)
            {
              PLOT.MATN(FMAT, dt=dt, notes=vnotes)
              title(main="Filtered Data")
            }
          JX = JXCOR(FMAT, dt, PLOT = FALSE, PIC = FALSE)
          OUT[[i]] = list(stas=GFIL$KNOTES[jj], COR=JX$COR, LAG=JX$LAG, fname=PIXF[[i]]$name)
          if(PLOT)
            {
              tem = FMAT[,1]
              ix = which.max(tem)
              abline(v=ix*dt)
              xlags = ix*dt-JX$LAG[1,]
              nx = length(xlags)

              pixplotter(list(x=xlags[2:nx], y=nx-(2:nx) ), COL=4, Yranges=nx)

              ##  abline(v=xlags[2:length(xlags)], col=2)
               locator()
            }
          print(paste(sep=' ', GFIL$KNOTES[jj],JX$LAG[1,]))
        }
    }
      
  attr(OUT, "filt") <- c(FL, FH)
  attr(OUT, "INFILE") <- INPUTF
  attr(OUT, "DIR") <- DIR
  

  invisible(OUT)

}
