#######
####  
######  source("/home/lees/Progs/R_stuff/circ.R")

## Modified March 5, 2002, (JML) Thu Jul 10 16:23:09 EDT 2003


rose.jml <- function(x, bins, main = "", prop = 1, pts = FALSE,
                     cex = 1, pch = 16, dotsep = 40, shrink = 1, LABS=LABS)
{
  ###  x = angles
  ###  bins = 
  if(missing(LABS)) { LABS = c("90", "270", "180", "0") }
                                        #   LABS = c("N", "S", "W", "E")
  x <- x %% (2 * pi)
  plot(cos(seq(0, 2 * pi, length = 1000)),
       sin(seq(0, 2 * pi, length = 1000)),
       axes = FALSE, xlab = "", ylab = "",
       main = main, type = "l", asp=1, xlim = shrink * c(-1, 1), ylim = shrink* c(-1, 1))
  lines(c(0, 0), c(0.95, 1))
  text(0.0, 0.95, LABS[1], pos=1, cex = 1.1)
  lines(c(0, 0), c(-0.95, -1))
  text(0.0, -0.95, LABS[2], pos=3, cex = 1.1)
  lines(c(-1, -0.95), c(0, 0))
  text(-0.95, 0, LABS[3], pos=4, cex = 1.1)
  lines(c(0.95, 1), c(0, 0))
  text(0.95, 0, LABS[4], pos=2, cex = 1.1)
  points(0, 0, cex = 1)
  n <- length(x)
  freq <- c(1:bins)
  arc <- (2 * pi)/bins
  for(i in 1:bins) {
    freq[i] <- sum(x <= i * arc & x > (i - 1) * arc)
  }
  rel.freq <- freq/n
  radius <- sqrt(rel.freq) * prop
  sector <- seq(0, 2 * pi - (2 * pi)/bins, length = bins)
  mids <- seq(arc/2, 2 * pi - pi/bins, length = bins)
  index <- cex/dotsep
  for(i in 1:bins) {
    if(rel.freq[i] != 0) {
      lines(c(0, radius[i] * cos(sector[i])), c(0, radius[i] * sin(sector[i])))
      lines(c(0, radius[i] * cos(sector[i] + (2 * pi)/bins)),
            c(0, radius[i] * sin(sector[i] + (2 * pi)/bins)))
      lines(c(radius[i] * cos(sector[i]), radius[i] * cos(sector[i] + (2 * pi)/bins)),
            c(radius[i] * sin(sector[i]), radius[i] * sin(sector[i] + (2 * pi)/bins)))
      if(pts == TRUE) {
        for(j in 0:(freq[i] - 1)) {
          r <- 1 + j * index
          x <- r * cos(mids[i])
          y <- r * sin(mids[i])
          points(x, y, cex = cex, pch = pch)
        }
      }
    }
  }
}
##############################################################
####  
######  source("/home/lees/Progs/R_stuff/circ.R")

Krose.jml <- function(x, wts=1, bins=36,rscale=1,  main = "", prop = 1, pts = FALSE,
                      cex = 1, pch = 16, dotsep = 40, shrink = 1, LABS=LABS, plot=TRUE) {
   if(missing(wts)) {wts=rep(1, length(x)) }
   if(missing(bins)) {bins=36 }
      if(missing(prop)) {prop=1 }
       if(missing(pts)) {pts=FALSE }
      if(missing(cex)) {cex=1 }
      if(missing(pch)) {pch=16 }
      if(missing(dotsep)) {dotsep=40 }
      if(missing(shrink)) {shrink=1 }
   if(missing(LABS)) { LABS = c("90", "270", "180", "0") }
         if(missing(plot)) {plot=TRUE }
   if(missing(rscale)) { rscale=1 }
   
                                        ##   LABS = c("N", "S", "W", "E")
  x <- x %% (2 * pi)

    n <- length(x)
  freq <- c(1:bins)
   flens  <- c(1:bins)
  arc <- (2 * pi)/bins
  for(i in 1:bins)
    {
      alocs = (x <= i * arc & x > (i - 1) * arc)
      freq[i] <- sum(wts[alocs])
      flens[i] <- length(wts[alocs])

      
    }

   
   tot = sum(wts)

   if(rscale==1)
     {
       rel.freq <- freq/tot
     }
   if(rscale==2)
     {
       rel.freq <- freq
       rel.freq[flens>0] <- freq[flens>0]/flens[flens>0]
     }

   
   
   radius <- sqrt(rel.freq) * prop
  #  radius <- (rel.freq) * prop
  #  radius <- log(rel.freq) * prop
  # radius <- log(rel.freq) * prop

   
  sector <- seq(0, 2 * pi - (2 * pi)/bins, length = bins)
  mids <- seq(arc/2, 2 * pi - pi/bins, length = bins)
  index <- cex/dotsep

   if(plot)
     {
       plot(cos(seq(0, 2 * pi, length = 1000)),
            sin(seq(0, 2 * pi, length = 1000)),
            axes = FALSE, xlab = "", ylab = "",
            main = main, type = "l", asp=1, xlim = shrink * c(-1, 1), ylim = shrink* c(-1, 1))
       
       
       lines(c(0, 0), c(0.95, 1))
       text(0.0, 0.95, LABS[1], pos=1, cex = 1.1)
       lines(c(0, 0), c(-0.95, -1))
       text(0.0, -0.95, LABS[2], pos=3, cex = 1.1)
       lines(c(-1, -0.95), c(0, 0))
       text(-0.95, 0, LABS[3], pos=4, cex = 1.1)
       lines(c(0.95, 1), c(0, 0))
       text(0.95, 0, LABS[4], pos=2, cex = 1.1)
       points(0, 0, cex = 1)
       
       for(i in 1:bins) {
         if(rel.freq[i] != 0)
           {
             
                 x = c( 0, radius[i] * cos(sector[i]) , radius[i] * cos(sector[i] + (2 * pi)/bins), 0)
                 
                 y = c( 0, radius[i] * sin(sector[i]), radius[i] * sin(sector[i] + (2 * pi)/bins), 0)

                 lines(x,y)
                 
             
             if(pts == TRUE)
               {
                 for(j in 0:(freq[i] - 1))
                   {
                     r <- 1 + j * index
                     x <- r * cos(mids[i])
                     y <- r * sin(mids[i])
                     points(x, y, cex = cex, pch = pch)
                   }
               }
           }
       }
     }
   
   invisible(list(bins=bins, n=n,  wmax=max(freq), radius=radius, sector=sector))
   
   
 }
##############################################################
####  
######  source("circ.R"); save.image()

prose<-function(kros, ex=0, why=0, main = "", add=FALSE, prop = 1, perim=TRUE, style=1,
                      cex = 1, pch = 16, shrink = 1, LABS=LABS, plot=TRUE, col="gray", bord="black") {

      if(missing(ex)) { ex=0}
      if(missing(why)) { why=0}
       
        if(missing(add)) {add=FALSE }
      if(missing(prop)) {prop=1 }
     if(missing(perim)) {perim=FALSE }
     if(missing(style)) {style=1 }
        
      if(missing(cex)) {cex=1 }
      if(missing(pch)) {pch=16 }
     
      if(missing(shrink)) {shrink=1 }
   if(missing(LABS)) { LABS = c("90", "270", "180", "0") }
         if(missing(plot)) {plot=TRUE }
          if(missing(col)) { col="gray" }
          if(missing(bord)) { bord="black" }
   
                                        ##   LABS = c("N", "S", "W", "E")

   bins = kros$bins
   sector = kros$sector
   radius = prop*kros$radius
      radius[is.na(radius)] = 0
   
  freq <- c(1:bins)
  arc <- (2 * pi)/bins

  mids <- seq(arc/2, 2 * pi - pi/bins, length = bins)
  

   if(plot)
     {
       if(add==FALSE)
         {
           plot(cos(seq(0, 2 * pi, length = 1000)),
                sin(seq(0, 2 * pi, length = 1000)),
                axes = FALSE, xlab = "", ylab = "",
                main = main, type = "l", asp=1, xlim = shrink * c(-1, 1), ylim = shrink* c(-1, 1))
         }
       else
         {

         }
       if(perim==TRUE)
         {

           lines(cos(seq(0, 2 * pi, length = 1000)), sin(seq(0, 2 * pi, length = 1000)))
           lines(c(0, 0), c(0.95, 1))
           text(0.0, 0.95, LABS[1], pos=1, cex = 1.1)
           lines(c(0, 0), c(-0.95, -1))
           text(0.0, -0.95, LABS[2], pos=3, cex = 1.1)
           lines(c(-1, -0.95), c(0, 0))
           text(-0.95, 0, LABS[3], pos=4, cex = 1.1)
           lines(c(0.95, 1), c(0, 0))
           text(0.95, 0, LABS[4], pos=2, cex = 1.1)
           points(0, 0, cex = 1)
         }
       if(style==1)
         {
           for(i in 1:bins) {
             if(radius[i] != 0)
               {
                

                 x = ex+c( 0, radius[i] * cos(sector[i]) , radius[i] * cos(sector[i] + (2 * pi)/bins), 0)
                 
                 y = why+c( 0, radius[i] * sin(sector[i]), radius[i] * sin(sector[i] + (2 * pi)/bins), 0)

                 # lines(x,y)
                 
               polygon(x,y, col=col, border = bord, lwd=.5)
                 
               }
             
             
           }
         }
       if(style==2)
         {
           x = radius * cos(sector)
           y = radius * sin(sector)
           polygon(x,y, col=col, border = bord)
         }


       
     }
   
   
 }
##############################################################
####  
######  source("/home/lees/Progs/R_stuff/circ.R")

######  source("/home/lees/Progs/R_stuff/circ.R")

SPLrose.jml <- function(x, wts=1, tags=NULL, bins=36,rscale=1,  main = "", prop = 1, pts = FALSE,
                      cex = 1, pch = 16, dotsep = 40, shrink = 1, LABS=LABS, plot=TRUE)
{
  ###  x = set of angles in radians, counter clockwise, 0=EAST
  ###  wts = set of weights for each mesurement
  ###  bins = number of bins
  ###  rscale
  
   if(missing(wts)) {wts=rep(1, length(x)) }
   if(missing(bins)) {bins=36 }
      if(missing(prop)) {prop=1 }
       if(missing(pts)) {pts=FALSE }
      if(missing(cex)) {cex=1 }
      if(missing(pch)) {pch=16 }
      if(missing(dotsep)) {dotsep=40 }
      if(missing(shrink)) {shrink=1 }
   if(missing(LABS)) { LABS = c("90", "270", "180", "0") }
         if(missing(plot)) {plot=TRUE }
   if(missing(rscale)) { rscale=1 }
    if(missing(tags)) { tags=NULL }
  
     ####   LABS = c("N", "S", "W", "E")
   ## make sure all angles are between 0 and 2*pi
  x <- x %% (2 * pi)


   
    n <- length(x)
   xbin = rep(NA, n)
   
  freq <- c(1:bins)
   flens  <- c(1:bins)
  arc <- (2 * pi)/bins

   ####  count number of hits per bin
   
  for(i in 1:bins)
    {
      alocs = (x <= i * arc & x > (i - 1) * arc)
      freq[i] <- sum(wts[alocs])
      flens[i] <- length(wts[alocs])
      xbin[alocs] = i
    }

   
   tot = sum(wts)

   if(rscale==1)
     {
       rel.freq <- freq/tot
     }
   if(rscale==2)
     {
       rel.freq <- freq
       rel.freq[flens>0] <- freq[flens>0]/flens[flens>0]
     }

   
   
   radius <- sqrt(rel.freq) * prop
   
  #  radius <- (rel.freq) * prop
  #  radius <- log(rel.freq) * prop
  # radius <- log(rel.freq) * prop

   
  sector <- seq(0, 2 * pi - (2 * pi)/bins, length = bins)
  mids <- seq(arc/2, 2 * pi - pi/bins, length = bins)
  index <- (cex/dotsep)

   if(plot)
     {



       
       plot(cos(seq(0, 2 * pi, length = 1000)),
            sin(seq(0, 2 * pi, length = 1000)),
            axes = FALSE, xlab = "", ylab = "",
            main = main, type = "l", asp=1, xlim = shrink * c(-1, 1), ylim = shrink* c(-1, 1))
       
       
       lines(c(0, 0), c(0.95, 1))
       text(0.0, 0.95, LABS[1], pos=1, cex = 1.1)
       lines(c(0, 0), c(-0.95, -1))
       text(0.0, -0.95, LABS[2], pos=3, cex = 1.1)
       lines(c(-1, -0.95), c(0, 0))
       text(-0.95, 0, LABS[3], pos=4, cex = 1.1)
       lines(c(0.95, 1), c(0, 0))
       text(0.95, 0, LABS[4], pos=2, cex = 1.1)
       points(0, 0, cex = 1)
       
       for(i in 1:bins) {

         
         if(rel.freq[i] != 0)
           {
             mx = cos(mids[i])
             my = sin(mids[i])
                 x = c( 0, radius[i] * cos(sector[i]) , radius[i] * cos(sector[i] + (2 * pi)/bins), 0)
                 
                 y = c( 0, radius[i] * sin(sector[i]), radius[i] * sin(sector[i] + (2 * pi)/bins), 0)

                 if(my<0)
                   {
                     pco = 2
                   }
             else
               {
                 pco = 4
               }

             r = 1
             lx <- r * cos(mids[i])
             ly <- r * sin(mids[i])
             segments(0,0, lx,ly, lty=2, col=gray(0.8))
          
                 polygon(x,y, col=pco)
                 
                 lines(x,y)

             nams = tags[xbin==i]

             ##  print(paste(sep=' ', i, length(nams), freq[i]))
             sang = (180*mids[i]/pi)-90
        
             
             if(pts == TRUE)
               {
                 for(j in 0:(freq[i] - 1))
                   {
                     r <- 1 + j * index+0.01
                     x <- r * cos(mids[i])
                     y <- r * sin(mids[i])
                     if(y<0)
                       {
                         pch=15
                       }
                     else
                       {
                         pch =16

                       }
                     # points(x, y, cex = cex, pch = '.', xpd=TRUE)
                     text(x, y, labels=nams[j+1], cex=0.6, xpd=TRUE, srt=sang)

                     
                   }
               }
           }
       }
     }
   
   invisible(list(bins=bins, n=n,  xbin=xbin, wmax=max(freq), radius=radius, sector=sector))
   
   
 }



