cat("sourcing /home/lees/Progs/R_stuff/iscale.R\n")

############
####   source("/home/lees/Progs/R_stuff/iscale.R")


image.SCALE<-function (z, col, x, y = NULL, size = NULL, digits = 2, labels = c("breaks",
    "ranges"), nlab=10)
{
  #  z= values fpr the color scale
  #  x= 
  #  y=
  # col = color palette
    # sort out the location

    n <- length(col)
    if(missing(nlab)) { nlab=n }
 
    
    
    usr <- par("usr")
    mx <- mean(usr[1:2]); my <- mean(usr[3:4])
    dx <- diff(usr[1:2]); dy <- diff(usr[3:4])
    if (missing(x))
        x <- mx + 1.05*dx/2 # default x to right of image
    else if (is.list(x)) {
        if (length(x$x) == 2)
          size <- c(diff(x$x), -diff(x$y)/n)
        y <- x$y[1]
        x <- x$x[1]
    } else x <- x[1]
    if (is.null(size))
        if (is.null(y)) {
          size <- 0.618*dy/n # default size, golden ratio
          y <- my + 0.618*dy/2 # default y to give centred scale
        } else size <- (y-my)*2/n
    
    if (length(size)==1)
        size <- rep(size, 2) # default square boxes
    if (is.null(y))
        y <- my + n*size[2]/2

   print(paste(sep=" ", "nlab=", nlab, "n=", n, "size=", size))

    
    # draw the image scale
    i <- seq(along = col)
    rect(x, y - i * size[2], x + size[1], y - (i - 1) * size[2],
        col = rev(col), xpd = TRUE)
    # sort out the labels
    i = seq(length=nlab)
    
    rng <- range(z, na.rm = TRUE)
    bks <- seq(from = rng[2], to = rng[1], length = nlab + 1)
    bks <- formatC(bks, format="f", digits=digits)
    labels <- match.arg(labels)


    sizeLAB <- 0.618*dy/nlab  # default size, golden ratio
    if (labels == "breaks")
        ypts <- y - c(0, i) * sizeLAB
    else {
        bks <- paste(bks[-1], bks[-(nlab+1)], sep = " - ")
        ypts <- y - (i - 0.5) * sizeLAB
    }
    text(x = x + 1.4 * size[1], y = ypts, labels = bks, adj =
        ifelse(size[1]>0, 0, 1), xpd = TRUE)
} 
############
####   source("/home/lees/Progs/R_stuff/iscale.R")
HOZscale<-function(z, col, units="", SIDE=1, s1=.4, s2=0.95)
  {
    if(missing(units)) { units="" }
    if(missing(SIDE)) {  SIDE=1}
    if(missing(s1)) {     s1=0.4 }
    if(missing(s2)) {     s2=0.95 }

    u = par("usr")
    f = par("pin")

    raty = (u[4]-u[3])/f[2]

    
    dy = (u[4]-u[3])*.05

#     dy = raty*0.25

    
    dx = (u[2]-u[1])*.3
#    LU=list(x=c(u[1]+dx*0.1, u[1]+dx*0.1+dx), y = c(u[3]-2*dy, u[3]-2*dy - dy))

    if(SIDE==1)
      {
        ym = ymarginfo(SIDE=1, s1=s1, s2=s2)

        ## y1 = ym[1]
        
        LU=list(x=c(u[1]+dx*0.1, u[1]+dx*0.1+dx), y = ym)
      }
    else
      {
        ## y1 =u[4]+dy*0.2
        ym = ymarginfo(SIDE=3, s1=s1, s2=s2)
        
        LU=list(x=c(u[1]+dx*0.1, u[1]+dx*0.1+dx), y = ym)
        
      }
    
    ##    print(paste(sep=' ', 'HOZ SCALE:', LU$x[1], LU$y[1], LU$x[2], LU$y[2])) 
   ##   rect(LU$x[1], LU$y[1], LU$x[2], LU$y[2], xpd=TRUE)
    rng = range(z, na.rm = TRUE)
    
    i <- seq(along = col)
    BX = (LU$x[2]-LU$x[1])/length(i)
    x1 =LU$x[1]+(i-1)*BX
    x2 = x1+BX
    y1 = LU$y[1]
    y2 =  LU$y[2]
      
    rect(x1,y1,x2,y2,  col=col, xpd = TRUE, border=-1)
    rlab = paste(sep=" ", format.default(rng[2], digits=3), units)
    text(LU$x[2]+BX, (y1+y2)/2, labels=rlab, adj=0, xpd = TRUE)
    text(LU$x[1]-BX/2,  (y1+y2)/2, labels=format.default(rng[1], digits=3), adj=1, xpd = TRUE)
    rect(LU$x[1], LU$y[1], LU$x[2], LU$y[2], xpd=TRUE)

  }
####   source("/home/lees/Progs/R_stuff/iscale.R")


see.pal<-function(col)
  {
  
    u = par("usr")
    f = par("pin")

    raty = (u[4]-u[3])/f[2]

    
    dy = (u[4]-u[3])*.05


    
    dx = (u[2]-u[1])*.3

    LU=list(x=c(u[1]+dx*0.1, u[1]+dx*0.1+dx), y = c(u[3]-dy*1.5, u[3]-dy*1.5-dy))
  
    
    i <- seq(along = col)
    BX = (LU$x[2]-LU$x[1])/length(i)
    x1 =LU$x[1]+(i-1)*BX
    x2 = x1+BX
    y1 = LU$y[1]
    y2 =  LU$y[2]
      
    rect(x1,y1,x2,y2,  col=col, xpd = TRUE, border=-1)
    

  }
