##########  source("lagwind.R")

lagwind<-function(lag=1,window='uniform')
  {
#	LAGWIND Lag window function
#
#	wind=lagwind(lag,window)
#
#	The lag element window vector is computed from the lag scalar and window function
#	string.  If unspecified, the lag scalar is entered after the prompt from the
#	keyboard.  The window string specifies lag window vector computation, according to:
#
#	window = 'uniform', 'u', or unspecified computes the uniform window
#	       = 'sasaki' or 's' computes the sasaki window
#	       = 'priestley' or 'p' computes the priestley window
#	       = 'parzen' or 'pa' computes the parzen window
#	       = 'hamming' or 'h' computes the hamming window
#	       = 'gaussian' or 'g' computes the gaussian distribution window
#	       = 'daniell' or 'd' computes the daniell window

#	Implemented using MATLAB 5.3.1
#
#	Example:
#
#	 w=lagwind(4,'parzen')
#
#	w =
#
#	    1.0000    0.5556    0.0741         0
#
#	References:
#
#	C. L. Nikias, A. P. Petropulu, Higher-Order Spectra Analysis:  A Nonlinear Signal
#	Processing Framework, PTR Prentice Hall, Englewood Cliffs, NJ, 1993.
#
#	T. S. Rao, M. M. Gabr, An Introduction to Bispectral Analysis and Bilinear Time
#	Series Models, Lecture Notes in Statistics, Volume 24, D. Brillinger, S. Fienberg,
#	J. Gani, J. Hartigan, K. Krickeberg, Editors, Springer-Verlag, New York, NY, 1984.
#
#	Copyright (c) 2000
#	Tom McMurray
#	mcmurray@teamcmi.com

#	assign default input parameters

if(missing(lag)) { lag = 1 }
if(missing(window)) { window='uniform' }

lag1=lag-1;
wind=rep(1,length=lag);

if(window=='uniform')
  {
   wind=rep(1,length=lag);
 }
if(window=='sasaki')
  {
   windlag=seq(from=0,to=lag1)/lag1;
   wind=sin(pi*windlag)/pi+cos(pi*windlag)*(1-windlag);
 }
if(window=='priestley')
  {
   windlag=seq(from=1, to=lag1)/lag1;
   wind=c(1, (sin(pi*windlag)/pi/windlag-cos(pi*windlag))*3/pi/pi/windlag/windlag);
   }   
if(window=='parzen')
  {
   fixlag12=floor(lag1/2);
   fixlag121=fixlag12+1;
   windlag0=seq(from=0, to=fixlag12)/lag1;
   windlag1=1-seq(from=fixlag121, to=lag1)/lag1;
   wind[1:fixlag121]=1-(1-windlag0)*windlag0*windlag0*6;
   wind[(fixlag121+1):lag]=windlag1*windlag1*windlag1*2;
 }   

if(window=='hamming')
  {
   wind=0.54+0.46*cos(pi*(0:lag1)/lag1);
 }   
if(window=='gaussian')
  {
   wind=c(1, erfc(((1:lag1-1)/lag1-0.5)*8/sqrt(2))/2, 0);

   
 }   

if(window=='daniell')
  {
   windlag=seq(from=1, to=lag1)/lag1;
   wind=c(1, sin(pi*windlag)/pi/windlag);
 }   


return(wind)
  }
