###################################################################################
### source("/home/lees/Progs/R_stuff/myakejima.R")
 
##########################################################
#### seeV(MYALL, STA="MKAB", N=4, fl=0.05, fh=2)
#### seeV(MYALL, STA="MKKB", N=4, fl=0.05, fh=2)
#### seeV(MYALL, STA="MKSB", N=4, fl=0.05, fh=2)
#### seeV(MYALL, STA="MKTB", N=6, fl=0.05, fh=2)

####   STA="MKTB"; N=4; fl=0.05; fh=2;
####  prep.cor(MJALL2, MSTAS,MCOMPS )


prep.cor<-function(MJALL2, MSTAS,MCOMPS )
  {
    e1 <<- new.env(TRUE, NULL)

    
    for(m in 1:length(MSTAS))
      {	
        mst = MSTAS[m]

        for(n in 1:length(MCOMPS))
          {
            mcomp = MCOMPS[n]
            mout = paste(sep='.', "XMJ", mst, mcomp)
            why =myak.Xtract(MJALL2, STA=mst, COMP=mcomp, BEF=5, AFT=10, FV=FV , PLT=FALSE)
            assign(mout, why, env=e1)
            print(paste(sep=' ', "****************** DONE:", mst,mcomp))
          }
      
      }
  }

set.cor<-function(allcor, env=e1)
  {

                                        
    a1 = get(allcor[1], env=e1)
    cor= a1$JMAT
    c1 = JXCOR( cor , dt=0.05,  PLOT=FALSE, PIC=FALSE)
    addcor = c1$COR



    for( i in 2:length(allcor))
      {
        print(paste(sep=' ',"working on ", i, allcor[i]))
        a2 = get(allcor[i], env=e1)
        cor= a2$JMAT
        c1 = JXCOR( cor , dt=0.05,  PLOT=FALSE, PIC=FALSE)
        addcor<<-c1$COR+addcor
      }

    addcor = addcor/length(allcor)

    return(addcor)

  }


###################################################################################
### source("/home/lees/Progs/R_stuff/myakejima.R")



seeV<-function(MYALL,STA="", N=4, fl=fl, fh=fh)
  {
    if(missing(fl) ) { fl=0.05 }
    if(missing(fh) ){ fh = 2 }
    if(missing(STA) ){ STA=1 }
    if(missing(N) ){ N=4 }

    isig = 1
    
   ###  for(isig in 1:length(MYALL))
      while(isig<=length(MYALL))
      {
        Notes=rep("", length=N)
        
        sigsA = rep("amp", length=N)
        sigsAP = rep("ampi", length=N)
        Klens = rep(0,length=N)
        J = 1     
        while(J<=N)
          {
            DA = get(MYALL[isig])
            print(paste(sep=' ', isig, J, MYALL[isig]))
            KSTA=which(DA$stn==STA)
            A = paste(sep='', "amp", J)
            Ai = paste(sep='', "amp", J, "proc")
            sigsA[J] = A
            sigsAP[J] = Ai
            if(length(KSTA)>=1)
              {
                dt = DA$info$dt[KSTA]
                why = DA$dat[,KSTA]
                                        #  whyi = trapz(why , dt)
                whyi = butfilt(why,fl,fh , dt, "BP" ,"BU" )

                #  whyi =  why
                assign(sigsA[J], why)
                assign(sigsAP[J], whyi)
                timestamp=paste(sep='.', DA$info$yr[KSTA], DA$info$mo[KSTA],DA$info$dom[KSTA],
                  DA$info$hr[KSTA], DA$info$mn[KSTA], DA$info$sec[KSTA], DA$info$msec[KSTA])
                Notes[J] = paste(sep=' ', timestamp, DA$stn[KSTA], DA$comp[KSTA])
                Klens[J] = length(get(sigsA[J]))
                
                print(paste(sep=' ', J, sigsA[J], length(why), length(get(sigsA[J])),
                            sigsAP[J], length(whyi) , length(get(sigsAP[J]))   ))
                
                
              }
            else
              {
                
                assign(sigsA[J],c(0,1) )
                assign(sigsAP[J], c(0,1))
                Notes[J] = "blank"
              }
            J=J+1
            isig=isig+1
            if(isig>length(MYALL)) { break }
          }
        
        M = J-1
        ##  get common length
        K1 = 0;
        K2 = 0;
        K1 = max(Klens)
        K2 = K1
        print(paste(sep=' ','K1=',K1, 'K2=', K2))
        FR1 = matrix(nrow=K1, ncol=M)
        FR2 = matrix(nrow=K2, ncol=M)
        
        print(" PADDING ")
        
         J = 1     
        while(J<=M)
          {           
            
            kamp1 = get(sigsA[J])
                                        #  assign(sigsA[J], c(kamp1,rep(NA,K-length(kamp1))))
            FR1[,J] =  c(kamp1,rep(NA, length=(K1-length(kamp1))))
            
            kamp2 = get(sigsAP[J])
                                        #  assign(sigsAP[J], c(kamp2,rep(NA,K-length(kamp2))))
            FR2[,J] = c(kamp2,rep(NA, length=(K2-length(kamp2))))
            
            print(paste(sep=' ', J, sigsA[J], length(kamp1), sigsAP[J], length(kamp2)))
             J = J+1
          }
         print(paste(sep=' ','ready to go to plot.matn...'))
        dev.set(2)
        par(mfrow=c(1,1))
        PLOT.MATN( FR1, tim=dt*seq(0,K1-1), dt=dt, sfact=1, notes=Notes)
        dev.set(3)
        par(mfrow=c(1,1))
        PLOT.MATN( FR2, tim=dt*seq(0,K2-1), dt=dt, sfact=1, notes=Notes)



        
        klen=next2(K1)
        numfreqs = 1+klen/2;
        MTM2 = matrix(nrow=numfreqs, ncol=M)
        J = 1
           dev.set(4)
        par(mfrow=c(1,1))
       #  par(mfrow=c(M,1))
        
        while(J<=M)
          {           
            
            kamp1 = get(sigsA[J])
            sig = c(kamp1,rep(0, length=(K1-length(kamp1))))
            msig = mtapspec(sig ,dt)
           #  plot( msig$freq[2:length(msig$freq)], msig$spec[2:length(msig$freq)], log='x', type='l')

            
            MTM2[,J] = msig$spec[1:length(msig$freq)]
            J = J+1
          }
     
        
        fq= msig$freq[2:length(msig$freq)]
        
          PLOT.MATN(MTM2[2:length(msig$freq), ], tim=fq, dt=msig$df, sfact=1, notes=Notes, LOG='x')


        
        locator()
        if(isig>length(MYALL)) { break }
      }
    
    
  }
###################################################################################
### source("/home/lees/Progs/R_stuff/myakejima.R")
seeMYSPEC<-function(MYALL,STA="", N=4, fl=fl, fh=fh)
  {
    if(missing(fl) ) { fl=0.05 }
    if(missing(fh) ){ fh = 2 }
    if(missing(STA) ){ STA=1 }
    if(missing(N) ){ N=4 }

    isig = 1
    
   ###  for(isig in 1:length(MYALL))
      while(isig<=length(MYALL))
      {
         DA = get(MYALL[isig])
          KSTA=which(DA$stn==STA)
         a = DA$dat[,KSTA]
         dt = DA$info$dt[KSTA]
         DEV = evolfft(a,dt, Nfft=4096, Ns=250 , Nov=240,  fl=0, fh=10  )
         plotevol(DEV, log=1, fl=0, fh=15, col=rainbow(50))
         locator()
         isig=isig+1
      }

  }
        ###################################################################################
### source("/home/lees/Progs/R_stuff/myakejima.R")
###  
###
### source("/home/lees/Progs/R_stuff/myakejima.R")
seeMYFILT<-function(MYALL,STA="", N=4, fl=fl, fh=fh)
  {
    if(missing(fl) ) { fl=0.05 }
    if(missing(fh) ){ fh = 2 }
    if(missing(STA) ){ STA=1 }
    if(missing(N) ){ N=4 }

    isig = 1
    
   ###  for(isig in 1:length(MYALL))
      while(isig<=length(MYALL))
      {
         DA = get(MYALL[isig])
          KSTA=which(DA$stn==STA)
         a = DA$dat[,KSTA]
         dt = DA$info$dt[KSTA]
         DEV = evolfft(a,dt, Nfft=4096, Ns=250 , Nov=240,  fl=0, fh=10  )
         plotevol(DEV, log=1, fl=0, fh=15, col=rainbow(50))
         locator()
         isig=isig+1
      }

  }
        ###################################################################################
### source("/home/lees/Progs/R_stuff/myakejima.R")

###  
###
### saver = compfilt(MJALL1, STA="KKC", comps=4)
### saver = compfilt(MJALL1[1:84], STA="KKC", comps=4)

### saver = compfilt(MJALL1[c(5,6,7)], STA="KKC", comps=4)


compfilt<-function(MYALL,STA="", comps)
{
  fl = c(.05, 1, 2, 3, 4)
  fh = c( 1, 2, 3, 4, 5)
  keeps = rep(0, length(MYALL))
  jkeep = 0
  
  for( isig in 1:length(MYALL))
    {
      M1 = get(MYALL[isig])
      KSTA=which(M1$stn==STA & M1$comp==comps)
      print(paste(sep=' ', "TEST:",MYALL[isig], KSTA, comps))
      for(J in 1:length(KSTA))
        {
          k = KSTA[J]
          amp = M1$dat[,k]
          dt  =M1$info$dt[k]
          FILT.spread(M1$info$dt[k]*seq(from=0,length=length(amp)), amp, dt, fl=fl, fh=fh , sfact=2)
          title(paste(sep=' ',isig, MYALL[isig], M1$info$name[k]))
          PK = locator()
          keeps[isig] = length(PK$x)  
        }
    }

  ret = which(keeps>0)
  return(ret)
}
####################################################
####################################################
### source("/home/lees/Progs/R_stuff/myakejima.R")


myak.Xtract<-function(mSW, STA="KAC", COMP="Vertical", BEF=1, AFT=5, FV=FV, PLT=FALSE )
  {
###   pick windows for Etna DATA
### 
    ##
    if(missing(STA))
      {     
        STA="KAC"
      }
    if(missing(COMP))
      {     
        COMP="Vertical"
      }
    if(missing(BEF))
      {     
        BEF=1
      }
    if(missing(AFT))
      {     
        AFT=5
      }
    if(missing(FV))
      {
        FV=list(ON=FALSE, fl=0.5, fh=1.0, type="LP", proto="BU", vec=c(FALSE))
      }
    if(missing(PLT))
      {
        PLT=FALSE
      }

    kpic = 1
    
    klen = length(mSW)
    GG = get(mSW[1])
    k = which(GG$stn==STA & GG$chaname==COMP)
    dt = GG$info$dt[k]
    NUMP = floor((AFT+BEF)/dt)
    JMAT = matrix(NA, nrow=NUMP, ncol=klen)
    IDS =  rep("",klen)
    TIMS =  rep(0,klen)
    
    
    for(i in 1:length(mSW))
      {
           
        GG = get(mSW[i])
        k = which(GG$stn==STA & GG$chaname==COMP)
        dt = GG$info$dt[k]
        T1 = GG$dat[,k]
        print(paste(sep=' ' , "Working on:", i, mSW[i]))
        if(FV$ON==TRUE)
          {
            amp = T1
            amp1 = butfilt(amp,FV$fl, FV$fh , dt, FV$type ,  FV$proto )
            T1 = amp1
          }

        
        pic = GG$PIX$t[GG$stn[GG$PIX$comp]==STA]

        
        #  pic = GG$PIX$t[GG$PIX$comp==k]
        
        if(is.null(pic[kpic]))
          {
            print(paste(sep=' ' , "no pics available", i, mSW[i]))
            next;
          }
        nx = floor((AFT+BEF)/dt)
        nb = floor(BEF/dt)
        na = floor(AFT/dt)
        
        m1 = floor(pic/dt)
        m2 =  length(T1) -  floor(pic/dt)

        j1 = floor((pic-BEF)/dt)
        j2 = floor((pic+AFT)/dt)
        nj = j2-j1
        if(nj>NUMP) { j2 = j2 -1 }
        

        TNEW =  T1[j1:j2]
        XNEW  = seq(from=0, by=dt, length=length( TNEW) )

        if(PLT==TRUE)
          {
            plot( seq(from=0, by=dt, length=length(T1) ), T1)
            abline(v=c(pic, pic-BEF, pic+AFT), col=c(2,4,4))
             Sys.sleep(0.5)
          }
        
        ##   dev.set(2);  plot( seq(from=0, by=dt, length=length(T1) ), T1)
        ##    abline(v=c(pic, pic-BEF, pic+AFT), col=c(2,4,4))
        ##   dev.set(3);  plot(XNEW, TNEW)

        Y = TNEW[1:NUMP]
       
        JMAT[,i ] = Y

        Gi = GG$info
        jd  = jday( Gi$yr[k], Gi$mo[k], Gi$dom[k])
        t = recdate(jd , Gi$hr[k], Gi$mn[k],
          Gi$sec[k]+Gi$off[k]+Gi$msec[k]/1000+Gi$t1[k])
        
        titname = paste(sep="_",
          mSW[i],
          format.default(Gi$yr[k], digits=4),
          format.default(t$jday, digits=3),
          format.default(t$hour, digits=2),
          format.default(t$min, digits=2),
          format.default(floor(t$sec), digits=2))
        
        IDS[i] = titname
        TIMS[i] = t$jday+t$hour/(24)+ t$min/(24*60)+(t$sec+Gi$t1[k])/(24*60*60)
        
      }
    
    if(PLT==TRUE)  PLOT.MATN(JMAT, dt=dt, notes=IDS)
    
    return(list(JMAT=JMAT, IDS=IDS, TIMS=TIMS) )
    
  }
### source("/home/lees/Progs/R_stuff/myakejima.R")




