
cat("sourcing /home/lees/Progs/R_stuff/net.R\n")

###  source("/home/lees/Progs/R_stuff/net.R")


deg2rad = pi/180
rad2deg = 180/pi
DEG2RAD = pi/180;
RAD2DEG = 180/pi;
EARTHRAD = 6371;  #  average earth radius in KM
#######################
GreatDist<-function( LON1,  LAT1,  LON2,  LAT2)
{
 #  /* calculate the great arc distance 
 #     between two points
 #     given the lat lons in degrees */
 # 
  phi1= DEG2RAD*LAT1;
  lam0=DEG2RAD* LON1;
  phi=DEG2RAD*LAT2;
  lam=DEG2RAD*LON2;
  
  s1 = sin( (phi-phi1 )/2);
  s2 = sin( (lam-lam0 )/2);
  tem = sqrt(s1*s1 + cos(phi1)*cos(phi)*s2*s2);
  tem2 = 2*asin(tem);
  # tem2 is now in radians, convert to degrees and km
  
  tem3  =  RAD2DEG*tem2;
  tem4 = tem2*EARTHRAD;
  
  return(list(drad=tem2, ddeg=tem3, dkm=tem4));
}
#######################
AlongGreat<-function( LON1,  LAT1,  km1, ang )
{
 #  /* calculate the great arc distance 
 #     between two points
 #     given the lat lons in degrees */

 #     /*
 #        given a point (lat lon) degrees
 #        a distance in km (km1) and
  #       an azimuthal direction Az
 #        calculate the point (phi, lam) which lies angle radians away from (lat, lon)
 #     */
 #  
  phi1= DEG2RAD*LAT1;
  lam0= DEG2RAD* LON1;
  Az = DEG2RAD*ang;
  c = km1/EARTHRAD;
  
  phi =  asin( sin(phi1)*cos(c) + cos(phi1)*sin(c)*cos(Az));
  tem = atan2( sin(c)*sin(Az), (cos(phi1)*cos(c) - sin(phi1)*sin(c)*cos(Az)));
  lam = lam0 + tem;
  ddeg = RAD2DEG*c;

  lam = RAD2DEG*lam
  phi = RAD2DEG*phi
  return(list(lat=phi, lon=lam , distdeg=ddeg , distkm=c));
}
#######################
###  source("/home/lees/Progs/R_stuff/net.R")

#######################

focpoint<-function(az1, dip1, col=2, pch=5, lab="", UP=FALSE, PLOT=TRUE )
{
  #    azimuth is degrees from north
  #    dip is degrees from down direction?  or degrees from horizontal?

  
                                        # print(paste(sep=" ", "focpoint", az1, dip1, lab)); 
  if(missing(col))  { col=rep(1,length(az1)) }
  if(missing(pch))  { pch=rep(5,length(az1)) }
  if(missing(PLOT)) { PLOT=TRUE; }
                                        # if(missing(lab))  { lab="" }
  if(missing(UP)) { UP=FALSE }

  
  dip1 = 90-dip1 ;
  
  if(UP==TRUE)
    {
      az1=az1+180
      
    }
                                        # print(paste(sep=" ", "dip1=", dip1, "az1=", az1))
  DEG2RAD = pi/180;


  dflag = dip1>90
  
      dip1[dflag]=dip1[dflag]-90
      az1[dflag]=az1[dflag]-180
      pch[dflag]=15
      col[dflag]=3

  tdip = dip1;
  trot =DEG2RAD*az1;
  xi =  DEG2RAD*tdip;
  tq = sqrt(2) * sin(xi / 2.0);
  pltx = tq * sin(trot);
  plty = tq * cos(trot);
  if(PLOT==TRUE)
    {
      points( pltx, plty , pch=pch, col=col)
      
      if(!missing(lab)) 
        {
          text( pltx, plty, labels=lab, pos=4)
        }
    }
  invisible(list(x=pltx, y=plty))
}
#############
uppoint<-function(A)
  {
 if(!is.numeric(A$z)) A = tocart(A)
if(A$z>=0)
  {
  col=2
}
else
  {
  col=3
}

fpoint(A$az, A$dip, col=col, UP=TRUE);

}
#############
upvec<-function(A, col=2)
  {
if(missing(col))  col=2; 
if(!is.numeric(A$z)) A = tocart(A)
if(A$z>=0)
  {
    pcol=2
  }
else
  {
    pcol=3
  }

p = fpoint(A$az, A$dip, col=pcol, UP=TRUE);
arrows(0, 0, p$x, p$y, col=col, length=0.05)

}


#############
fpoint<-function(az1, dip1, col=2, pch=5, lab="", UP=FALSE )
{
  #  az1=azimuth from north and dip=dip1 from horizontal
  DEG2RAD = pi/180;                                
  if(missing(UP)) { UP=FALSE }	
  tdip = dip1
  if(UP==TRUE)
    {
      tdip=180 - dip1
    }
  else
    {
      tdip = 90-tdip
    }

  FLG = tdip>90

  tdip[FLG]=tdip[FLG]-90
  az1[FLG]=az1[FLG]-180

  if(missing(col))  {
    col=rep(2, length(az1))
    col[FLG]=3
   }
  if(missing(pch))  {
    pch=rep(5, length(az1))
    pch[FLG]=15
  }
  
  FLG2 = ( (dip1 == 0) | (dip1 == 180) )
          tdip[FLG2]=0
          az1[FLG2]=0
  
  trot =DEG2RAD*az1;
  xi =  DEG2RAD*tdip;
  tq = sqrt(2) * sin(xi / 2.0);
  pltx = tq * sin(trot);
  plty = tq * cos(trot);

  points( pltx, plty , pch=pch, col=col)


  if(!missing(lab)) 
    {
      text( pltx, plty, labels=lab, pos=4)
    }
  return(list(x=pltx, y=plty))
}
#############
#### source("/home/lees/Progs/R_stuff/net.R")

qpoint<-function(az, iang, col=2, pch=5, lab="", POS=4, UP=FALSE, PLOT=FALSE )
{
  #  plot a point on focal sphere,
  #  az = angle from north (degrees
  #  iang = angle from Z-down (not from horizontal)
  if(missing(POS)) { POS=4 ; }
  if(missing(PLOT)) { PLOT=TRUE }
  
  
  DEG2RAD = pi/180;
  sph = cos(DEG2RAD*iang);
  
  sph[sph>=0] = 0;
  sph[sph<0] =  1;
  
 
  if(missing(col))  {
    col=rep(1,length(az))
    col= col+sph
  }
  
  if(missing(pch))  {
    pch=rep(5,length(az))
    pch=pch+sph
  }
  
  if(missing(UP)) { UP=FALSE }


  if(UP==TRUE)
    {
      #  flip the orientation for upper sphere
      az = az+180
      # 
    }
  
  A = list(az=az, dip=iang)
   
  A$dip = iang
  A$az =az
  B = FixDip(A)

  
  trot =DEG2RAD* B$az
  tdip = B$dip

  xi =  DEG2RAD*tdip;

  tq = sqrt(2) * sin(xi / 2.0);
  
  pltx = tq * sin(trot);
  plty = tq * cos(trot);
  
  
  if(PLOT==TRUE)
    {
      points( pltx, plty , pch=pch, col=col)
      
      
      if(!missing(lab)) 
        {
          text( pltx, plty, labels=lab, pos=POS)
        }
    }
  return(list(x=pltx, y=plty))
}
#####################
circ<-function()
{
# net(1)
C = circle()
plot(C$x,C$y, type='n', axes=FALSE, asp=1, xlab="", ylab="")
 lines(C$x,C$y, type='l')
}
#####################


HFOC<-function(H)
{
# net(1)
C = circle()
plot(C$x,C$y, type='n', axes=FALSE, asp=1, xlab="", ylab="")
 lines(C$x,C$y, type='l')

circ.tics()
P = POLYFOC(H)

polygon(P$Px, P$Py, col=gray(0.95) )


faultplane(H$strike, H$dip,  col=4, UP=H$UP)

fpoint(H$U$az, H$U$dip,  col=4, UP=H$UP)

fpoint(H$V$az, H$V$dip,  col=3, UP=H$UP)

# faultplane(H$F$az-90, H$F$dip,  col=1, UP=UP)

faultplane(H$G$az-90, H$G$dip,  col=3, UP=H$UP)

fpoint(H$P$az, H$P$dip,  col=1, UP=H$UP)
fpoint(H$T$az, H$T$dip,  col=5, UP=H$UP)

A1 = TOCART(H$U$az, 90-H$U$dip)
A2 = TOCART(H$V$az, 90-H$V$dip)
J = CROSS(A1, A2)

if(UP==FALSE)
  {
#       REFLECT(K)
       title("Lower Hemisphere")

  }
else
  {
   title("Upper Hemisphere")
  }
 fpoint(J$az, 90-J$dip,  col=2, UP=UP)
# faultplane( K$az+90 , K$dip  ,  col=6, UP=UP)

}
#####################
rectify.angle<-function(iang)
{
    tdip = DEG2RAD*fmod(iang, 360.);
    co = cos(tdip)
    si = sin(tdip)
    ang = RAD2DEG*atan2(si, co)
 return(ang)
}
#####################



FixDip<-function(A)
  {
                                        # given an azimuth and an angle
    az  = A$az
    dip = A$dip

    
    tdip = DEG2RAD*fmod(dip, 360.);
    co = cos(tdip)
    si = sin(tdip)
    ang = RAD2DEG*atan2(si, co)


    quad = rep(1, length(dip))

    quad[co>=0 & si>=0] = 1
    quad[co<0 & si>=0] = 2
    quad[co<0 & si<0] = 3
    quad[co>=0 & si<0] = 4

    dip[quad==1] = ang[quad==1]
    dip[quad==2] = 180-ang[quad==2]
    dip[quad==3] = 180+ang[quad==3]
    dip[quad==4] = -ang[quad==4]



    az[quad==1] = az[quad==1]
    az[quad==2] = 180+az[quad==2]
    az[quad==3] = az[quad==3]
    az[quad==4] = 180+az[quad==4]
    

    A$az = fmod(az, 360.);

    
    A$dip = dip
    
    return(A);
  }


#####################
DOT<-function(A1, A2)
{
  if(!is.numeric(A1$x)) A1 = tocart(A1)
  if(!is.numeric(A2$x)) A2 = tocart(A2)

  
return( A1$x*A2$x + A1$y*A2$y + A1$z*A2$z)
}
########
LEN<-function(A1)
{
return( sqrt(A1$x*A1$x + A1$y*A1$y + A1$z*A1$z))
}
########
NORM<-function(A1)
  {
r = LEN(A1)
x = A1$x/r
y = A1$y/r
z = A1$z/r
return(list(x=x, y=y, z=z))
  }
#########
ROT<-function(N, M)
  {
    a = c(N$x, N$y, N$z)
    B = a %*% M

    G = TOSPHERE(B[1], B[2], B[3])
    return(G)

  }

########
CROSS<-function(A1, A2)
{

  if(!is.numeric(A1$x)) A1 = tocart(A1)
  if(!is.numeric(A2$x)) A2 = tocart(A2)
    
  x = A1$y*A2$z-A1$z*A2$y
  y = A1$z*A2$x-A1$x*A2$z
  z = A1$x*A2$y-A2$x*A1$y
  a = TOSPHERE(x, y, z)
  return(list(x=x, y=y, z=z, az=a$az, dip=a$dip))
}
########
CROSS.DIP<-function(A1, A2)
{

  if(!is.numeric(A1$x)) A1 = tocart(A1)
  if(!is.numeric(A2$x)) A2 = tocart(A2)
    
  x = A1$y*A2$z-A1$z*A2$y
  y = A1$z*A2$x-A1$x*A2$z
  z = A1$x*A2$y-A2$x*A1$y
  a = TOSPHERE.DIP(x, y, z)
  return(list(x=x, y=y, z=z, az=a$az, dip=a$dip))
}

########
FLIP<-function(A1)
{
  x = -A1$x
  y = -A1$y
  z = -A1$z
  a = TOSPHERE(x, y, z)
  return(list(x=x, y=y, z=z, az=a$az, dip=a$dip))
}
#######
XprodLL<-function(  deglon1, deglat1,   deglon2, deglat2  )
  {
    deg2rad = pi/180
   lat1 = deg2rad*(deglat1);
   lat2 = deg2rad*(deglat2);
          
   lon1 = deg2rad*(deglon1);
   lon2 = deg2rad*(deglon2);

 x  =  sin(lat1-lat2) *sin((lon1+lon2)/2) *cos((lon1-lon2)/2) -

	    sin(lat1+lat2) *cos((lon1+lon2)/2) *sin((lon1-lon2)/2) ;

 y = sin(lat1-lat2) *cos((lon1+lon2)/2) *cos((lon1-lon2)/2) +

       sin(lat1+lat2) *sin((lon1+lon2)/2) *sin((lon1-lon2)/2);

 z  =  cos(lat1)*cos(lat2)*sin(lon1-lon2) ;

   return(list(x=x, y=y, z=z))
 }
############
xprod<-function(A1,A2)
  {
   ############  cross product with 2 vectors input
  x = A1[2]*A2[3]-A1[3]*A2[2]
  y = A1[3]*A2[1]-A1[1]*A2[3]
  z = A1[1]*A2[2]-A2[1]*A1[2]
   ###  return a vector
  return(c(x,y,z))
  }
########
vlen<-function(A1)
  {
    return(sqrt(sum(A1^2)))

  }

######  

DANG<-function(A1,A2)
{
  return(RAD2DEG*acos(DOT(A1, A2)/(LEN(A1)*LEN(A2))))
}

#####################
TOCART<-function(az, nadir)
{
  #   Convert from spherical (az, dip in degrees) to Cartesian coordinates
  #     x pos north, y pos east, z pos downward
  #    az in degrees from north, dip (nadir angle) in degrees from Z (down)
 
  azrad = az * DEG2RAD;
  diprad = nadir * DEG2RAD;

  z = cos(diprad);
  temp = sin(diprad);
  x = cos(azrad) * temp;
  y = sin(azrad) * temp;
  len=sqrt(x*x+y*y+z*z)
  z = z/len
  x = x/len
  y = y/len 
  return(list(x=x,y=y,z=z, az=az, dip=nadir));
}
#####################
TOSPHERE<-function(x, y, z)
{
#  /* Convert from Cartesian to spherical (az, dip in degrees) coordinates */
    length = sqrt( x*x + y*y + z*z);
    if(length==0.0) return(list(az=NaN,dip=NaN, x=NaN, y=NaN, z=NaN));
    diprad = acos(z/length);
    azrad = atan2(y, x);
    az = azrad * RAD2DEG;
    dip = diprad * RAD2DEG;
    return(list(az=az,dip=dip, x=x, y=y, z=z));
}
#####################
tocart<-function(A)
{
  #   /* Convert from spherical (az, dip in degrees) to Cartesian coordinates
  #     x pos north, y pos east, z pos downward */
  
  a = TOCART(A$az, A$dip)
    return(a);
}
#####################
tosphere<-function(A)
{
#  /* Convert from Cartesian to spherical (az, dip in degrees) coordinates */
  a = TOSPHERE(A$x, A$y, A$z)
  return(a)
}
#####################
TOCART.DIP<-function(az, dip)
{
  #   Convert from spherical (az, dip in degrees) to Cartesian coordinates
  #     x pos north, y pos east, z pos downward
  #    az in degrees from north, dip in degrees from Z (down)
 
  azrad = az * DEG2RAD;
  diprad = dip * DEG2RAD;

  z = sin(diprad);
  temp = cos(diprad);
  x = cos(azrad) * temp;
  y = sin(azrad) * temp;
  len=sqrt(x*x+y*y+z*z)
  z = z/len
  x = x/len
  y = y/len 
  return(list(x=x,y=y,z=z, az=az, dip=dip));
}
#####################
TOSPHERE.DIP<-function(x, y, z)
{
#  /* Convert from Cartesian to spherical (az, dip in degrees) coordinates */
    length = sqrt( x*x + y*y + z*z);
    if(length==0.0) return(list(az=NaN,dip=NaN, x=NaN, y=NaN, z=NaN));
    diprad = asin(z/length);
    azrad = atan2(y, x);
    az = azrad * RAD2DEG;
    dip = diprad * RAD2DEG;
    if(dip<0)
      {
        dip = 90-dip
        az = az+180
      }
    return(list(az=az,dip=dip, x=x, y=y, z=z));
}
#####################
AXpoint<-function(UP=TRUE)
{
                   #   to plot points on an equale area stero net:
  if(missing(UP)) { UP = TRUE}
  deg2rad = pi/180
  rad2deg = 180/pi
  p = locator(n=1, type='p', col=2)
  r = sqrt(p$x^2+p$y^2)
  if(r>1) return(list(az=0, dip=0))
  iang = rad2deg*2*asin(r/sqrt(2))
  phiang = rad2deg*( pi/2 - atan(p$y,p$x))
  if(UP==TRUE)
    {
      iang = 180-iang
    }
  a = TOCART(phiang, iang)
  return(list(az=phiang, dip=iang, x=a$x, y=a$y, z=a$z, gx=p$x, gy=p$y))
}
#####################



EApoint<-function()
{
 #   to plot points on an equale area stero net: 
deg2rad = pi/180
rad2deg = 180/pi

x = 0
y = 0
r = sqrt(x^2+y^2)
while(r<=1)
{
p = locator(n=1, type='p')
r = sqrt(p$x^2+p$y^2)
if(r>1) break
iang = rad2deg*2*asin(r/sqrt(2))
phiang = rad2deg*( pi/2 - atan(p$y,p$x))
print(paste(" ", p$x, p$y, "iANG=", iang, "PHI=",phiang))

}

}



pcirc<-function(gcol)
{
phi = seq(0,2*pi, by=pi/18);
x = cos(phi);
y = sin(phi);
lines(x,y, col=1)
lines(c(-1,1), c(0,0), col=gcol)
lines(c(0,0), c(-1,1), col=gcol)

}

rotx<-function( deg )
{
	rad1 = deg * 0.0174532
     r = diag(3)
	r[2, 2] = cos(rad1)
	r[2, 3] = sin(rad1)
	r[3, 3] = r[2, 2]
	r[3, 2] = -r[2, 3]
return(r)
}

###########################################
REFLECT<-function(A)
{
    #  /* Reflect to lower hemisphere */
   h = Preflect(A$az, A$dip );
   A$az=h$az; A$dip=h$dip;
   A = tocart(A);
    return(A);
}

Preflect<-function(az, dip )
{
    #  /* Reflect to lower hemisphere */
    if (dip < 0.0)
      {
	az = fmod(az + 180., 360.);
	dip = -dip;
    }
    return(list(az=az, dip=dip));
}
###########################################

CONVERTSDR<-function(strike, dip, rake)
{
  # input is strike dip and rake
 #  note in calculations we use the down dip directin here and not strike!
  # dip is measured from the horizontal NOT from the  NADIR
    dipdir = strike + 90.;
     signforp = 1;

    #  /* Compute F plane dip direction and dip */
    phif = fmod(dipdir, 360.);
    deltaf = dip;

    #  /* Compute U slip vector */
    if (rake > 90.) {  # /* this corrects for rakes past 90.0 by reflection */
	tmprake = rake - 180.;
	signforp = -1.;
    } else if (rake < -90.) {
	tmprake = rake + 180.;
	signforp = -1.;
    } else {
	tmprake = rake;
	signforp = 1.;
    }
    
    temp1 = tmprake * DEG2RAD;
    temp2 = dip * DEG2RAD;
    deltau = asin(-1*sin(temp1) * sin(temp2) );      # /* leave in radians */
    phiu = dipdir - 90. + asin( tan(deltau) / tan(temp2))*RAD2DEG;
    deltau = deltau*RAD2DEG;
    phiu = fmod(phiu+360., 360.);
     # /* reflect(&phiu, &deltau); */

     # /* Compute G plane dip direction and dip */
    deltag = 90 - deltau;
    if (deltag < 0.) {
	phig = phiu;
	deltag = -deltag;
    } else if (deltag > 90.) {
	phig = phiu;
	deltag = 180. - deltag;
    } else {
	phig = phiu + 180.;
    }
    
    phig = fmod(phig, 360.);

     # /* Compute V slip vector */
    deltav = 90 - deltaf;
    phiv = fmod(phif + 180, 360.);
     # /* reflect(&phiv, &deltav); */

     # /* Find P axis, as 1/2 way between U and V */
    U = TOCART.DIP(phiu, deltau);
    V = TOCART.DIP(phiv, deltav);
     # /* reverse second vector if necessary */
    
    V$x = signforp*V$x  ; V$y = signforp*V$y; V$z = signforp*V$z;
    
     # /* add together to form intermediate vector */
     
    P = TOSPHERE.DIP( U$x+V$x, U$y+V$y, U$z+V$z);
 
    P$az = fmod(P$az + 360., 360.);
     
     P = REFLECT(P);
    
     # /* Finally, find T axis orthogonal to P axis - this is easy */
     
     x2 = -V$x;
     y2 = -V$y;
     z2 = -V$z;
    T = TOSPHERE.DIP( U$x+x2, U$y+y2, U$z+z2 );
    T$az = fmod( T$az + 360., 360.);
     
    T = REFLECT(T);
    
     # /* Finally reflect U and V vectors */
    U = REFLECT(U);
    V = REFLECT(V);
     F = TOCART.DIP(phif, deltaf);
     G = TOCART.DIP(phig, deltag);

   M =list( az1=0, d1=0,  az2=0, d2=0, uaz=0, ud=0, vaz=0, vd=0, paz=0, pd =0, taz=0, td=0)
 
   M$az1=F$az;  M$d1=F$dip;
   M$az2=G$az;  M$d2=G$dip ;
   M$uaz=U$az;  M$ud=U$dip;
   M$vaz=V$az;  M$vd=V$dip;
   M$paz=P$az;  M$pd=P$dip;
   M$taz=T$az;  M$td=T$dip ;
   
    

    return(list(strike=strike, dipdir=dipdir, dip=dip, rake=rake, F=F, G=G, U=U, V=V, P=P, T=T, M=M));
}


###########################################
net<-function(add)
{
 if(missing(add))  { add=1 }  
 
 gcol = gray(.7)
 ang=seq(0, pi, by=pi/18)
 RX = rotx(90);
 
 pi180 = pi / 180;
 
                                        #% SMALL circles  (Latitudes)
 lambda = pi180*(1:90);
 
 if(add==1)
   {
     plot(c(-1,1),c(-1,1), type='n', xlab='', ylab='', asp=1, axes=FALSE) 
   }
 pcirc(gcol)
 
 for(lat in seq( -90, 90 , by=10))
   {
     
     phi =   lat *pi180;
     
     
     alpha = acos(cos(phi) * cos(lambda))
     tq = sqrt(2)*sin(alpha/2.0)
     sint = sin(phi)*rep(1,length(lambda))  /  sin(alpha)
     x = tq * sqrt(rep(1,length(sint) ) -  (sint  * sint)  )
     y = tq * sint 
     lines(x,y, col=gcol)       
   }
                                        # plot(x,y);
                                        #end
 
 
 lambda = pi180*seq(-90,-1);
 
 for (lat in seq(-90, 90, 10))
   {
     
     phi =   lat *pi180;
  
     
     alpha = -acos(cos(phi) * cos(lambda));
     tq = sqrt(2)*sin(alpha/2.0);
     sint = sin(phi)*rep(1,length(lambda))  /  sin(alpha);
     x = tq * sqrt( rep(1,length(lambda)) -  (sint  * sint)  );
     y = tq * sint   ;          
     lines(x,y, col=gcol)       
                                        # plot(x,y);
   }
                                        # end
 
                                        # %  GREAT Circles (Longitudes)

 
 phi = pi180*seq(-90,90, by=1);
 
 for (lat in seq(10, 80, by=10))
   {
     
     lambda =   lat *pi180;
     
     
     alpha = acos(cos(phi) * cos(lambda));
     tq = sqrt(2)*sin(alpha/2.0);
     sint = sin(phi) / sin(alpha);
     x = tq * sqrt(rep(1,length(sint)) -  (sint  * sint)  );
     y = tq * sint   ;          
     lines(x,y, col=gcol)       
                                        #  plot(x,y);
   }

 
 
 for (lat in  seq(-80,-10, by=10))
   {
     lambda =   lat *pi180;
     
     
     alpha = -acos(cos(phi) * cos(lambda));
     tq = sqrt(2)*sin(alpha/2.0);
            sint = sin(phi) / sin(alpha);
     x = tq * sqrt(rep(1,length(sint)) -  (sint  * sint)  );
     y = tq * sint   ;          
     lines(x,y, col=gcol)     
                                        # plot(x,y);
   }
 segments(c(-.02, 0), c(0, -0.02), c(0.02, 0), c(0, 0.02), col=1)
 
}


################################
getM<-function(FROM, TO)
{

  Q1 =CROSS(FROM, TO)
  Q = NORM(Q1)
  alpha = DANG(FROM, TO)

  ca = cos(DEG2RAD*alpha)
  sa = sin(DEG2RAD*alpha)

  d = sqrt( Q$y*Q$y + Q$z*Q$z )

  Rx = matrix(c(1,0,0,0,Q$z/d, Q$y/d, 0, -Q$y/d, Q$z/d),ncol=3, byrow=T)

  Ry  = matrix(c(d,0,Q$x ,0,1,0, -Q$x,0, d),ncol=3, byrow=T)

  RZ =  matrix(c(ca, sa, 0, -sa, ca, 0, 0, 0, 1),ncol=3, byrow=T)

  RxI = matrix(c(1,0,0,0,Q$z/d, -Q$y/d, 0, Q$y/d, Q$z/d),ncol=3, byrow=T)

  RyI  = matrix(c(d,0,-Q$x ,0,1,0, Q$x,0, d),ncol=3, byrow=T)

  M = Rx %*% Ry  %*%  RZ   %*% RyI  %*% RxI

  return(M)
}
####
prang<-function(a)
  {
return(round(a))
  }
####
PRINTMC<-function(M)
{
print(paste(sep=" ", "F", M$F$az, M$F$dip,
            "G",prang(M$G$az), prang(M$G$dip),
            "U",prang(M$U$az), prang(M$U$dip),
            "V",prang(M$V$az), prang(M$V$dip),
            "P",prang(M$P$az), prang(M$P$dip),
            "T",prang(M$T$az), prang(M$T$dip)))

print(paste(sep=" ", "strike=", M$strike, "dip=", M$dip, "rake",M$rake))

}


################################

MOD<-function(k, m)
  {
    j = floor(k/m)
    a = k-m*j
    return(list(rem=a, mant=j))
  }
fmod<-function(k, m)
  {
    j = floor(k/m)
    a = k-m*j
    return(a)
  }

################################
faultplane<-function(az,  dip,  col = par("col"), PLOT=TRUE, UP=FALSE) 
  {    
#      az = strike of the plane (NOT down dip azimuth)
#      dip = dip from horizontal
    #   given the dip and strike of a plan, plot it

    beta = az * DEG2RAD;
     DEG2RAD = pi/180;
    # print(paste(" ","FaultPLANE: ", az, dip, UP))
                                        
    if(missing(PLOT)) { PLOT=TRUE }
    if(missing(PLOT)) { UP=FALSE }

    
    if(UP) { beta = beta+pi }
         
    pi180 = pi / 180;
    phi = pi180*seq(-90,90, by=1);

  co = cos(beta);
  si = sin(beta);
 
    if(dip != 0)
      {
        lambda =   (90-dip) *  DEG2RAD;
        alpha = acos(cos(phi) * cos(lambda));
        tq = sqrt(2)*sin(alpha/2.0);
        
        sint = sin(phi) / sin(alpha);
        sint[is.nan(sint)] = 1
        temps = rep(1,length(sint)) -  (sint  * sint)
        temps[is.nan(temps)] = 0
        temps[temps<0] = 0
        x = tq * sqrt(temps  );
        y = tq * sint   ; 

      }
    else
      {
        x = c(0,0)
        y = c(-1,1)
       
      }

        x1 =  co   * x +  si * y;
        y1 =  -si  * x +  co * y;
    if(PLOT)
      {
        lines(x1,y1, lwd=2, col=col)
      }
    return(list(x=x1, y=y1))

  }
###################################
POLYFOC<-function(H, PLOT=FALSE)
  {
    R = polyfoc(H$strike, H$dip, H$G$az-90, H$G$dip,  PLOT=FALSE)
    return(R)
  }
bang<-function(x1,y1,x2,y2)
  {
    xp = x1*y2-y1*x2
    xp[xp>=0] =  1
    xp[xp<0]  = -1
    ang = xp*acos(x1*x2+y1*y2)
    return(ang)
  }

###################################
polyfoc<-function(strike1, dip1, strike2, dip2, PLOT=FALSE, UP=TRUE)
  {
    if(missing(UP)) {  UP=TRUE }
    if(missing(PLOT)) {  PLOT=TRUE }
    
    num = 40;
    F1 = faultplane(strike1, dip1,  PLOT=FALSE, UP=UP)
    F2 = faultplane(strike2, dip2,   PLOT=FALSE,  UP=UP)

    k = length(F1$x)
    
    alpha1 = atan2(F1$y[1], F1$x[1]);
    alpha2 = atan2(F1$y[k], F1$x[k]);
    
    beta1 = atan2(F2$y[1], F2$x[1]);
    beta2 = atan2(F2$y[k], F2$x[k]);


    a1 = RAD2DEG * alpha1;
    a2 = RAD2DEG * alpha2;
    b1 = RAD2DEG * beta1;
    b2 = RAD2DEG * beta2;

    tx1= rep(0,num);
    ty1  = rep(0,num);
    
 
    dang = bang(F1$x[k], F1$y[k], F2$x[1], F2$y[1])/num

   
    ang = alpha2+dang*seq(1,num);
    tx1  = cos(ang);
    ty1  = sin(ang);
     
    
    tx2= rep(0,num);
    ty2  = rep(0,num);
    
    dang = bang(F2$x[k], F2$y[k], F1$x[1], F1$y[1])/num
    
    ang = beta2+dang*seq(1,num) ;
    
    ang = ang+dang;
    tx2 = cos(ang);
    ty2 = sin(ang);
    
    
    Px = c(F1$x, tx1, F2$x, tx2);
    Py = c(F1$y, ty1, F2$y, ty2);
    
    return(list(Px=Px, Py=Py))
  }


###################################
lowplane<-function( az, dip, col = par("col"), UP=FALSE) 
  {
#      az = strike of the plane (NOT down dip azimuth)
#      dip = dip from horizontal
#  lam is the azimuth  
#  phi is the azimuth
    
#    A = MOD(az, 360)
    
#    lam = A$rem
    beta = az * DEG2RAD;
     DEG2RAD = pi/180;
   #  print(paste(" ","LOWPLANE: ", az, dip, UP))
                  #   given the dip and strike of a plan, plot it
    if(missing(UP)) { UP=FALSE }
    
                          #  if(!UP) { dip = 90-dip; lam=lam+180 }
    if(UP) { beta = beta+pi }
    
  #   beta = (90+az)* DEG2RAD;
     
    pi180 = pi / 180;
    phi = pi180*seq(-90,90, by=1);
    rz = matrix(ncol=2, nrow=2)
#    rtt = -lam
                                        # rtt = 90-lam
    rz[1,1] = cos(beta);
    rz[1,2] = sin(beta);
    rz[2,1] = -rz[1,2];
    rz[2,2] = rz[1,1];
  co = cos(beta);
  si = sin(beta);
 
    if(dip != 0)
      {
        lambda =   (90-dip) *  DEG2RAD;
        alpha = acos(cos(phi) * cos(lambda));
        tq = sqrt(2)*sin(alpha/2.0);
        sint = sin(phi) / sin(alpha);
        temps = rep(1,length(sint)) -  (sint  * sint)
        temps[is.nan(temps)] = 0
        temps[temps<0] = 0
        x = tq * sqrt(temps  );
        y = tq * sint   ; 
        # prj = cbind(x,y) %*% rz
        
       # x1 = prj[,1]
       # y1 = prj[,2]
        x1 = co * x + si * y;
        y1 =  -si * x + co * y;  
      }
    else
      {
        x = c(0,0)
        y = c(-1,1)
        prj = cbind(x,y) %*% rz 
        x1 = prj[,1]
        y1 = prj[,2]
      }        
    lines(x1,y1, lwd=2, col=col)
    return(list(x=x1, y=y1))
  }
###########################source("/home/lees/Progs/R_stuff/net.R")
GROTATE<-function()
{
North =  TOCART(0, 90);
Down  = TOCART(0, 0);
East = TOCART(90,  90); 
       net(1)
      p = AXpoint(UP=TRUE)
      r = sqrt(p$gx*p$gx+p$gy*p$gy)
  while(r<=1)
    {  
      M = getM(North, p)
      GN = ROT(North, M)
      GE = ROT(East, M)
      GZ = ROT(Down, M)


      #  tests
      a1=DOT(GN, GE)
      a2=DOT(GE, GZ)
      a3=DOT(GZ, GN)
# print(paste(sep=" ", "TESTS:", a1, a2, a3))

      fpoint(North$az, North$dip, col=4, UP=TRUE);
      # uppoint(North, col=4)
      # uppoint(East, col=3)
     #  uppoint(Down, col=2)

      uppoint(GN)
      uppoint(GE)
      uppoint(GZ)

      upvec(GN, col=4)
      upvec(GE, col=3)
      upvec(GZ, col=2)


      
      B1 = list(GN=GN, GE=GE, GZ=GZ)
      pplanes(B1)
     
      p = AXpoint(UP=TRUE)
      r = sqrt(p$gx*p$gx+p$gy*p$gy)
      if(r>1)
        {
          B1 = list(GN=GN, GE=GE, GZ=GZ)
          break;
        }
      
       net(1)

      
    }

  return(B1)
}
###########################source("/home/lees/Progs/R_stuff/net.R")
#   source("/home/lees/Progs/R_stuff/net.R")

JROTATE<-function(pfile)
{
# JRAK = JROTATE(pfile)
      # net(1)
  RAK1 = seeMech(pfile)
  net(0)
  RAK = SetMech(RAK1)

  
  AL = c("F", "G", "U", "V", "P", "T"   )
  
 #  poles=cbind(c(RAK$F$az, RAK$G$az, RAK$P$az, RAK$T$az, RAK$V$az, RAK$U$az),
 #              c(RAK$F$dip,RAK$G$dip,RAK$P$dip,RAK$T$dip,RAK$V$dip,RAK$U$dip))
  poles=cbind(
    c(RAK$M$az1,RAK$M$az2, RAK$M$uaz,RAK$M$vaz,RAK$M$paz,RAK$M$taz),
    c(RAK$M$d1, RAK$M$d2,  RAK$M$ud, RAK$M$vd, RAK$M$pd, RAK$M$td))
  d = dim(poles)
  k = d[1]
  for(i in 1:k)
    {
      G = focpoint(poles[i,1], poles[i,2] , col=6,  lab=AL[i] , UP=RAK$UP)  
    }

  i =3
  A1 = TOCART(poles[i,1], 90-poles[i,2])
  i= 4
  A2 =TOCART(poles[i,1],  90-poles[i,2])
  N = CROSS(A1, A2)

qpoint(A1$az,A1$dip , lab="U", UP=RAK$UP)
qpoint(A2$az,A2$dip , lab="V", UP=RAK$UP)
qpoint(N$az, N$dip , lab="N", UP=RAK$UP)
    
  p1 = AXpoint(UP=RAK$UP)
   qpoint(p1$az, p1$dip , lab="P1", UP=RAK$UP)

  p2 = AXpoint(UP=RAK$UP)
   qpoint(p2$az, p2$dip , lab="P2", UP=RAK$UP)

  RM = getM(p1, p2)


  U1 = ROT(A1, RM)
  V1 = ROT(A2,  RM)
  N1 = ROT(N,  RM)

qpoint(U1$az,U1$dip , col=4, lab="U1", UP=RAK$UP)
qpoint(V1$az,V1$dip ,col=4, lab="V1", UP=RAK$UP)
qpoint(N1$az, N1$dip ,col=4, lab="N1", UP=RAK$UP)

FM = list()
  
  for(i in 1:k)
    {
      G = TOCART(poles[i,1], 90-poles[i,2])
      G1  = ROT(G,  RM)
      if(G1$dip>90)
        {

          G1$dip = 180-G1$dip
          G1$az = G1$az+180

        }
      FM[[i]]= G1
      qpoint(G1$az, G1$dip, lab=AL[i], UP=RAK$UP, col=2)
    }

  #
  #  the F and G planes are determined by the U and V
M = RAK$M
  
  M$az1 = FM[[1]]$az 
  M$d1 = 90-FM[[1]]$dip

  M$az2 = FM[[2]]$az
  M$d2 = 90-FM[[2]]$dip
  
  M$uaz = FM[[3]]$az
  M$ud = 90-FM[[3]]$dip

  M$vaz = FM[[4]]$az
  M$vd = 90-FM[[4]]$dip
  
  M$paz = FM[[5]]$az
  M$pd = 90-FM[[5]]$dip

  M$taz = FM[[6]]$az
  M$td = 90-FM[[6]]$dip

  RAK2 = MRake(M)
   RAK2$UP= RAK$UP
  RAK2$PTS = RAK$PTS
    RAK = SetMech(RAK2)

  dev.set(which =dev.next())
  Simplerfoc(RAK2)
return(RAK2)
  
}
###################

MROTATE<-function(pfile)
{

      # net(1)
  RAK1 = seeMech(pfile)

  poles=cbind(c(RAK1$F$az,RAK1$G$az,RAK1$P$az,RAK1$T$az,RAK1$V$az,RAK1$U$az),
    c(RAK1$F$dip,RAK1$G$dip,RAK1$P$dip,RAK1$T$dip,RAK1$V$dip,RAK1$U$dip))
      
F = focpoint(RAK1$F$az, RAK1$F$dip, col=6,  lab="F", UP=RAK1$UP)
G = focpoint(RAK1$G$az, RAK1$G$dip, col=6,  lab="G", UP=RAK1$UP)  
P = focpoint(RAK1$P$az, RAK1$P$dip, col=6,  lab="P", UP=RAK1$UP)
T = focpoint(RAK1$T$az, RAK1$T$dip, col=6,  lab="T", UP=RAK1$UP)
V = focpoint(RAK1$V$az, RAK1$V$dip, col=6,  lab="V", UP=RAK1$UP)
U = focpoint(RAK1$U$az, RAK1$U$dip, col=6,  lab="U", UP=RAK1$UP)

AL = c("F", "G", "P", "T", "V", "U")
FX =c(F$x, G$x, P$x, T$x, V$x, U$x)
FY =c(F$y, G$y, P$y, T$y, V$y, U$y)
k = identify(FX, FY, n=1)
print(paste("found axis", AL[k]))

North = TOCART.DIP(poles[k,1], poles[k,2])
  
  p = AXpoint(UP=TRUE)
  M = getM(North, p)


  
  Fvec = TOCART.DIP(RAK1$F$az, RAK1$F$dip)
  FN = ROT(Fvec, M)
  NF = TOSPHERE.DIP(FN$x, FN$y, FN$z)
  Gvec = TOCART.DIP(RAK1$G$az, RAK1$G$dip)
  GN = ROT(Gvec, M)
   NG = TOSPHERE.DIP(GN$x, GN$y, GN$z)
  Uvec = TOCART.DIP(RAK1$U$az, RAK1$U$dip)
  UN = ROT(Uvec, M)
   NU = TOSPHERE.DIP(UN$x, UN$y, UN$z)
  Vvec = TOCART.DIP(RAK1$V$az, RAK1$V$dip)
  VN = ROT(Vvec, M)
   NV = TOSPHERE.DIP(VN$x, VN$y, VN$z)
  Pvec = TOCART.DIP(RAK1$P$az, RAK1$P$dip)
  PN = ROT(Pvec, M)
   NP = TOSPHERE.DIP(PN$x, PN$y, PN$z)
  Tvec = TOCART.DIP(RAK1$T$az, RAK1$T$dip)
  TN = ROT(Tvec, M)
   NT = TOSPHERE.DIP(TN$x, TN$y, TN$z)


   NEWM = list(az1=NF$az, d1=NF$dip,  az2=NG$az, d2=NG$dip,  uaz=NU$az, ud=NU$dip,
     vaz=NV$az, vd=NV$dip,  paz=NP$az, pd =NP$dip,  taz=NT$az, td=NT$dip)

  RAK = MRake(NEWM)
   RAK  = SetMech(RAK)
  RAK = MRake(RAK$M)
  
  RAK$name = RAK1$name
  RAK$PTS = RAK1$PTS
  RAK$UP = RAK1$UP
  RAK$M1 = NEWM
  Simplerfoc(RAK)
  return(RAK)
  
    }
#############
AROTATE<-function(North, East, Down)
{

      # net(1)
      p = AXpoint(UP=TRUE)
      r = sqrt(p$gx*p$gx+p$gy*p$gy)
  while(r<=1)
    {  
      M = getM(North, p)
      GN = ROT(North, M)
      GE = ROT(East, M)
      GZ = ROT(Down, M)


      #  tests
      a1=DOT(GN, GE)
      a2=DOT(GE, GZ)
      a3=DOT(GZ, GN)
# print(paste(sep=" ", "TESTS:", a1, a2, a3))

      fpoint(North$az, North$dip, col=4, UP=TRUE);
      # uppoint(North, col=4)
      # uppoint(East, col=3)
     #  uppoint(Down, col=2)

      uppoint(GN)
      uppoint(GE)
      uppoint(GZ)

      upvec(GN, col=4)
      upvec(GE, col=3)
      upvec(GZ, col=2)


      
      B1 = list(GN=GN, GE=GE, GZ=GZ)
      pplanes(B1)
     
      p = AXpoint(UP=TRUE)
      r = sqrt(p$gx*p$gx+p$gy*p$gy)
      if(r>1)
        {
          B1 = list(GN=GN, GE=GE, GZ=GZ)
          break;
        }
      
      # net(1)

      
    }

  return(B1)
}





pplanes<-function(B1)
{
                                        #net(1)
  GE = B1$GE
  GZ = B1$GZ
  GN = B1$GN
  
  
  uppoint(GN)
  uppoint(GE)
  uppoint(GZ)
  
  upvec(GN, col=4)
  upvec(GE, col=3)
  upvec(GZ, col=2)
  
  plunge = GE$dip
  ang = GE$az
  
  ang = GE$az-90
                                        # print(paste(sep=" ",  "GN$az=", GN$az ," GN$dip=", GN$dip ))          
    if(plunge>90)
      {
  lowplane( ang, plunge,UP=TRUE, col=3 )
}
  else
    {
  lowplane( ang, plunge,UP=FALSE, col=1 )
}
  
                                        #   
  plunge = GZ$dip
  ang = GZ$az
  ang = GZ$az+90
                                        #  print(paste(sep=" ",  "GN$az=", GN$az ," GN$dip=", GN$dip ))
  
                                        #   print(paste(sep=" ",  "AZ=", ang ," PLUNGE=",  plunge))
      if(plunge<=90)
      {
  lowplane( ang, plunge,UP=TRUE, col=2 )
}
  else
    {
  lowplane( ang, plunge,UP=FALSE, col=5 )
}
  
  
                                        #upvec(FLIP(GN), col=5)

}
# LocalWords:  deltau
