############  source("/home/lees/Progs/R_stuff/prot.temp.R")
srot<-function(dat, i)
{
###  rotate a seismogram by i degrees
###  input is Nx3 matrix with vertical, N-S, E-W components
  ang = i
  rseis=grotseis(ang, flip=FALSE)
  ascd<-dat %*% rseis
  pseis2(ascd)
  title(paste(sep=" ", "Angle =", i))
invisible(ascd)
}

pmosel<-function(dat, ex, PS=FALSE)
{
if(missing(PS)) { PS=FALSE }
W =ptraceW(dat, c(min(ex), max(ex)) , tim=ex)
g=plocator(2)
gwin  = g$x
wex  =(gwin*(diff(range(ex))/4)+min(ex))

while(length(gwin)>=2)
{

owex = wex
oW =W
wex  =(gwin*(diff(range(ex))/4)+min(ex))
W = ptraceW(dat, wex, tim=ex)
g=plocator(2)
abline(v=gwin)
gwin  = g$x
}

return(list(win=owex, s=oW))

}

#########################################################################
ptraceW<-function(ascd, K, tim=1)
  {


    
 if(missing(tim))
    {
    ex = 1:length(ascd[,1])
  }
    else
      {

        ex = tim
      }
 if(missing(K))
    {
    K = c(min(ex), max(ex))
  }

 flag = ex>K[1] & ex<=K[2]



 a2 = ascd
mn = apply(ascd, 2, "mean")
b2 = sweep(ascd, 2, mn)
 
rn = apply(b2, 2, "range")
dn = diff(rn)
deltan = max(dn)
 
 

xtics= pretty(ex)

a2[,1] =   3+((b2[,1]-rn[1,1]) /(rn[2,1]-rn[1,1]))*(dn[1]/deltan)
a2[,2] =   2+((b2[,2]-rn[1,2])/(rn[2,2]-rn[1,2]))*(dn[2]/deltan)
a2[,3] =   1+((b2[,3]-rn[1,3])/(rn[2,3]-rn[1,3]))*(dn[3]/deltan)

 xtend = max(ex) + diff(range(ex))*0.25

rex = 4*(ex-min(ex))/(diff(range(ex)))
rtend = 4*(xtend-min(ex))/(diff(range(ex)))
rtics = 4*(xtics-min(ex))/(diff(range(ex)))


plot(range(c(rex, rtend) ), range(a2), asp=1, type="n", axes=FALSE, xlab="Time, s", ylab="Component")
axis(1,tck=.03,at=rtics,lab=xtics )
 axis(2,tck=.03,at=c(1.5, 2.5, 3.5), lab=c("T", "R", "V") )

box()

 g1 = max(rex)+ diff(range(rex))*0.05
 g2 = rtend 
 fudge = (g2-g1)*.01

f1 = 1.5
 f2 = f1+(g2-g1)

 f3 = 2.5
 f4 = f3+(g2-g1)

 rad =  g1+((b2[,2]-rn[1,2])/(rn[2,2]-rn[1,2]))*(g2-g1) 

  vert = f3+((b2[,1]-rn[1,1]) /(rn[2,1]-rn[1,1]))*(f4-f3)
 
 tran = f1+((b2[,3]-rn[1,3])/(rn[2,3]-rn[1,3]))*(f2-f1)

 rect(g1-fudge , f3-fudge, g2+fudge, f4+fudge)
 rect(g1-fudge , f1-fudge, g2+fudge, f2+fudge)

 text(g1-fudge, f4+fudge, "Vert", pos=3)
 text(g1-fudge, f2+fudge, "Trans", pos=3)
 text((g1+g2)/2, f1, "Radial", pos=1)
    

lines(rex,a2[,1], col=1)
lines(rex,a2[,2], col=1)
lines(rex,a2[,3], col=1)


lines(rex[flag],a2[flag,1], type='l', col=2)
#  points(rex[flag],a2[flag,1], col=2)
lines(rex[flag],a2[flag,2], col=2)
lines(rex[flag],a2[flag,3], col=2)


lines(rad[flag],vert[flag])
 lines(rad[flag], tran[flag])
points(rad[flag], tran[flag], col=4, cex=0.6)
 
invisible(list(rex=rex, rad=rad, tran=tran, flag=flag))

  }
####################################
