#############  R programs for working with reftek files

###  source("/home/lees/Progs/R_stuff/reftek.R")



###  first run getLLpos.prl *.log
##  to extract the  positions
###    logdir = "/home/lees/Site/Hengil/LOGS"
### pos = system(paste(sep='',"ls ",  logdir, "/*.pos"), intern=TRUE)


###  OLD: getlogs(logdir, DLAT =DD$lat, DLON =DD$lon)
###  DASlocs = getlogs(pos, DLAT =DD$lat, DLON =DD$lon)


###   pos = system(paste(sep='',"ls ",  logdir, "/*.pos"), intern=TRUE)
###   pos = system(paste(sep='',"ls ",  logdir, "/2005:19*.pos"), intern=TRUE)

getlogs<-function(APOSFN, DLAT=c(-90,90), DLON=c(0, 360) )
  {
    if(missing(DLAT)) DLAT=c(-90,90)
    if(missing(DLON)) DLON=c(0, 360)
    
    LOCS = list()
    vn = vector()
    vlat = vector()
    vlon = vector()
    vzee = vector()
    vt1 = vector()
    vt2 = vector()
    
    K = 1
    for(i in 1:length(APOSFN))
      {


        FN = APOSFN[i]
        das1 = substr(FN, 5, 8)

        A = scan(file=FN, list(t1='', gps='', pos='', ns='', ew='', el1=''))

        tim2 =matrix( as.numeric(unlist(strsplit(split=":", A$t1))), ncol=4, byrow=TRUE)


        ns = matrix( unlist(strsplit(split=":", A$ns)), ncol=3, byrow=TRUE)

        NSsign = rep(1, length(A$ns))

        nsdeg =  ns[,1]

        gs = grep("S", nsdeg)
        NSsign[gs] = -1

        ns[,1] = substr(ns[,1], 2,3)

        NS = matrix( as.numeric(ns), ncol=3, byrow=FALSE)

#####
        ew = matrix( unlist(strsplit(split=":", A$ew)), ncol=3, byrow=TRUE)

        EWsign = rep(1, length(A$ew))

        ewdeg =  ew[,1]

        gw = grep("W", ewdeg)
        EWsign[gw] = -1

        ew[,1] = substr(ew[,1], 2,4)

        EW = matrix( as.numeric(ew), ncol=3, byrow=FALSE)

        LAT = NSsign * (NS[,1]+NS[,2]/60+NS[,3]/(3600))
        LON = EWsign * (EW[,1]+EW[,2]/60+EW[,3]/(3600))


        zedM = as.numeric(sub('M', '', A$el1))

        tit = paste(sep = ' ', i, "of", length(APOSFN), "***** DAS=" ,das1, "N=", length(LAT))
        ###  plot(LON, LAT, type='n', main=tit )

        MT = tim2
        tees = MT[,1]+MT[,2]/24+MT[,3]/(24*60)+MT[,4]/(24*3600)

        
        lon360 = fmod(LON, 360.0)

       
        lats = LAT
        lons = lon360
        nams = paste(sep=":", das1,1:length(LAT))
        zees = zedM
        t1 = tees

        P = list(name=nams, lat=lats, lon=lons, z=zees, t=tees)

        w = which(lons>DLON[1] & lons<DLON[2]  & lats>DLAT[1] & lats<DLAT[2])
        
        lats = lats[w]
        lons = lons[w]
        nams = nams[w]
        zees = zees[w]
        t1 = t1[w]
       
        if(length(lats)>1)
          {

            cols = tomo.col(100)
            t3 = round(RESCALE(t1, 1, 100, min(t1, na.rm=TRUE), max(t1, na.rm=TRUE)))

            snam = unlist(strsplit(nams, ":"), use.names = TRUE)
            DAS = unique(snam[seq(from=1, to=length(snam), by=2)])
            ind = snam[seq(from=2, to=length(snam), by=2)]

            gd = GreatDist(min(lons), min(lats), max(lons), max(lats)   )
            
            tit = paste(sep='  ', "DAS=",DAS, "i=", i, "N=", length(lats), "KM diag=", format.default(gd$dkm, digits=4, trim=FALSE))
            
            ##  plot(lons, lats, type='p', xlim=DLON, ylim=DLAT, main=tit )
            plot(lons, lats, type='n', main=tit )
            points(lons, lats, pch=3, col=cols[t3])
            
            text(lons, lats, labels=ind, pos=3, col=cols[t3])

            BL = locator(type="p", pch=11, col=3)
            k = length( BL$x)
            if(k<2)
              {

                ww = 1:length(lons)
                
                A1 = TOCART(lons,lats)

                B1 =  TOSPHERE(mean(A1$x), mean(A1$y), mean(A1$z) )

                points(fmod(B1$az, 360) , B1$dip, pch=11, col=3, cex=2)

                LON = list(mean=mean(lons), med=median(lons) )
                LAT =  list(mean=mean(lats), med=median(lats) )
                ZEE =  list(mean=mean(zees), med=median(zees) )
                
               ##  print(LON)
               ##  print(LAT)
                
                points(LON$mean, LAT$mean, type='p', pch = 15, col=2)
                points(LON$med, LAT$med, type='p', pch = 16, col=4)
                text(LON$mean, LAT$mean, labels="Mean", col=2, pos=1)
                text(LON$med, LAT$med, labels="Median", col=4, pos=1)

                vn = c(vn, DAS)
                vlat =c(vlat, LAT$mean)
                vlon =c(vlon, LON$mean)
                vzee =c(vzee, ZEE$mean)

                vt1 = c(vt1, min(t1, na.rm=TRUE))
                vt2 = c(vt2, max(t1, na.rm=TRUE))
    
                  
                LOCS[[K]] = list(DAS=DAS, L1=c(LON$mean, LAT$mean), L2=c(LON$med, LAT$med), TEE=range(t1), ww=ww, PNTS=P)
                K = K+1
              }
            else
              {
                for(j in seq(from=1, to=k, by=2))
                  {
                    ww = which(lons>BL$x[j] & lons<BL$x[j+1]  & lats>BL$y[j] & lats<BL$y[j+1] )


                    A1 = TOCART(lons[ww],lats[ww])

                    B1 =  TOSPHERE(mean(A1$x), mean(A1$y), mean(A1$z) )

                    points(fmod(B1$az, 360) , B1$dip, pch=11, col=3, cex=2)

                    
                    
                    LON = list(mean=mean(lons[ww]), med=median(lons[ww]) )
                    LAT =  list(mean=mean(lats[ww]), med=median(lats[ww]) )
                     ZEE =  list(mean=mean(zees), med=median(zees) )
                
                   ##  print(LON)
                   ##  print(LAT)
                   ##   print(range(t1[ww]))
                    
                    points(LON$mean, LAT$mean, type='p', pch = 15, col=2)
                    points(LON$med, LAT$med, type='p', pch = 16, col=4)
                    text(LON$mean, LAT$mean, labels="Mean", col=2, pos=1)
                    text(LON$med, LAT$med, labels="Median", col=4, pos=1)
                    vn = c(vn, DAS)
                    vlat =c(vlat, LAT$mean)
                    vlon =c(vlon, LON$mean)
                    vzee =c(vzee, ZEE$mean)
                    
                    vt1 = c(vt1, min(t1[ww], na.rm=TRUE))
                    vt2 = c(vt2, max(t1[ww], na.rm=TRUE))
                    
                    LOCS[[K]] = list(DAS=DAS, L1=c(LON$mean, LAT$mean), L2=c(LON$med, LAT$med), TEE=range(t1[ww]), ww=ww, PNTS=P )
                    K = K+1
 
                  }
                

              }

            locator()
          }
        else
          {
            print("SKIP this record")
            
          }
      }


  
   ###  return(LOCS)
    return(list(K=K, DAS=vn, lat=vlat, lon=vlon, z=vzee, t1=vt1, t2=vt2, LOCS=LOCS))
  }


###  source("/home/lees/Progs/R_stuff/reftek.R")

getlogsOLD<-function(pos, DLAT=c(-90,90), DLON=c(0, 360) )
  {
    if(missing(DLAT)) DLAT=c(-90,90)
    if(missing(DLON)) DLON=c(0, 360)
    
    LOCS = list()
    vn = vector()
    vlat = vector()
    vlon = vector()
    vzee = vector()
    vt1 = vector()
    vt2 = vector()
    
    K = 1
    for(i in 1:length(pos))
      {

 
        
        p1 = pos[i]
        P = scan(p1, list(name='', lat=0, lon=0, z=0, t=''))
        MT = matrix(as.numeric(unlist(strsplit(P$t, split=":"))), ncol=4, byrow=TRUE)
        tees = MT[,1]+MT[,2]/24+MT[,3]/(24*60)+MT[,4]/(24*3600)
         
        P$lon = fmod(P$lon, 360.0)

        wmed = grep("MED", P$name)
        wsum = grep("SUM", P$name)

        lats = P$lat[-c(wsum, wmed)]
        lons = P$lon[-c(wsum, wmed)]
        nams = P$name[-c(wsum, wmed)]
        zees = P$z[-c(wsum, wmed)]
        t1 = tees[-c(wsum, wmed)]
        w = which(lons>DLON[1] & lons<DLON[2]  & lats>DLAT[1] & lats<DLAT[2])
        
        lats = lats[w]
        lons = lons[w]
        nams = nams[w]
        zees = zees[w]
        t1 = t1[w]
       
        if(length(lats)>1)
          {

            cols = tomo.col(100)
            t3 = round(RESCALE(t1, 1, 100, min(t1, na.rm=TRUE), max(t1, na.rm=TRUE)))

    
            
            snam = unlist(strsplit(nams, "\\."), use.names = TRUE)
            DAS = unique(snam[seq(from=1, to=length(snam), by=2)])
            ind = snam[seq(from=2, to=length(snam), by=2)]

            gd = GreatDist(min(lons), min(lats), max(lons), max(lats)   )
            
            tit = paste(sep='  ', DAS, i, length(lats), "KM diag=", format.default(gd$dkm, digits=4, trim=FALSE))
            
            ##  plot(lons, lats, type='p', xlim=DLON, ylim=DLAT, main=tit )
            plot(lons, lats, type='n', main=tit )
            points(lons, lats, pch=3, col=cols[t3])
            
            text(lons, lats, labels=ind, pos=3, col=cols[t3])

            BL = locator(type="p", pch=11, col=3)
            k = length( BL$x)
            if(k<2)
              {

                ww = 1:length(lons)
                
                A1 = TOCART(lons,lats)

                B1 =  TOSPHERE(mean(A1$x), mean(A1$y), mean(A1$z) )

                points(fmod(B1$az, 360) , B1$dip, pch=11, col=3, cex=2)

                LON = list(mean=mean(lons), med=median(lons) )
                LAT =  list(mean=mean(lats), med=median(lats) )
                ZEE =  list(mean=mean(zees), med=median(zees) )
                
               ##  print(LON)
               ##  print(LAT)
                
                points(LON$mean, LAT$mean, type='p', pch = 15, col=2)
                points(LON$med, LAT$med, type='p', pch = 16, col=4)
                text(LON$mean, LAT$mean, labels="Mean", col=2, pos=1)
                text(LON$med, LAT$med, labels="Median", col=4, pos=1)

                vn = c(vn, DAS)
                vlat =c(vlat, LAT$mean)
                vlon =c(vlon, LON$mean)
                vzee =c(vzee, ZEE$mean)

                vt1 = c(vt1, min(t1, na.rm=TRUE))
                vt2 = c(vt2, max(t1, na.rm=TRUE))
    
                  
                LOCS[[K]] = list(DAS=DAS, L1=c(LON$mean, LAT$mean), L2=c(LON$med, LAT$med), TEE=range(t1), ww=ww, PNTS=P)
                K = K+1
              }
            else
              {
                for(j in seq(from=1, to=k, by=2))
                  {
                    ww = which(lons>BL$x[j] & lons<BL$x[j+1]  & lats>BL$y[j] & lats<BL$y[j+1] )


                    A1 = TOCART(lons[ww],lats[ww])

                    B1 =  TOSPHERE(mean(A1$x), mean(A1$y), mean(A1$z) )

                    points(fmod(B1$az, 360) , B1$dip, pch=11, col=3, cex=2)

                    
                    
                    LON = list(mean=mean(lons[ww]), med=median(lons[ww]) )
                    LAT =  list(mean=mean(lats[ww]), med=median(lats[ww]) )
                     ZEE =  list(mean=mean(zees), med=median(zees) )
                
                   ##  print(LON)
                   ##  print(LAT)
                   ##   print(range(t1[ww]))
                    
                    points(LON$mean, LAT$mean, type='p', pch = 15, col=2)
                    points(LON$med, LAT$med, type='p', pch = 16, col=4)
                    text(LON$mean, LAT$mean, labels="Mean", col=2, pos=1)
                    text(LON$med, LAT$med, labels="Median", col=4, pos=1)
                    vn = c(vn, DAS)
                    vlat =c(vlat, LAT$mean)
                    vlon =c(vlon, LON$mean)
                    vzee =c(vzee, ZEE$mean)
                    
                    vt1 = c(vt1, min(t1[ww], na.rm=TRUE))
                    vt2 = c(vt2, max(t1[ww], na.rm=TRUE))
                    
                    LOCS[[K]] = list(DAS=DAS, L1=c(LON$mean, LAT$mean), L2=c(LON$med, LAT$med), TEE=range(t1[ww]), ww=ww, PNTS=P )
                    K = K+1
 
                  }
                

              }

            locator()
          }
        else
          {
            print("SKIP this record")
            
          }
      }


  
   ###  return(LOCS)
    return(list(K=K, DAS=vn, lat=vlat, lon=vlon, z=vzee, t1=vt1, t2=vt2, LOCS=LOCS))
  }
###  source("/home/lees/Progs/R_stuff/reftek.R")
