rotx <- function( deg )
  {
    rad1 = deg * 0.0174532;
    r = diag(3)
    r[2, 2] = cos(rad1)
    r[2, 3] = sin(rad1)
    r[3, 3] = r[2, 2]
    r[3, 2] = -r[2, 3]
    return(r)

  }
roty <- function( deg )
  {
    rad1 = deg * 0.0174532;
    r = diag(3)
    r[1, 1] = cos(rad1)
    r[3, 1] = sin(rad1)
    r[3, 3] = r[1, 1]
    r[1, 3] = -r[3, 1]
    return(r)

  }
rotz <- function( deg )
  {
    rad1 = deg * 0.0174532;
    r = diag(3)
    r[1, 1] = cos(rad1)
    r[1, 2] = sin(rad1)
    r[2, 2] = r[1, 1]
    r[2, 1] = -r[1, 2]
    return(r)

  }
################################################
#######  source("/home/lees/Progs/R_stuff/rotate.R")

#######  Motate(x,y,z, -45, 30)
###  Jotate(x,y,z, -75)

###  Jotate(x,y,z, -90)


#######

################################################
Motate<-function(x,y,z, a1=(-45), i=30, type='l', rbow=rainbow(100), pch=19, labs=c("E", "N", "Z"), grid=TRUE, box=TRUE, xyproj=FALSE, title='' )
  {
###  plot a 3D (three-dimensional) projection giving the angles of views
    
    if(missing(rbow)) { rbow=rainbow(100) }
    if(missing(pch)) {  pch=16   }
    if(missing(labs)) {    labs=c("E", "N", "Z")  }
    if(missing(grid)) { grid=TRUE   }
    if(missing(box)) {  box=TRUE   }
    if(missing(xyproj)) {   xyproj=FALSE   }
    if(missing(type)) {     type='p'   }

    
    xtic = pretty(range(x))
    ytic =  pretty(range(y))
    ztic =  pretty(range(z))

    rx = range(xtic)
    ry = range(ytic)
    rz = range(ztic)
    
    D =  cbind(x,y,z)
    
    pbox = cbind(
      c(rx[1], rx[2], rx[1], rx[2],rx[1], rx[2],rx[1], rx[2]),
      c(ry[1], ry[1], ry[2], ry[2],ry[1], ry[1], ry[2], ry[2]),
      c(rz[1],rz[1],rz[1],rz[1],rz[2],rz[2],rz[2],rz[2]))

    if(exists("cols")==FALSE)
      {
        cols = floor(99* (z-min(z))/(max(z)-min(z)))+1
      }
                                        #  cols = floor(99* (z-min(z))/(max(z)-min(z)))+1
    
    r1 = rotx(a1)
    
    r2 = rotz(i)

    R = r2 %*% r1
    
    g = D %*% R
    
    b = pbox %*% R 
    
    
     ####  plot(c(g[,1], b[,1]),c(g[,2], b[,2]) , type = 'n', col=rbow[cols] , axes=FALSE, ann=FALSE, asp=TRUE )
    plot(c(g[,1], b[,1]),c(g[,2], b[,2]) , type = 'n', col=rbow[cols] , axes=FALSE, ann=FALSE  )
    
    cz = g[,3]
    oz = order(cz)
    ### cols = floor(99* (cz-min(cz))/(max(cz)-min(cz)))+1


    
    if(type=='p')
      {
        points(g[oz,1],g[oz,2], col=rbow[cols[oz]], pch=pch )
      }
    if(type=='l')
      {
        # y1 = g[,1]
        # y2 = g[,2]
        lines(g[,1],g[,2])
          #  segments(y1[1:(k-1)], y2[1:(k-1)], y1[2:k], y2[2:k],  col=rbow[cols2[oz2]] )
      }

    

    if(box==TRUE)
      {
        lines(c(b[c(1,2,4,3,1),1]), c(b[c(1,2,4,3,1),2]), col=1)
        
        lines(c(b[c(5,6,8,7,5),1]), c(b[c(5,6,8,7,5),2]), col=2)
      }


    if(xyproj==TRUE)
      {
        oz2 = order(g[,1])
        cols2 = floor(99*(g[,1]-min(g[,1]))/(max(g[,1])-min(g[,1])))+1
 
        Dxy =  cbind(x,y,rep(min(ztic), length(x) ))
        gxy = Dxy %*% R

       y1 = gxy[,1]
       y2 = gxy[,2]
         k = length(y1)
        
        #  lines(x[ind], x[ind+tau], type='l', col=cols[colind[oz]])
        segments(y1[1:(k-1)], y2[1:(k-1)], y1[2:k], y2[2:k],  col=rbow[cols2[oz2]] )
       ##  lines(gxy[,1],gxy[,2], col=rbow[cols2[oz2]] )
      }

    ## segments(b[c(1,2,3,4),1] , b[c(1,2,3,4),2], b[c(5,6,7,8),1], b[c(5,6,7,8),2], col=c(3,3,4,4))
    
    ## text(c(b[c(1,2,4,3),1]), c(b[c(1,2,4,3),2]), labels=c(1,2,3,4), col=1)
    
    
    arrows(b[1,1], b[1,2], b[2,1], b[2,2], length=.1)
    arrows(b[1,1], b[1,2], b[5,1], b[5,2], length=.1)
    arrows(b[1,1], b[1,2], b[3,1], b[3,2], length=.1)




    text(b[2,1], b[2,2], labels=labs[1], pos=4)
    text(b[5,1], b[5,2], labels=labs[3], pos=3)
    text(b[3,1], b[3,2], labels=labs[2], pos=4)

    


    bg1 = cbind(xtic, rep(min(ytic), length=length(xtic)),rep(min(ztic), length=length(xtic))) 
    bg2 = cbind(xtic, rep(max(ytic), length=length(xtic)),rep(min(ztic), length=length(xtic)))

    if(grid==TRUE)
      {

        L1 = bg1   %*% r2  %*% r1
        L2 = bg2   %*% r2  %*% r1

        segments(L1[,1], L1[,2], L2[,1], L2[,2], lty=2)

        bg1 = cbind( rep(min(xtic), length=length(ytic)), ytic,  rep(min(ztic), length=length(ytic))) 
        bg2 = cbind( rep(max(xtic), length=length(ytic)), ytic,  rep(min(ztic), length=length(ytic)))
        
        L1 = bg1   %*% r2  %*% r1
        L2 = bg2   %*% r2  %*% r1

        segments(L1[,1], L1[,2], L2[,1], L2[,2], lty=2)
      }

    if(missing(title))
      {
    title(paste(sep=' ', "alph=", a1, "phi=", i))
  }
    else
      {

        title(main=title)
      }
    
    return(R)

  }
################################################
#######  source("/home/lees/Progs/R_stuff/rotate.R")
#######  Motate(x,y,z, -45, 30)

Aotate<-function(x,y,z, a1, iseq=seq(from=0, to=360, by=10), ...)
  {
    if(missing(iseq)) {  iseq=seq(from=0, to=360, by=10) }

    for(i in iseq)
      {
        
        ro = Motate(x,y,z, a1, i, ...)
        
     
        locator(1)
        
      }

  }
###



###  Jotate(x,y,z, -75)


Jotate<-function(x,y,z, a1, iseq=seq(from=0, to=360, by=10), sta=Dsta )
  {
    if(missing(iseq)) {  iseq=seq(from=0, to=360, by=10) }
     if(missing(sta))
       {  psta= FALSE }
     else
       {  psta = TRUE }
   
    for(i in iseq)
      {
        
        ro = Motate(x,y,z, a1, i)
        
        if(psta==TRUE)
          {
            rsta = sta %*% ro
            points(rsta[,1],rsta[,2], pch=6)
          }
        locator(1)
        
      }

  }
###  Jotate(x,y,z, -75)
################################################
#######  source("/home/lees/Progs/R_stuff/rotate.R")

Xotate<-function(x,y,z, a1, iseq=seq(from=0, to=360, by=10), sta=Dsta )
  {
    if(missing(iseq)) {  iseq=seq(from=0, to=360, by=10) }
     if(missing(sta))
       {  psta= FALSE }
     else
       {  psta = TRUE }


    jseq = seq(from=0, to=a1, by=-5)

    
    for(i in jseq)
      {
        ro = Motate(x,y,z, i, 0)
           if(psta==TRUE)
          {
            rsta = sta %*% ro
            points(rsta[,1],rsta[,2], pch=6)
          }
         locator(1)
      }
    
    for(i in iseq)
      {
        
        ro = Motate(x,y,z, a1, i)
        
        if(psta==TRUE)
          {
            rsta = sta %*% ro
            points(rsta[,1],rsta[,2], pch=6)
          }
        locator(1)
        
      }

  }
