##########  source("toep.R")

##############################################

toep<-function(column,row)
  {

####	TOEP Toeplitz matrix
####
####	mat=toep(column,row)
####
####	The length(column) x length(row) element toeplitz matrix is generated from the
####	column and row vectors.  If unspecified, the column vector is entered after the
####	prompt from the keyboard, and the default assignment row=column is used.  For
####	column and row matrices, the initial column and row vectors, respectively, are
####	used.  For unequal column and row vector initial elements, the column vector
####	initial element is used for the toeplitz matrix.

####	Implemented using MATLAB 5.3.1
####
####	Example:
####
####	 m=toep((1:3)*(1+i),c(1+i, (4:6)*(1-i)))
####
####	m =toep(complex(real=1:3, imaginary=1:3),  c(complex(real=1, imaginary=1), complex(real=(4:6), imaginary=-1*(4:6))))
####
####	   1.0000 + 1.0000i   4.0000 - 4.0000i   5.0000 - 5.0000i   6.0000 - 6.0000i
####	   2.0000 + 2.0000i   1.0000 + 1.0000i   4.0000 - 4.0000i   5.0000 - 5.0000i
####	   3.0000 + 3.0000i   2.0000 + 2.0000i   1.0000 + 1.0000i   4.0000 - 4.0000i
####
####	Copyright (c) 2000
####	Tom McMurray
####	mcmurray@teamcmi.com

####	assign default input column vector



####	while column is unsupported, enter supported column or return for 0 output

####	if column is a matrix, modify to the initial column vector


####	else if column is a row vector, modify to a column vector
   

####	assign default input row vector


if(missing(row)) { row = column };



####	while row is unsupported, enter supported row or return for row=column

####	if row is a matrix, modify the initial row vector to a column vector


####	if column(1)~=row(1), use column vector initial element


####	generate column vector from input vectors


sizecol1=length(column)
sizerow2=length(row)

vec=c(row[seq(from=sizerow2, by=-1, to=2)],column)


lenvec=sizecol1+sizerow2-1;

####	generate toeplitz matrix

mat=matrix(0, ncol=sizerow2,nrow=sizecol1);


for(k in 1:sizerow2)
  {
   k1=k-1;
   mat[,k]=vec[seq(from=sizerow2-k1, to=lenvec-k1)];
 }

return(mat)


}
