

### library(sm)
##   source("/home/lees/Progs/R_stuff/topo.R")

###
CALCOL<-function()
  {
    calcol = scan(file="/home/lees/Site/NAndes/cal_color.cptR", list(z1=0, r1=0,g1=0,b1=0, z2=0,  r2=0,g2=0,b2=0, note=" ") )
    
    coltab = cbind(calcol$r1, calcol$g1, calcol$b1,calcol$r2, calcol$g2, calcol$b2)
    
    coltab = rbind(coltab, coltab[length(calcol$r1),])
    return(list(calcol , coltab))
           
  }
xytopper<-function(jtop)
  {
    ##  PROJ.DATA$type=2

    jlon = unique(jtop$lon)
    jlat = unique(jtop$lat)
    
    
    jlons  = GLOB.XY( rep(jlat[which.min(jlat)], length=length(jlon)),  jlon   )
    jlats  = GLOB.XY(  jlat , rep(jlon[which.min(jlon)],length=length(jlat))    )
    
    jx = sort(jlons$x)
    jy = sort(jlats$y)
    return( list(jx=jx, jy=jy) )
  }
##   source("/home/lees/Progs/R_stuff/topo.R")

jtoppersp<-function(jtop, win=MLOC)
  {


    ### read in the topo information from the GLOBE database
    
    ### first:  jtop = scan(file='jap.topo', list(lon=0, lat=0, z=0))

    if(missing(win))
      {
        win=NULL
      }
    ###
    flg = jtop$lon>=win$lon[1]&jtop$lon<=win$lon[2]&jtop$lat>=win$lat[1]&jtop$lat<=win$lat[2]

    jlon = unique(jtop$lon)
    jlat = unique(jtop$lat)
    
    
    jlons  = GLOB.XY( rep(jlat[which.min(jlat)], length=length(jlon)),  jlon   )
    jlats  = GLOB.XY(  jlat , rep(jlon[which.min(jlon)],length=length(jlat))    )
    
    jx = sort(jlons$x)
    jy = sort(jlats$y)

    
    jz = matrix(jtop$z, ncol=length(jx), nrow=length(jy), byrow=TRUE)

    
    TZ = t(jz)
    
    dz = dim(TZ)
    
    TZ = TZ[,rev(1:dz[2])]
    
    CZ = TZ
    TZ[TZ<0] = NA
    calcol = scan(file="/home/lees/Site/NAndes/cal_color.cptR", list(z1=0, r1=0,g1=0,b1=0, z2=0,  r2=0,g2=0,b2=0, note=" ") )
    
    coltab = cbind(calcol$r1, calcol$g1, calcol$b1,calcol$r2, calcol$g2, calcol$b2)
    
    coltab = rbind(coltab, coltab[length(calcol$r1),])
    
    rng = range(TZ[!is.na(TZ)])
    ncol = 100
    levs = seq(from=rng[1], to=rng[2], length=100)
    
    
    brs = c(calcol$z1[1], calcol$z2,  calcol$z2[length(calcol$z2)]+10000)
    Cs = CZ
    
    fs = findInterval(Cs, brs)
    df = diff(brs)
    
    coldis = (Cs - brs[fs])/df[fs]
    
    newcol = list(r= round(coltab[fs,1]+coldis*(coltab[fs,4]-coltab[fs,1]  )),
      g = round(coltab[fs,2]+coldis*(coltab[fs,5]-coltab[fs,2]  )),
      b = round(coltab[fs,3]+coldis*(coltab[fs,6]-coltab[fs,3]  )))

 
    Collist = rgb(newcol$r/255, newcol$g/255, newcol$b/255)
    
    Mollist = matrix(data=Collist, ncol=dz[2], nrow=dz[1])
    
    PMAT = persp(jx, jy , TZ, theta = 0, phi = 90, r=4000, col=Mollist[1:479, 1:359] , scale = FALSE,
      ltheta = 120, lphi=60, shade = 0.75, border = NA, expand=0.001, box = FALSE )

dMOL = dim(Mollist)       
    

        PMAT = persp(jx, jy , TZ, theta = 0, phi = 90, r=4000, col=Mollist[1:dMOL[1], 1:dMOL[2]] , scale = FALSE,
      ltheta = 120, lphi=60, shade = 0.75, border = NA, expand=0.001, box = FALSE )


    
    
    invisible(PMAT)
  }

trans3d <- function(x,y,z, pmat) {
  tr <- cbind(x,y,z,1) %*% pmat
  list(x = tr[,1]/tr[,4], y= tr[,2]/tr[,4])
}
###################################
makeimag<-function(x,y,z, d=0.7, col=terrain.colors(50), dx=100)
{
if(missing(d)) { d = 0.7 }
if(missing(col)) { col=terrain.colors(50) }
if(missing(dx)) { dx=100   }

  
JSUR = data.frame(cbind(x=x, y=y,  z=z))
JSUR.kr <- surf.gls(3, expcov, JSUR, d=d)
prsurf <- prmat(JSUR.kr,   min(JSUR$x), max(JSUR$x), min(JSUR$y), max(JSUR$y) , dx)
dlev = (max(JSUR$z)-min(JSUR$z))/25

image(prsurf, col=col , add=TRUE)



invisible(prsurf)
}

##   source("topo.R"); save.image()


###################################
GetColList<-function(ZZ, calcol)
  {
    ##  given a matrix and a color scheme
    ###  return a matrix of colors for persp
    TZ = ZZ$z

    dz = dim(TZ)
    
    
    rng = range(TZ[!is.na(TZ)])
    ncol = 100
    levs = seq(from=rng[1], to=rng[2], length=100)
    
    brs = c(calcol$z1[1], calcol$z2,  calcol$z2[length(calcol$z2)]+10000)
    Cs = TZ
    
    fs = findInterval(Cs, brs)
    df = diff(brs)
    
    coldis = (Cs - brs[fs])/df[fs]
    
    newcol = list(r= round(coltab[fs,1]+coldis*(coltab[fs,4]-coltab[fs,1]  )),
      g = round(coltab[fs,2]+coldis*(coltab[fs,5]-coltab[fs,2]  )),
      b = round(coltab[fs,3]+coldis*(coltab[fs,6]-coltab[fs,3]  )))

    newcol$r[is.na(newcol$r)] = 0
    newcol$g[is.na(newcol$g)] = 0
    newcol$b[is.na(newcol$b)] = 0

    Collist = rgb(newcol$r/255, newcol$g/255, newcol$b/255)

    Collist[is.na(newcol$r)] = NA
    
    Mollist = matrix(data=Collist, ncol=dz[2], nrow=dz[1])

    return(Mollist)
  }

###################################


####### PersPROJmap(JAPmap, PMAT, WIN=MLOC,  ADD=TRUE, ASP=TRUE, COL=TRUE) 
PersPROJmap<-function(cmp, PMAT, pts=NULL, ADD=TRUE, WIN=NULL, ASP=TRUE, NUM=FALSE,
                      COL=FALSE, SEL=NULL, PLOT=TRUE, dcol=1)
{
#  plot a map created from a lees map (see above)
  if(missing(ASP)) { ASP = FALSE }
  if(missing(ADD)) { ADD = TRUE }
  if(missing(pts)) { pts = NULL }
  if(missing(NUM)) { NUM = FALSE }
  if(missing(COL)) { COL = FALSE }
  if(missing(WIN)) { WIN = NULL }
  if(missing(PLOT)) { PLOT = TRUE }
  if(missing(SEL)) { SEL = 1:length(cmp$lon) }
  
  if(missing(dcol)) { dcol = 1 }

  
  DX = range(unlist(cmp$lon))
  DY = range( unlist(cmp$lat))
  if(!is.null(pts))
    {
      PX = range(unlist(pts$lon))
      PY = range( unlist(pts$lat))
    }


  if(ADD==FALSE)
    {
      if( is.null(WIN) )
        {
          PKM = GLOB.XY(c(unlist(cmp$lat), pts$lat), c(unlist(cmp$lon), pts$lon)  )
        }
      else
        {
          PKM = GLOB.XY( WIN$lat,  WIN$lon) 
        }
      
     
      tem = trans3d(PKM$x, PKM$y, rep(0, length(PKM$y)) , PMAT)
      EX = tem$x
      WHY = tem$y
     ##  lines(trans3d(xr,yr, f(xr,yr), res), col = "pink", lwd=2)
      
      if(ASP==TRUE)
        {
          dasp = 1
          ##  plot(EX, WHY, type='n', asp=dasp, ylab="North, km", xlab="East, km")
          ## plot(EX, WHY, type='n', asp=dasp, ann=FALSE, axes=FALSE)
        }
      else
        {
          dasp = NA
        }
      
      plot(EX, WHY, type='n', asp=dasp, ann=FALSE, axes=FALSE, ...)

    }
  
  if(PLOT==FALSE)
    {
      ###   print("PLOT==FALSE:  NOT PLOTTING LINES AND POINTS");
      return(0)
    }
  
  for(i in SEL)
    {
      PKM = GLOB.XY(   unlist(cmp$lat[i]), unlist(cmp$lon[i])  )
     
      tem = trans3d(PKM$x, PKM$y, rep(0, length(PKM$y)) , PMAT)
      EX = tem$x
      WHY = tem$y
      mcol = dcol
      if(COL==TRUE)
        {
          mcol = cmp$col[i]
        }
     
      if(cmp$kind[i] == 1)
        {
          points(EX, WHY, col=mcol)
        }
      if(cmp$kind[i] == 2)
        {
          lines(EX, WHY, col=mcol)
        }
      if(cmp$kind[i] == 3)
        {
          polygon(EX, WHY, col=gray(.95))
        }
      if(NUM==TRUE)
        {
          text(EX[1], WHY[1], labels=paste(sep=':', i, cmp$name[i]))
        }
    }
  
  if(!is.null(pts))
    {
      PKM = GLOB.XY( pts$lat, pts$lon )
     
        tem = trans3d(PKM$x, PKM$y, rep(0, length(PKM$y)) , PMAT)
      EX = tem$x
      WHY = tem$y
      points(EX, WHY, pch=6, cex=1.2)
      text(EX, WHY, labels=pts$name, cex=1.2, pos=4)
      
    }
}




jinv<-function(X, tol = sqrt(.Machine$double.eps))
{
  
    if (length(dim(X)) > 2 || !(is.numeric(X) || is.complex(X)))
        stop("X must be a numeric or complex matrix")
    if (!is.matrix(X))
        X <- as.matrix(X)
    Xsvd <- svd(X)
    if (is.complex(X))
        Xsvd$u <- Conj(Xsvd$u)
    Positive <- Xsvd$d > max(tol * Xsvd$d[1], 0)
    if (all(Positive))
        Xsvd$v %*% (1/Xsvd$d * t(Xsvd$u))
    else if (!any(Positive))
        array(0, dim(X)[2:1])
    else Xsvd$v[, Positive, drop = FALSE] %*% ((1/Xsvd$d[Positive]) *
        t(Xsvd$u[, Positive, drop = FALSE]))
}


#################################################################
###
##   source("/home/lees/Progs/R_stuff/topo.R")
##  PersAXESmap( JAPmap, PMAT, GRID=TRUE,  WIN=MLOC)

PersAXESmap<-function(cmp, PMAT, PRET=TRUE, GRID=FALSE, WIN=NULL, ...)
{
  
  if(missing(GRID)) { grid=FALSE }
  if(missing(WIN)) {  WIN=NULL }
  if(missing(PRET)) {  PRET=TRUE }

  u = par('usr')
  
  AA = trans3d(c(u[1], u[2]), c(u[3], u[4]), rep(0,2), jinv(PMAT))

  
  GG = XY.GLOB(AA$x, AA$y)

  
  
  if( is.null(WIN) )
    {
      rnglon = range(GG$lon)
      rnglon = fmod(rnglon, 360.);
      
      lats = pretty(range(GG$lat), 10)
      lons = pretty(rnglon, 10)
      
      LAT = min(lats)
      LON = min(lons)
  
    }
  else
    {
      rnglon = range(WIN$lon)
 
      rnglon = fmod(rnglon, 360.);
      
      lats = pretty(range(WIN$lat))
      lons = pretty(rnglon)
      
      LAT = min(WIN$lat)
      LON = min(WIN$lon)
      
    }

  lenlon = length(lons)
  lenlat = length(lats)

  if(PRET==TRUE)
    {
      x = pretty((lons)*60)/60
      xmins = 60*(x-floor(x))
      xdegs = floor(x)
      xdegs[xdegs>180] = floor(360-x)

      y = pretty((lats)*60)/60
      ymins = 60*(y-floor(y))
      ydegs = floor(y)
        

      lons = x
      lats = y
      LAT = min(lats)
      LON = min(lons)

    }
  
  PKM = GLOB.XY( rep(LAT,length(lons)) ,lons )

  
  tem = trans3d(PKM$x, PKM$y, rep(0, length(PKM$y)) , PMAT)
  EX = tem$x
  WHY = tem$y

  if(PRET==TRUE)
    {
      axis(1,at=EX, labels=FALSE )
      for(i in 1:length(xdegs))
        mtext(bquote(.(xdegs[i])*degree : .(xmins[i])*minute), at=EX[i],side=1 )

    }
  else
    {
      axis(1,at=EX, labels=lons, ...)
    }
  
  if(GRID==TRUE)
    {
      for( k in lons)
        {
          PKM = GLOB.XY( lats ,rep(k, length=lenlat)  )
            D = trans3d(PKM$x, PKM$y, rep(0, length(PKM$y)) , PMAT)
          lines(D$x, D$y, lty=2, col=grey(0.8))
        }
      #   abline( v=PKM$x, lty=2, col=grey(0.8))
      
    }
  
  
  PKM = GLOB.XY( lats,  rep(LON,length(lats)) )
  tem = trans3d(PKM$x, PKM$y, rep(0, length(PKM$y)) , PMAT)
  EX = tem$x
  WHY = tem$y

  if(PRET==TRUE)
    {
      axis(2,at=WHY, labels=FALSE )
      for(i in 1:length(ydegs))
        mtext(bquote(.(ydegs[i])*degree : .(ymins[i])*minute), at=WHY[i],side=2 )

    }
  else
    {
  
  axis(2,at=WHY, labels=lats, ...)
}
  
  if(GRID==TRUE)
    {
      for( k in lats)
        {
          PKM = GLOB.XY( rep(k, length=lenlon) , lons  )
          
          D = trans3d(PKM$x, PKM$y, rep(0, length(PKM$y)) , PMAT)
          lines(D$x, D$y, lty=2, col=grey(0.8)) 
         
        }
      ## abline(h=PKM$y, lty=2, col=grey(0.8) )
      
    }
  invisible(list(LATS=lats, LONS=lons))
}
####### PersPROJmap(JAPmap, PMAT, WIN=MLOC,  ADD=TRUE, ASP=TRUE, COL=TRUE) 
PersPROJpoints<-function(PNTS, PMAT, pts=NULL, pch=1, COL=FALSE,  dcol=1, LABS=NULL, pos=3, ...)
{
#  plot a map created from a lees map (see above)
 

  if(missing(COL)) { COL = FALSE }
  if(missing(LABS)) { LABS=NULL }
  if(missing(pos)) { pos=3 }
  if(missing(dcol)) { dcol = 1 }

  PKM = GLOB.XY( PNTS$lat,  PNTS$lon)
  
  tem = trans3d(PKM$x, PKM$y, rep(0, length(PKM$y)) , PMAT)
      EX = tem$x
      WHY = tem$y

  points(EX, WHY, pch=pch, col=dcol, ...)

  if(!is.null(LABS))
    {
      text(EX, WHY, labels=LABS, pos=pos, col=dcol, ...)
    }

}
