#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "/home/lees/Progs/nrc/inc/nr.h"

#include "/home/lees/Progs/nrc/inc/nrutil.h"

/**

driver for corner frequency stuff in R

R CMD SHLIB GetCornerFreq.o

dyn.load("/home/lees/Progs/Rc/GetCornerFreq.so")



**/


void dget_abfit(double *x, double *y, int length, double *slope, double *intercept);
double  dget_corner(double *x, double *y, int num_freqs, 
				    int  *K, double *final_ave,
		    double *final_slope, double *final_intercept);

void CALL_DCORN(double *x, double *y, double  *dt, int  *num_freqs, 
	      double  *start, double  *end, double *corn, double *final_ave,
		double *final_slope, double *final_intercept);

#define PI 3.14159265358979
#define SqR(x)   ((x) *(x))


int main()
{

   int num_freqs, K;
   double *spec, *freq;
   double *Lspec, *Lfreq;

   double dt, start, end, corn, final_ave, final_slope, final_intercept;
   double a;
   int i, j;

   double fc , f, ftem, slope, fa, fb, tem, gamma, tstar0, omega0;
   double ave;

   double in1, in2;


   gamma = 2.0;
   start=0.01;
   end=10;
   dt = 0.008;


/*
cat(file="dump.out", 

*/


	spec = dvector((long) 0, (long) 10000);
	freq = dvector((long) 0, (long) 10000);
	Lspec = dvector((long) 0, (long) 10000);
	Lfreq = dvector((long) 0, (long) 10000);

	i = 0;

	while((j=fscanf(stdin, "%lf %lf", &in1, &in2))>1)
	{

	   freq[i]= in1;
	   spec[i]= in2;


	   Lfreq[i] = freq[i];
	   Lspec[i] = spec[i];


	   if(freq[i]>0) Lfreq[i] = log10(freq[i]);
	   if(spec[i]>0) Lspec[i] = log10(spec[i]);

	/* fprintf(stderr, "%d %d %lf %lf %lf %lf\n", i, j, freq[i], spec[i], Lfreq[i], Lspec[i]); */

	   i++;

	}

	num_freqs = i;

	fprintf(stderr, "num=%d\n", num_freqs);



	a = dget_corner(Lfreq, Lspec, num_freqs, 
			&K, &final_ave,
			&final_slope, &final_intercept);


	
	corn = freq[K];

	fprintf(stderr, "output model: %lf  %lf %lf %lf %lf\n", a, corn, final_ave, final_slope, final_intercept );

	slope = final_slope;
	ave = final_ave;
	fc = corn;


	f = fc;
	ftem = f*(PI * log10(2.718281828));
	fa = slope*log10(fc);
	fb = 0.5*log10( 1+ pow( (double) (f/fc),(double)(2*gamma) ));
	tem = -(fa+fb)/ftem;
	
	fprintf(stderr, "at Fc: Log Omega0=%f  Slope=%f  new t*= %e\n", ave, slope, tem);
	
	tstar0 = tem/10.;
	
	omega0 = pow((double) 10, (double) (ave));
	fprintf(stderr, "tstar=%lf omega0=%lf fc=%lf\n", tstar0, omega0, fc);






	return(0);
}
