
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#define NRANSI
#define NR_END 1
#define FREE_ARG char*

/** FUNC DEF */ void jmsg(char *a)

{
  fprintf(stderr,"%s",a);
  fprintf(stderr,"\n");
}




/** FUNC DEF */ float *fjector(long nl, long nh)
/* allocate a float jector with subscript range v[nl..nh] */
{
	float *v;
         fprintf(stderr,"jector: %ld %ld \n", nl, nh);
	v=(float *)malloc((size_t) ((nh-nl+1+NR_END)*sizeof(float)));
	
	if (!v) fprintf(stderr,"allocation failure in jector()\n");
	return v-nl+NR_END;
}



/** FUNC DEF */ double  *djector(long nl, long nh)
/* allocate a double jector with subscript range v[nl..nh] */
{
	double  *v;
         fprintf(stderr,"djector: %ld %ld \n", nl, nh);
	v=(double  *)malloc((size_t) ((nh-nl+1+NR_END)*sizeof(double)));
	
	if (!v) fprintf(stderr,"allocation failure in djector()\n");
	return v-nl+NR_END;
}
/** FUNC DEF */ int  *ijector(long nl, long nh)
/* allocate an int  jector with subscript range v[nl..nh] */
{
	int  *v;
         fprintf(stderr,"ijector: %ld %ld \n", nl, nh);
	v=(int *)malloc((size_t) ((nh-nl+1+NR_END)*sizeof(int)));
	
	if (!v) fprintf(stderr,"allocation failure in jijector()\n");
	return v-nl+NR_END;
}


/** FUNC DEF */ void free_fjector(float *v, long nl, long nh)
/* free a float jector allocated with jector() */
{
	free((FREE_ARG) (v+nl-NR_END));
}

/** FUNC DEF */ void free_ijector(int *v, long nl, long nh)
/* free an int jector allocated with ijector() */
{
	free((FREE_ARG) (v+nl-NR_END));
}
/** FUNC DEF */ void free_djector(double *v, long nl, long nh)
/* free a double jector allocated with djector() */
{
	free((FREE_ARG) (v+nl-NR_END));
}







